/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.debug.core.model;

public class StringMappingData {
    private final int[] dataArray;
    private final int endLine;
    private final int endColumn;

    public StringMappingData(int[] lineColumnDataArray, int endLine, int endColumn) {
        this.dataArray = lineColumnDataArray;
        this.endLine = endLine;
        this.endColumn = endColumn;
    }

    public int getEndLine() {
        return this.endLine;
    }

    public int getEndColumn() {
        return this.endColumn;
    }

    public int findContainingSegment(int line, int col) {
        if (this.dataArray.length == 0) {
            throw new RuntimeException();
        }
        int p1 = 0;
        int p2 = this.dataArray.length - 2;
        while (p1 < p2) {
            int colMiddle;
            int pMiddle = ((p1 / 2 + p2 / 2) / 2 + 1) * 2;
            int lineMiddle = this.dataArray[pMiddle];
            boolean moveP1 = lineMiddle < line ? true : (lineMiddle > line ? false : (colMiddle = this.dataArray[pMiddle + 1]) <= col);
            if (moveP1) {
                p1 = pMiddle;
                continue;
            }
            p2 = pMiddle - 2;
        }
        return p1;
    }

    public int getSegmentBeginLine(int segementId) {
        return this.dataArray[segementId];
    }

    public int getSegmentBeginColumn(int segmentId) {
        return this.dataArray[segmentId + 1];
    }

    public int getLastSegmentId() {
        return this.dataArray.length - 2;
    }

    public static int getNextSegmentId(int segmentId) {
        return segmentId + 2;
    }
}

