/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swt.model.widgets;

import java.util.List;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wb.core.model.AbstractComponentInfo;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.draw2d.geometry.Dimension;
import org.eclipse.wb.draw2d.geometry.Rectangle;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.EnvironmentUtils;
import org.eclipse.wb.internal.core.model.TopBoundsSupport;
import org.eclipse.wb.internal.core.model.property.converter.IntegerConverter;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.core.utils.ast.DomGenerics;
import org.eclipse.wb.internal.swt.model.ModelMessages;
import org.eclipse.wb.internal.swt.model.widgets.CompositeInfo;
import org.eclipse.wb.internal.swt.model.widgets.ShellInfo;
import org.eclipse.wb.internal.swt.support.ContainerSupport;
import org.eclipse.wb.internal.swt.support.ControlSupport;

public abstract class CompositeTopBoundsSupport
extends TopBoundsSupport {
    public CompositeTopBoundsSupport(CompositeInfo composite) {
        super((AbstractComponentInfo)composite);
    }

    public void apply() throws Exception {
        if (this.hasMethodInvocations(new String[]{"setSize(int,int)", "setSize(org.eclipse.swt.graphics.Point)", "pack()"})) {
            ContainerSupport.layout(this.m_component.getObject());
            return;
        }
        Dimension size = this.getResourceSize();
        ControlSupport.setSize(this.m_component.getObject(), size.width, size.height);
    }

    public void setSize(int width, int height) throws Exception {
        this.setResourceSize(width, height);
        if (this.setSizePoint("setSize", width, height)) {
            return;
        }
        String widthSource = IntegerConverter.INSTANCE.toJavaSource((JavaInfo)this.m_component, (Object)width);
        String heightSource = IntegerConverter.INSTANCE.toJavaSource((JavaInfo)this.m_component, (Object)height);
        MethodInvocation invocation = this.m_component.getMethodInvocation("setSize(int,int)");
        if (invocation != null) {
            AstEditor editor = this.m_component.getEditor();
            List arguments = DomGenerics.arguments((MethodInvocation)invocation);
            editor.replaceExpression((Expression)arguments.get(0), widthSource);
            editor.replaceExpression((Expression)arguments.get(1), heightSource);
            return;
        }
        if (this.m_component instanceof ShellInfo) {
            this.m_component.addMethodInvocation("setSize(int,int)", String.valueOf(widthSource) + ", " + heightSource);
        }
    }

    public boolean show() throws Exception {
        Object control = this.m_component.getObject();
        CompositeTopBoundsSupport.show(this.m_component, control);
        return true;
    }

    public static void show(AbstractComponentInfo component, Object control) throws Exception {
        CompositeTopBoundsSupport.showBefore();
        try {
            CompositeTopBoundsSupport.show0(control);
        }
        finally {
            CompositeTopBoundsSupport.showAfter();
        }
    }

    private static void showBefore() throws Exception {
        Shell eclipseShell = DesignerPlugin.getShell();
        if (EnvironmentUtils.IS_MAC) {
            eclipseShell.redraw();
            eclipseShell.update();
            eclipseShell.setRedraw(false);
        }
        eclipseShell.setEnabled(false);
    }

    private static void showAfter() throws Exception {
        Shell eclipseShell = DesignerPlugin.getShell();
        if (EnvironmentUtils.IS_MAC) {
            eclipseShell.setRedraw(true);
        }
        eclipseShell.setEnabled(true);
        eclipseShell.forceActive();
    }

    private static void show0(Object control) throws Exception {
        Object shell = ControlSupport.getShell(control);
        if (control != shell) {
            ContainerSupport.setShellText(shell, ModelMessages.CompositeTopBoundsSupport_wrapperShellText);
            ContainerSupport.setFillLayout(shell);
            Rectangle controlBounds = ControlSupport.getBounds(control);
            Rectangle shellBounds = ContainerSupport.computeTrim(shell, 0, 0, controlBounds.width, controlBounds.height);
            ControlSupport.setSize(shell, shellBounds.width, shellBounds.height);
            ContainerSupport.layout(shell);
        }
        Runnable clearESC = CompositeTopBoundsSupport.closeOnESC(shell);
        org.eclipse.swt.graphics.Rectangle monitorClientArea = DesignerPlugin.getShell().getMonitor().getClientArea();
        Rectangle shellBounds = ControlSupport.getBounds(shell);
        int x = monitorClientArea.x + (monitorClientArea.width - shellBounds.width) / 2;
        int y = monitorClientArea.y + (monitorClientArea.height - shellBounds.height) / 2;
        x = Math.max(x, monitorClientArea.x + 10);
        y = Math.max(y, monitorClientArea.y + 10);
        ControlSupport.setLocation(shell, x, y);
        ContainerSupport.showShell(shell);
        clearESC.run();
    }

    private static Runnable closeOnESC(final Object shell) {
        final Display display = DesignerPlugin.getStandardDisplay();
        final Listener listener = new Listener(){

            public void handleEvent(Event event) {
                if (event.keyCode == 27) {
                    ContainerSupport.closeShell(shell);
                    event.doit = false;
                }
            }
        };
        display.addFilter(1, listener);
        return new Runnable(){

            public void run() {
                display.removeFilter(1, listener);
            }
        };
    }

    protected final boolean setSizePoint(String methodName, int width, int height) throws Exception {
        MethodInvocation invocation = this.m_component.getMethodInvocation(String.valueOf(methodName) + "(org.eclipse.swt.graphics.Point)");
        if (invocation != null) {
            AstEditor editor = this.m_component.getEditor();
            Expression dimensionExpression = (Expression)invocation.arguments().get(0);
            editor.replaceExpression(dimensionExpression, "new org.eclipse.swt.graphics.Point(" + width + ", " + height + ")");
            return true;
        }
        return false;
    }
}

