/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.utils.binding.editors.controls;

import java.util.ArrayList;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.wb.internal.core.utils.binding.IDataEditor;

public final class RadioButtonsEditor
implements IDataEditor {
    private final Button[] m_buttons;
    private final int[] m_values;

    public RadioButtonsEditor(Button[] buttons, int[] values) {
        this.m_buttons = buttons;
        this.m_values = values;
    }

    public RadioButtonsEditor(Button[] buttons) {
        this.m_buttons = buttons;
        this.m_values = this.getDefaultValuesForButtons();
    }

    public RadioButtonsEditor(Composite composite) {
        ArrayList<Control> buttons = new ArrayList<Control>();
        Control[] children = composite.getChildren();
        int i = 0;
        while (i < children.length) {
            Control control = children[i];
            if (control instanceof Button && (control.getStyle() & 0x10) != 0) {
                buttons.add(control);
            }
            ++i;
        }
        this.m_buttons = buttons.toArray(new Button[buttons.size()]);
        this.m_values = this.getDefaultValuesForButtons();
    }

    public Object getValue() {
        int i = 0;
        while (i < this.m_buttons.length) {
            Button button = this.m_buttons[i];
            if (button.getSelection()) {
                return new Integer(this.m_values[i]);
            }
            ++i;
        }
        return new Integer(this.m_values[0]);
    }

    public void setValue(Object value) {
        int intValue = (Integer)value;
        int i = 0;
        while (i < this.m_buttons.length) {
            Button button = this.m_buttons[i];
            button.setSelection(this.m_values[i] == intValue);
            ++i;
        }
    }

    private int[] getDefaultValuesForButtons() {
        int[] values = new int[this.m_buttons.length];
        int i = 0;
        while (i < this.m_buttons.length) {
            values[i] = i;
            ++i;
        }
        return values;
    }
}

