/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.gefTree;

import java.util.List;
import org.eclipse.wb.core.gef.IEditPartConfigurator;
import org.eclipse.wb.core.gefTree.part.ObjectEditPart;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.gef.core.EditPart;
import org.eclipse.wb.gef.core.IEditPartFactory;
import org.eclipse.wb.internal.core.gefTree.part.menu.MenuEditPart;
import org.eclipse.wb.internal.core.gefTree.part.menu.MenuItemEditPart;
import org.eclipse.wb.internal.core.model.menu.IMenuInfo;
import org.eclipse.wb.internal.core.model.menu.IMenuItemInfo;
import org.eclipse.wb.internal.core.model.menu.MenuObjectInfoUtils;
import org.eclipse.wb.internal.core.utils.external.ExternalFactoriesHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EditPartFactory
implements IEditPartFactory {
    public static final EditPartFactory INSTANCE = new EditPartFactory();

    private EditPartFactory() {
    }

    @Override
    public EditPart createEditPart(EditPart context, Object model) {
        if (model == null) {
            return null;
        }
        EditPart editPart = this.createEditPartPure(context, model);
        if (editPart != null) {
            EditPartFactory.configureEditPart(context, editPart);
            return editPart;
        }
        return null;
    }

    private EditPart createEditPartPure(EditPart context, Object model) {
        if (model instanceof ObjectInfo) {
            ObjectInfo objectInfo = (ObjectInfo)model;
            IMenuInfo menuObject = MenuObjectInfoUtils.getMenuInfo(model);
            if (menuObject != null) {
                return new MenuEditPart(objectInfo, menuObject);
            }
            IMenuItemInfo itemObject = MenuObjectInfoUtils.getMenuItemInfo(model);
            if (itemObject != null) {
                return new MenuItemEditPart(objectInfo, itemObject);
            }
        }
        for (IEditPartFactory factory : EditPartFactory.getFactories()) {
            EditPart editPart = factory.createEditPart(context, model);
            if (editPart == null) continue;
            return editPart;
        }
        if (model instanceof ObjectInfo) {
            return new ObjectEditPart((ObjectInfo)model);
        }
        return null;
    }

    private static List<IEditPartFactory> getFactories() {
        return ExternalFactoriesHelper.getElementsInstances(IEditPartFactory.class, "org.eclipse.wb.core.treeEditPartFactories", "factory");
    }

    private static void configureEditPart(EditPart context, EditPart editPart) {
        List<IEditPartConfigurator> configurators = ExternalFactoriesHelper.getElementsInstances(IEditPartConfigurator.class, "org.eclipse.wb.core.treeEditPartConfigurators", "configurator");
        for (IEditPartConfigurator configurator : configurators) {
            configurator.configure(context, editPart);
        }
    }
}

