/**
 */
package org.eclipse.viatra.query.runtime.rete.recipes;


/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Indexer Based Aggregator Recipe</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * Represents a (compound) node that performs an aggregation operation.
 * Parent must be a ProjectionIndexer, which defines how tuples are to be aggregated.
 * Usable only through an Join with an AggregatorIndexer as the right parent
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.viatra.query.runtime.rete.recipes.IndexerBasedAggregatorRecipe#getParent <em>Parent</em>}</li>
 * </ul>
 *
 * @see org.eclipse.viatra.query.runtime.rete.recipes.RecipesPackage#getIndexerBasedAggregatorRecipe()
 * @model abstract="true"
 * @generated
 */
public interface IndexerBasedAggregatorRecipe extends ReteNodeRecipe {
	/**
	 * Returns the value of the '<em><b>Parent</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Parent</em>' containment reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Parent</em>' containment reference.
	 * @see #setParent(ProjectionIndexerRecipe)
	 * @see org.eclipse.viatra.query.runtime.rete.recipes.RecipesPackage#getIndexerBasedAggregatorRecipe_Parent()
	 * @model containment="true"
	 * @generated
	 */
	ProjectionIndexerRecipe getParent();

	/**
	 * Sets the value of the '{@link org.eclipse.viatra.query.runtime.rete.recipes.IndexerBasedAggregatorRecipe#getParent <em>Parent</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Parent</em>' containment reference.
	 * @see #getParent()
	 * @generated
	 */
	void setParent(ProjectionIndexerRecipe value);

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @model kind="operation" unique="false"
	 *        annotation="http://www.eclipse.org/emf/2002/GenModel body='<%org.eclipse.viatra.query.runtime.rete.recipes.ProjectionIndexerRecipe%> _parent = this.getParent();\n<%org.eclipse.viatra.query.runtime.rete.recipes.Mask%> _mask = _parent.getMask();\n<%org.eclipse.emf.common.util.EList%><<%java.lang.Integer%>> _sourceIndices = _mask.getSourceIndices();\nint _size = _sourceIndices.size();\nreturn (1 + _size);'"
	 * @generated
	 */
	int getArity();

} // IndexerBasedAggregatorRecipe
