/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.genericeditor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.ui.internal.genericeditor.CompositeTextHover;
import org.eclipse.ui.internal.genericeditor.GenericEditorPlugin;
import org.eclipse.ui.internal.genericeditor.OrderedExtensionComparator;

public final class TextHoverRegistry {
    private static final String EXTENSION_POINT_ID = "org.eclipse.ui.genericeditor.hoverProviders";
    private SortedSet<TextHoverExtension> extensions;
    private boolean outOfSync = true;

    public TextHoverRegistry(IPreferenceStore preferenceStore) {
        Platform.getExtensionRegistry().addRegistryChangeListener(new IRegistryChangeListener(){

            public void registryChanged(IRegistryChangeEvent event) {
                TextHoverRegistry.this.outOfSync = true;
            }
        }, EXTENSION_POINT_ID);
    }

    public ITextHover getAvailableHover(ISourceViewer sourceViewer, Set<IContentType> contentTypes) {
        if (this.outOfSync) {
            this.sync();
        }
        ArrayList<TextHoverExtension> hoversToConsider = new ArrayList<TextHoverExtension>();
        for (TextHoverExtension ext : this.extensions) {
            if (!contentTypes.contains(ext.targetContentType)) continue;
            hoversToConsider.add(ext);
        }
        if (!hoversToConsider.isEmpty()) {
            return new CompositeTextHover(hoversToConsider);
        }
        return null;
    }

    private void sync() {
        Set<Object> toRemoveExtensions = new HashSet();
        Map<Object, Object> ext = new HashMap();
        if (this.extensions != null) {
            ext = this.extensions.stream().collect(Collectors.toMap(TextHoverExtension::getConfigurationElement, Function.identity()));
            toRemoveExtensions = ext.keySet();
        }
        IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_POINT_ID);
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement iConfigurationElement = iConfigurationElementArray[n2];
            toRemoveExtensions.remove(iConfigurationElement);
            if (!ext.containsKey(iConfigurationElement)) {
                try {
                    ext.put(iConfigurationElement, new TextHoverExtension(iConfigurationElement));
                }
                catch (Exception ex) {
                    GenericEditorPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.ui.genericeditor", ex.getMessage(), (Throwable)ex));
                }
            }
            ++n2;
        }
        for (IConfigurationElement iConfigurationElement : toRemoveExtensions) {
            ext.remove(iConfigurationElement);
        }
        OrderedExtensionComparator orderedExtensionComparator = new OrderedExtensionComparator(ext.values());
        this.extensions = new TreeSet<TextHoverExtension>(orderedExtensionComparator);
        this.extensions.addAll(ext.values());
        this.outOfSync = false;
    }

    static class TextHoverExtension {
        private static final String CONTENT_TYPE_ATTRIBUTE = "contentType";
        private static final String CLASS_ATTRIBUTE = "class";
        private static final String ID_ATTRIBUTE = "id";
        private static final String IS_BEFORE_ATTRIBUTE = "isBefore";
        private static final String IS_AFTER_ATTRIBUTE = "isAfter";
        private IConfigurationElement extension;
        private IContentType targetContentType;
        private ITextHover delegate;
        private String id;
        private String isBefore;
        private String isAfter;

        public TextHoverExtension(IConfigurationElement extension) throws Exception {
            this.extension = extension;
            this.targetContentType = Platform.getContentTypeManager().getContentType(extension.getAttribute(CONTENT_TYPE_ATTRIBUTE));
            this.id = extension.getAttribute(ID_ATTRIBUTE);
            this.isBefore = extension.getAttribute(IS_BEFORE_ATTRIBUTE);
            this.isAfter = extension.getAttribute(IS_AFTER_ATTRIBUTE);
        }

        public ITextHover getDelegate() {
            if (this.delegate == null) {
                try {
                    this.delegate = (ITextHover)this.extension.createExecutableExtension(CLASS_ATTRIBUTE);
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
            return this.delegate;
        }

        public String getId() {
            if (this.id != null) {
                return this.id;
            }
            return String.valueOf(this.extension.getContributor().getName()) + '@' + this.toString();
        }

        public String getIsAfter() {
            return this.isAfter;
        }

        public String getIsBefore() {
            return this.isBefore;
        }

        IConfigurationElement getConfigurationElement() {
            return this.extension;
        }
    }
}

