/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.event.matching;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import com.google.common.collect.Table;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.osgi.util.NLS;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.tmf.core.Activator;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.matching.EventMatchingBuildRequest;
import org.eclipse.tracecompass.tmf.core.event.matching.IEventMatchingKey;
import org.eclipse.tracecompass.tmf.core.event.matching.IMatchProcessingUnit;
import org.eclipse.tracecompass.tmf.core.event.matching.ITmfEventMatching;
import org.eclipse.tracecompass.tmf.core.event.matching.ITmfMatchEventDefinition;
import org.eclipse.tracecompass.tmf.core.event.matching.Messages;
import org.eclipse.tracecompass.tmf.core.event.matching.TmfEventDependency;
import org.eclipse.tracecompass.tmf.core.event.matching.TmfEventMatches;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;

public class TmfEventMatching
implements ITmfEventMatching {
    private static final Set<ITmfMatchEventDefinition> MATCH_DEFINITIONS = new HashSet<ITmfMatchEventDefinition>();
    private final @NonNull Collection<@NonNull ITmfTrace> fTraces;
    private final IMatchProcessingUnit fMatches;
    private final Multimap<ITmfTrace, ITmfMatchEventDefinition> fMatchMap = HashMultimap.create();
    private final Table<ITmfTrace, IEventMatchingKey, ITmfEvent> fUnmatchedIn = HashBasedTable.create();
    private final Table<ITmfTrace, IEventMatchingKey, ITmfEvent> fUnmatchedOut = HashBasedTable.create();

    public TmfEventMatching(Collection<@NonNull ITmfTrace> traces) {
        this(traces, new TmfEventMatches());
    }

    public TmfEventMatching(Collection<@NonNull ITmfTrace> traces, IMatchProcessingUnit tmfEventMatches) {
        if (tmfEventMatches == null) {
            throw new IllegalArgumentException();
        }
        this.fTraces = new HashSet<ITmfTrace>(traces);
        this.fMatches = tmfEventMatches;
    }

    protected Collection<ITmfTrace> getTraces() {
        return new HashSet<ITmfTrace>(this.fTraces);
    }

    protected Collection<ITmfTrace> getIndividualTraces() {
        HashSet<ITmfTrace> traces = new HashSet<ITmfTrace>();
        for (ITmfTrace trace : this.fTraces) {
            traces.addAll(TmfTraceManager.getTraceSet(trace));
        }
        return traces;
    }

    protected IMatchProcessingUnit getProcessingUnit() {
        return this.fMatches;
    }

    protected Collection<ITmfMatchEventDefinition> getEventDefinitions(ITmfTrace trace) {
        return ImmutableList.copyOf((Collection)this.fMatchMap.get((Object)trace));
    }

    public void initMatching() {
        this.fUnmatchedIn.clear();
        this.fUnmatchedOut.clear();
        this.fMatches.init(this.fTraces);
        for (ITmfTrace trace : this.getIndividualTraces()) {
            for (ITmfMatchEventDefinition def : MATCH_DEFINITIONS) {
                if (!def.canMatchTrace(trace)) continue;
                this.fMatchMap.put((Object)trace, (Object)def);
            }
        }
    }

    protected void finalizeMatching() {
        this.fMatches.matchingEnded();
    }

    public String toString() {
        String cr = System.getProperty("line.separator");
        StringBuilder b = new StringBuilder();
        b.append(this.getProcessingUnit());
        int i = 0;
        for (ITmfTrace trace : this.getIndividualTraces()) {
            b.append("Trace " + i++ + ":" + cr + "  " + this.fUnmatchedIn.row((Object)trace).size() + " unmatched incoming events" + cr + "  " + this.fUnmatchedOut.row((Object)trace).size() + " unmatched outgoing events" + cr);
        }
        return b.toString();
    }

    public void matchEvent(ITmfEvent event, ITmfTrace trace, @NonNull IProgressMonitor monitor) {
        Table<ITmfTrace, IEventMatchingKey, ITmfEvent> companionTbl;
        Table<ITmfTrace, IEventMatchingKey, ITmfEvent> unmatchedTbl;
        ITmfMatchEventDefinition def = null;
        Direction evType = null;
        for (ITmfMatchEventDefinition oneDef : this.getEventDefinitions(event.getTrace())) {
            def = oneDef;
            evType = def.getDirection(event);
            if (evType != null) break;
        }
        if (def == null || evType == null) {
            return;
        }
        IEventMatchingKey eventKey = def.getEventKey(event);
        if (eventKey == null) {
            return;
        }
        switch (evType) {
            case EFFECT: {
                unmatchedTbl = this.fUnmatchedIn;
                companionTbl = this.fUnmatchedOut;
                break;
            }
            case CAUSE: {
                unmatchedTbl = this.fUnmatchedOut;
                companionTbl = this.fUnmatchedIn;
                break;
            }
            default: {
                return;
            }
        }
        boolean found = false;
        TmfEventDependency dep = null;
        for (ITmfTrace mTrace : this.getIndividualTraces()) {
            if (!companionTbl.contains((Object)mTrace, (Object)eventKey)) continue;
            found = true;
            ITmfEvent companionEvent = (ITmfEvent)companionTbl.get((Object)mTrace, (Object)eventKey);
            companionTbl.remove((Object)mTrace, (Object)eventKey);
            switch (evType) {
                case EFFECT: {
                    dep = new TmfEventDependency(companionEvent, event);
                    break;
                }
                case CAUSE: {
                    dep = new TmfEventDependency(event, companionEvent);
                    break;
                }
            }
        }
        if (found) {
            this.getProcessingUnit().addMatch((TmfEventDependency)NonNullUtils.checkNotNull(dep));
            monitor.subTask(NLS.bind((String)Messages.TmfEventMatching_MatchesFound, (Object)this.getProcessingUnit().countMatches()));
        } else if (!unmatchedTbl.contains((Object)event.getTrace(), (Object)eventKey)) {
            unmatchedTbl.put((Object)event.getTrace(), (Object)eventKey, (Object)event);
        }
    }

    @Override
    public boolean matchEvents() {
        if (this.fTraces.size() <= 0) {
            return false;
        }
        this.initMatching();
        Job job = new Job(Messages.TmfEventMatching_MatchingEvents){

            protected IStatus run(IProgressMonitor monitor) {
                for (ITmfTrace trace : TmfEventMatching.this.fTraces) {
                    monitor.beginTask(NLS.bind((String)Messages.TmfEventMatching_LookingEventsFrom, (Object)trace.getName()), -1);
                    this.setName(NLS.bind((String)Messages.TmfEventMatching_RequestingEventsFrom, (Object)trace.getName()));
                    EventMatchingBuildRequest request = new EventMatchingBuildRequest(TmfEventMatching.this, trace, monitor);
                    trace.sendRequest(request);
                    try {
                        request.waitForCompletion();
                    }
                    catch (InterruptedException e) {
                        Activator.logInfo(e.getMessage());
                    }
                    if (!monitor.isCanceled()) continue;
                    return Status.CANCEL_STATUS;
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
        try {
            job.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.finalizeMatching();
        return true;
    }

    public static void registerMatchObject(ITmfMatchEventDefinition match) {
        MATCH_DEFINITIONS.add(match);
    }

    public static enum Direction {
        CAUSE,
        EFFECT;

    }
}

