/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.core.synchronization.graph;

import java.math.BigDecimal;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.tracecompass.internal.tmf.core.synchronization.ITmfTimestampTransformInvertible;
import org.eclipse.tracecompass.internal.tmf.core.synchronization.graph.Edge;
import org.eclipse.tracecompass.internal.tmf.core.synchronization.graph.SyncGraph;
import org.eclipse.tracecompass.tmf.core.synchronization.ITmfTimestampTransform;
import org.eclipse.tracecompass.tmf.core.synchronization.TimestampTransformFactory;

public class SyncSpanningTree {
    private final SyncGraph<String, ITmfTimestampTransform> fSyncGraph;
    private SortedSet<String> fHosts = new TreeSet<String>();
    private final String fRootNode;

    public SyncSpanningTree() {
        this(null);
    }

    public SyncSpanningTree(String rootNode) {
        this.fSyncGraph = new SyncGraph();
        this.fRootNode = rootNode;
    }

    public void addSynchronization(String hostFrom, String hostTo, ITmfTimestampTransform transform, BigDecimal accuracy) {
        this.fHosts.add(hostFrom);
        this.fHosts.add(hostTo);
        this.fSyncGraph.addEdge(hostFrom, hostTo, transform);
        if (transform instanceof ITmfTimestampTransformInvertible) {
            this.fSyncGraph.addEdge(hostTo, hostFrom, ((ITmfTimestampTransformInvertible)transform).inverse());
        }
    }

    public ITmfTimestampTransform getTimestampTransform(String host) {
        ITmfTimestampTransform result = TimestampTransformFactory.getDefaultTransform();
        String rootNode = this.getRootNode();
        if (rootNode != null) {
            List<Edge<String, ITmfTimestampTransform>> path = this.fSyncGraph.path(rootNode, host);
            for (Edge<String, ITmfTimestampTransform> edge : path) {
                result = result.composeWith(edge.getLabel());
            }
        }
        return result;
    }

    private String getRootNode() {
        if (this.fHosts.size() == 0) {
            return null;
        }
        if (this.fRootNode == null) {
            return this.fHosts.first();
        }
        return this.fRootNode;
    }

    public boolean isConnected() {
        return this.fSyncGraph.isConnected();
    }
}

