/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.operation.file;

import java.io.File;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.svn.core.SVNMessages;
import org.eclipse.team.svn.core.connector.ISVNConnector;
import org.eclipse.team.svn.core.connector.ISVNProgressMonitor;
import org.eclipse.team.svn.core.connector.SVNDepth;
import org.eclipse.team.svn.core.operation.IActionOperation;
import org.eclipse.team.svn.core.operation.SVNConflictDetectionProgressMonitor;
import org.eclipse.team.svn.core.operation.file.AbstractFileConflictDetectionOperation;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.core.utility.SVNUtility;

public class SwitchOperation
extends AbstractFileConflictDetectionOperation {
    protected IRepositoryResource destination;
    protected long options;

    public SwitchOperation(File file, IRepositoryResource destination, boolean ignoreExternals) {
        this(file, destination, ignoreExternals ? 1L : 0L);
    }

    public SwitchOperation(File file, IRepositoryResource destination, long options) {
        super("Operation_SwitchFile", SVNMessages.class, new File[]{file});
        this.destination = destination;
        this.options = options & 0x4003L;
    }

    protected void runImpl(IProgressMonitor monitor) throws Exception {
        File file = this.operableData()[0];
        IRepositoryLocation location = this.destination.getRepositoryLocation();
        ISVNConnector proxy = location.acquireSVNProxy();
        this.writeToConsole(0, "svn switch \"" + this.destination.getUrl() + "\" \"" + FileUtility.normalizePath(file.getAbsolutePath()) + "\" -r " + this.destination.getSelectedRevision() + ISVNConnector.Options.asCommandLine(this.options) + FileUtility.getUsernameParam(location.getUsername()) + "\n");
        try {
            proxy.switchTo(file.getAbsolutePath(), SVNUtility.getEntryRevisionReference(this.destination), SVNDepth.infinityOrFiles(true), this.options, new ConflictDetectionProgressMonitor(this, monitor, null));
        }
        finally {
            location.releaseSVNProxy(proxy);
        }
    }

    protected class ConflictDetectionProgressMonitor
    extends SVNConflictDetectionProgressMonitor {
        public ConflictDetectionProgressMonitor(IActionOperation parent, IProgressMonitor monitor, IPath root) {
            super(parent, monitor, root);
        }

        protected void processConflict(ISVNProgressMonitor.ItemState state) {
            SwitchOperation.this.hasUnresolvedConflict = true;
        }
    }
}

