/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.utils;

import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.tcf.te.ui.activator.UIPlugin;
import org.eclipse.tcf.te.ui.search.FilteringImageDescriptor;
import org.eclipse.tcf.te.ui.search.QuickFilter;
import org.eclipse.tcf.te.ui.search.TreeViewerSearchDialog;
import org.eclipse.ui.PlatformUI;

public class TreeViewerUtil {
    static volatile Method methodGetSortedChildren;

    static {
        SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

            public void handleException(Throwable exception) {
            }

            public void run() throws Exception {
                methodGetSortedChildren = AbstractTreeViewer.class.getDeclaredMethod("getSortedChildren", Object.class);
                AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        methodGetSortedChildren.setAccessible(true);
                        return null;
                    }
                });
            }
        });
    }

    public static Image getDecoratedImage(Image image, TreeViewer viewer, TreePath path) {
        FilteringImageDescriptor descriptor = new FilteringImageDescriptor(UIPlugin.getDefault().getImageRegistry(), image);
        return UIPlugin.getSharedImage(descriptor);
    }

    public static String getDecoratedText(String text, TreeViewer viewer, TreePath path) {
        String pattern = TreeViewerUtil.getFilteringString(viewer, path);
        if (pattern != null) {
            return String.valueOf(text) + " Filtered (" + pattern + ")";
        }
        return text;
    }

    public static void doReset(TreeViewer viewer) {
        ViewerFilter[] vFilters = viewer.getFilters();
        Map filters = (Map)viewer.getData("quick.filter");
        if (filters != null && vFilters != null && !filters.isEmpty() && vFilters.length > 0) {
            ArrayList<ViewerFilter> filterList = new ArrayList<ViewerFilter>(Arrays.asList(vFilters));
            for (Map.Entry entry : filters.entrySet()) {
                QuickFilter quickFilter = (QuickFilter)entry.getValue();
                filterList.remove(quickFilter);
                quickFilter.setPattern(null);
            }
            vFilters = filterList.toArray(new ViewerFilter[filterList.size()]);
            viewer.setFilters(vFilters);
        }
        viewer.setData("quick.filter", null);
    }

    public static void doCommonViewerFilter(TreeViewer viewer) {
        TreePath rootPath = TreeViewerUtil.getSelectedPath(viewer);
        TreePath root = TreeViewerUtil.getViewFilterRoot(viewer, rootPath);
        if (root != null && (root.getSegmentCount() == 0 || viewer.getExpandedState((Object)root))) {
            QuickFilter filter;
            HashMap<TreePath, QuickFilter> filters = (HashMap<TreePath, QuickFilter>)viewer.getData("quick.filter");
            if (filters == null) {
                filters = new HashMap<TreePath, QuickFilter>();
                viewer.setData("quick.filter", filters);
            }
            if ((filter = (QuickFilter)filters.get(root)) == null) {
                filter = new QuickFilter(viewer, root);
                filters.put(root, filter);
            }
            filter.showFilterPopup(false);
        }
    }

    public static void doEditorFilter(TreeViewer viewer) {
        TreePath rootPath = TreeViewerUtil.getSelectedPath(viewer);
        TreePath root = TreeViewerUtil.getEditorFilterRoot(viewer, rootPath);
        if (root != null && (root.getSegmentCount() == 0 || viewer.getExpandedState((Object)root))) {
            QuickFilter filter;
            HashMap<TreePath, QuickFilter> filters = (HashMap<TreePath, QuickFilter>)viewer.getData("quick.filter");
            if (filters == null) {
                filters = new HashMap<TreePath, QuickFilter>();
                viewer.setData("quick.filter", filters);
            }
            if ((filter = (QuickFilter)filters.get(root)) == null) {
                filter = new QuickFilter(viewer, root);
                filters.put(root, filter);
            }
            filter.showFilterPopup(root.getSegmentCount() == 0);
        }
    }

    public static void doSearch(TreeViewer viewer) {
        TreePath rootPath = TreeViewerUtil.getSelectedPath(viewer);
        rootPath = TreeViewerUtil.getSearchRoot(viewer, rootPath);
        Assert.isNotNull((Object)rootPath);
        TreeViewerSearchDialog dialog = new TreeViewerSearchDialog(viewer, rootPath);
        dialog.open();
    }

    public static boolean isFiltering(TreeViewer viewer, TreePath path) {
        QuickFilter filter;
        Map filters;
        if (path != null && (filters = (Map)viewer.getData("quick.filter")) != null && (filter = (QuickFilter)filters.get(path)) != null) {
            return filter.isFiltering(path);
        }
        return false;
    }

    public static boolean isFiltering(TreeViewer viewer) {
        Map filters = (Map)viewer.getData("quick.filter");
        if (filters != null && !filters.isEmpty()) {
            for (Map.Entry entry : filters.entrySet()) {
                TreePath path = (TreePath)entry.getKey();
                QuickFilter filter = (QuickFilter)entry.getValue();
                if (filter == null || !filter.isFiltering(path)) continue;
                return true;
            }
        }
        return false;
    }

    private static TreePath getViewFilterRoot(TreeViewer viewer, TreePath rootPath) {
        if (rootPath != null) {
            if (!TreeViewerUtil.isEligibleRoot(rootPath, viewer)) {
                return null;
            }
            if (rootPath.getSegmentCount() == 0) {
                viewer.setSelection((ISelection)StructuredSelection.EMPTY);
                return TreePath.EMPTY;
            }
            return rootPath;
        }
        viewer.setSelection((ISelection)StructuredSelection.EMPTY);
        return TreePath.EMPTY;
    }

    private static TreePath getEditorFilterRoot(TreeViewer viewer, TreePath rootPath) {
        if (rootPath != null) {
            if (!TreeViewerUtil.isEligibleRoot(rootPath, viewer)) {
                return TreePath.EMPTY;
            }
            if (rootPath.getSegmentCount() == 0) {
                return TreePath.EMPTY;
            }
            return rootPath;
        }
        return TreePath.EMPTY;
    }

    public static Object[] getSortedChildren(final TreeViewer viewer, final Object parentElementOrTreePath) {
        if (Display.getCurrent() != null) {
            try {
                if (methodGetSortedChildren != null) {
                    return (Object[])methodGetSortedChildren.invoke((Object)viewer, parentElementOrTreePath);
                }
            }
            catch (Exception exception) {}
            return new Object[0];
        }
        final Object[][] result = new Object[1][];
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                result[0] = TreeViewerUtil.getSortedChildren(viewer, parentElementOrTreePath);
            }
        });
        return result[0];
    }

    private static TreePath getSearchRoot(TreeViewer viewer, TreePath rootPath) {
        if (rootPath != null) {
            if (!TreeViewerUtil.hasChildren(rootPath, viewer)) {
                rootPath = rootPath.getParentPath();
            }
            if (rootPath.getSegmentCount() == 0) {
                return new TreePath(new Object[]{viewer.getInput()});
            }
            return rootPath;
        }
        return new TreePath(new Object[]{viewer.getInput()});
    }

    private static boolean isEligibleRoot(TreePath root, TreeViewer viewer) {
        if (viewer.getExpandedState((Object)root)) {
            return TreeViewerUtil.hasChildren(root, viewer);
        }
        return false;
    }

    private static boolean hasChildren(TreePath root, TreeViewer viewer) {
        Object rootElement;
        ITreeContentProvider contentProvider = (ITreeContentProvider)viewer.getContentProvider();
        Object[] children = contentProvider.getChildren(rootElement = root.getLastSegment());
        if (children != null && children.length > 0) {
            ViewerFilter[] filters = viewer.getFilters();
            if (filters != null && filters.length > 0) {
                ViewerFilter[] viewerFilterArray = filters;
                int n = filters.length;
                int n2 = 0;
                while (n2 < n) {
                    ViewerFilter filter = viewerFilterArray[n2];
                    if (!(filter instanceof QuickFilter)) {
                        children = filter.filter((Viewer)viewer, rootElement, children);
                    }
                    if (children == null || children.length == 0) break;
                    ++n2;
                }
            }
            return children != null && children.length > 0;
        }
        return false;
    }

    private static TreePath getSelectedPath(TreeViewer viewer) {
        TreeSelection treeSelection;
        TreePath[] paths;
        ISelection selection = viewer.getSelection();
        if (selection instanceof TreeSelection && (paths = (treeSelection = (TreeSelection)selection).getPaths()) != null && paths.length > 0) {
            return paths[0];
        }
        return null;
    }

    public static String getFilteringString(TreeViewer viewer, TreePath path) {
        QuickFilter filter;
        Map filters = (Map)viewer.getData("quick.filter");
        if (filters != null && (filter = (QuickFilter)filters.get(path)) != null) {
            return filter.getFilterText();
        }
        return null;
    }
}

