/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.processes.core.model.runtime.services;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.tcf.te.runtime.callback.Callback;
import org.eclipse.tcf.te.runtime.interfaces.callback.ICallback;
import org.eclipse.tcf.te.runtime.model.interfaces.IContainerModelNode;
import org.eclipse.tcf.te.runtime.model.interfaces.IModelNode;
import org.eclipse.tcf.te.runtime.model.interfaces.contexts.IAsyncRefreshableCtx;
import org.eclipse.tcf.te.tcf.core.model.interfaces.IModel;
import org.eclipse.tcf.te.tcf.core.model.interfaces.services.IModelRefreshService;
import org.eclipse.tcf.te.tcf.core.model.services.AbstractModelService;
import org.eclipse.tcf.te.tcf.processes.core.activator.CoreBundleActivator;
import org.eclipse.tcf.te.tcf.processes.core.model.interfaces.IProcessContextNode;
import org.eclipse.tcf.te.tcf.processes.core.model.interfaces.runtime.IRuntimeModel;
import org.eclipse.tcf.te.tcf.processes.core.model.interfaces.runtime.IRuntimeModelLookupService;
import org.osgi.framework.Bundle;

public class RuntimeModelLookupService
extends AbstractModelService<IRuntimeModel>
implements IRuntimeModelLookupService {
    public RuntimeModelLookupService(IRuntimeModel model) {
        super((IModel)model);
    }

    public IModelNode lkupModelNodeByUUID(UUID uuid) {
        return ((IRuntimeModel)this.getModel()).find(uuid);
    }

    public IModelNode[] lkupModelNodesById(String id) {
        Assert.isNotNull((Object)id);
        ArrayList<IModelNode> nodes = new ArrayList<IModelNode>();
        nodes.addAll(this.findInContainerByIdRecursively((IContainerModelNode)this.getModel(), id));
        return nodes.toArray(new IModelNode[nodes.size()]);
    }

    private List<IModelNode> findInContainerByIdRecursively(IContainerModelNode container, String id) {
        Assert.isNotNull((Object)container);
        Assert.isNotNull((Object)id);
        ArrayList<IModelNode> nodes = new ArrayList<IModelNode>();
        List candidates = container.getChildren(IModelNode.class);
        for (IModelNode candidate : candidates) {
            if (id.equals(candidate.getStringProperty("id")) && !nodes.contains(candidate)) {
                nodes.add(candidate);
            }
            if (!(candidate instanceof IContainerModelNode)) continue;
            nodes.addAll(this.findInContainerByIdRecursively((IContainerModelNode)candidate, id));
        }
        return nodes;
    }

    public IModelNode[] lkupModelNodesByName(String name) {
        Assert.isNotNull((Object)name);
        ArrayList<IModelNode> nodes = new ArrayList<IModelNode>();
        nodes.addAll(this.findInContainerByNameRecursively((IContainerModelNode)this.getModel(), name));
        return nodes.toArray(new IModelNode[nodes.size()]);
    }

    private List<IModelNode> findInContainerByNameRecursively(IContainerModelNode container, String name) {
        Assert.isNotNull((Object)container);
        Assert.isNotNull((Object)name);
        ArrayList<IModelNode> nodes = new ArrayList<IModelNode>();
        List candidates = container.getChildren(IModelNode.class);
        for (IModelNode candidate : candidates) {
            if (name.equals(candidate.getName()) && !nodes.contains(candidate)) {
                nodes.add(candidate);
            }
            if (!(candidate instanceof IContainerModelNode)) continue;
            nodes.addAll(this.findInContainerByNameRecursively((IContainerModelNode)candidate, name));
        }
        return nodes;
    }

    @Override
    public void lkupModelNodeByCapability(final String[] capabilities, final ICallback callback) {
        Assert.isNotNull((Object)capabilities);
        Assert.isTrue((capabilities.length > 0 ? 1 : 0) != 0);
        Assert.isNotNull((Object)callback);
        IAsyncRefreshableCtx refreshable = (IAsyncRefreshableCtx)((IRuntimeModel)this.getModel()).getAdapter(IAsyncRefreshableCtx.class);
        if (refreshable != null && Boolean.getBoolean("sm.trace.rootnodelkup")) {
            String message = "RuntimeModelLookupService: lkupModelNodeByCapability: runtime model refreshable=" + refreshable + ", capabilities=" + Arrays.deepToString(capabilities);
            Status s = new Status(1, CoreBundleActivator.getUniqueIdentifier(), message);
            Platform.getLog((Bundle)CoreBundleActivator.getContext().getBundle()).log((IStatus)s);
        }
        if (refreshable != null && refreshable.getQueryState(IAsyncRefreshableCtx.QueryType.CHILD_LIST) != IAsyncRefreshableCtx.QueryState.DONE) {
            ((IModelRefreshService)((IRuntimeModel)this.getModel()).getService(IModelRefreshService.class)).refresh((ICallback)new Callback(){

                protected void internalDone(Object caller, IStatus status) {
                    callback.setResult((Object)RuntimeModelLookupService.this.findInContainerByCapabilitiesRecursively((IContainerModelNode)RuntimeModelLookupService.this.getModel(), capabilities));
                    callback.done((Object)RuntimeModelLookupService.this, Status.OK_STATUS);
                }
            });
        } else {
            callback.setResult((Object)this.findInContainerByCapabilitiesRecursively((IContainerModelNode)this.getModel(), capabilities));
            callback.done((Object)this, Status.OK_STATUS);
        }
    }

    protected IProcessContextNode findInContainerByCapabilitiesRecursively(IContainerModelNode container, String[] capabilities) {
        Assert.isNotNull((Object)container);
        Assert.isNotNull((Object)capabilities);
        if (Boolean.getBoolean("sm.trace.rootnodelkup")) {
            String message = "RuntimeModelLookupService: findInContainerByCapabilitiesRecursively: container=" + container + ", capabilities=" + Arrays.deepToString(capabilities);
            Status s = new Status(1, CoreBundleActivator.getUniqueIdentifier(), message);
            Platform.getLog((Bundle)CoreBundleActivator.getContext().getBundle()).log((IStatus)s);
        }
        IProcessContextNode node = null;
        List candidates = container.getChildren(IProcessContextNode.class);
        for (IProcessContextNode candidate : candidates) {
            Map caps = (Map)candidate.getProperty("capabilities");
            if (Boolean.getBoolean("sm.trace.rootnodelkup")) {
                String message = "RuntimeModelLookupService: findInContainerByCapabilitiesRecursively:        candidate=" + candidate + ", capabilities=" + caps.keySet();
                Status s = new Status(1, CoreBundleActivator.getUniqueIdentifier(), message);
                Platform.getLog((Bundle)CoreBundleActivator.getContext().getBundle()).log((IStatus)s);
            }
            if (caps == null) continue;
            boolean allFound = true;
            String[] stringArray = capabilities;
            int n = capabilities.length;
            int n2 = 0;
            while (n2 < n) {
                String capability = stringArray[n2];
                if (!caps.containsKey(capability) || !Boolean.parseBoolean(caps.get(capability).toString())) {
                    allFound = false;
                    break;
                }
                ++n2;
            }
            if (!allFound) continue;
            node = candidate;
            break;
        }
        if (node == null) {
            for (IProcessContextNode candidate : candidates) {
                node = this.findInContainerByCapabilitiesRecursively(candidate, capabilities);
                if (node != null) break;
            }
        }
        if (Boolean.getBoolean("sm.trace.rootnodelkup")) {
            String message = "RuntimeModelLookupService: findInContainerByCapabilitiesRecursively:        node=" + node;
            Status s = new Status(1, CoreBundleActivator.getUniqueIdentifier(), message);
            Platform.getLog((Bundle)CoreBundleActivator.getContext().getBundle()).log((IStatus)s);
        }
        return node;
    }
}

