/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.runtime.persistence.delegates;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.tcf.te.runtime.persistence.PersistenceManager;
import org.eclipse.tcf.te.runtime.persistence.interfaces.IVariableDelegate;
import org.eclipse.tcf.te.runtime.persistence.interfaces.IVariableProvider;
import org.eclipse.tcf.te.runtime.utils.Host;

public abstract class AbstractVariableDelegate
implements IVariableDelegate,
IExecutableExtension {
    protected abstract String[] getKeysToHandle();

    protected Object useVariable(String key, Object value, String variableName, String variableValue) {
        if (value instanceof String) {
            boolean contains;
            boolean bl = contains = Host.isWindowsHost() ? ((String)value).toLowerCase().contains(variableValue.toLowerCase()) : ((String)value).contains(variableValue);
            if (contains) {
                if (Host.isWindowsHost()) {
                    return Pattern.compile(variableValue, 2).matcher((String)value).replaceAll("<" + variableName + ">");
                }
                return ((String)value).replaceAll(variableValue, "<" + variableName + ">");
            }
        }
        return null;
    }

    protected Object restoreValue(String key, Object value, String variableName, String variableValue) {
        if (value instanceof String && ((String)value).contains("<" + variableName + ">")) {
            return ((String)value).replaceAll("<" + variableName + ">", variableValue);
        }
        return null;
    }

    @Override
    public Map<String, String> getVariables(Map<String, Object> map) {
        HashMap<String, String> usedVariables = new HashMap<String, String>();
        String[] stringArray = this.getKeysToHandle();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            if (map.get(key) != null) {
                for (Map.Entry<String, String> variable : this.getVariablesMap(null).entrySet()) {
                    Object newValue = this.useVariable(key, map.get(key), variable.getKey(), variable.getValue());
                    if (newValue == null) continue;
                    map.put(key, newValue);
                    usedVariables.put(variable.getKey(), variable.getValue());
                }
            }
            ++n2;
        }
        return usedVariables;
    }

    @Override
    public Map<String, Object> putVariables(Map<String, Object> map, Map<String, String> defaultVariables) {
        String[] stringArray = this.getKeysToHandle();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            if (map.get(key) != null) {
                for (Map.Entry<String, String> variable : this.getVariablesMap(defaultVariables).entrySet()) {
                    Object newValue = this.restoreValue(key, map.get(key), variable.getKey(), variable.getValue());
                    if (newValue == null) continue;
                    map.put(key, newValue);
                }
            }
            ++n2;
        }
        return map;
    }

    protected Map<String, String> getVariablesMap(Map<String, String> defaultVariables) {
        HashMap<String, String> variables = new HashMap<String, String>();
        IVariableProvider[] iVariableProviderArray = PersistenceManager.getInstance().getVariableProviders();
        int n = iVariableProviderArray.length;
        int n2 = 0;
        while (n2 < n) {
            IVariableProvider provider = iVariableProviderArray[n2];
            variables.putAll(provider.getVariables());
            ++n2;
        }
        if (defaultVariables != null) {
            for (Map.Entry<String, String> defaultVariable : defaultVariables.entrySet()) {
                if (variables.containsKey(defaultVariable.getKey())) continue;
                variables.put(defaultVariable.getKey(), defaultVariable.getValue());
            }
        }
        return variables;
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
    }
}

