/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.tools.internal.views.common.item;

import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ui.tools.api.views.common.item.ProjectDependenciesItem;
import org.eclipse.sirius.ui.tools.internal.views.common.item.AnalysisResourceItemImpl;
import org.eclipse.sirius.viewpoint.DAnalysisSessionEObject;
import org.eclipse.sirius.viewpoint.provider.Messages;
import org.eclipse.sirius.viewpoint.provider.SiriusEditPlugin;
import org.eclipse.swt.graphics.Image;

public abstract class AbstractProjectDependenciesItem
implements ProjectDependenciesItem {
    private final IProject project;

    public AbstractProjectDependenciesItem(IProject theProject) {
        this.project = theProject;
    }

    public Collection<?> getChildren() {
        LinkedHashSet children = Sets.newLinkedHashSet();
        Option<Session> optionalSession = this.getSession();
        if (optionalSession.some()) {
            Session session = (Session)optionalSession.get();
            Iterable semanticDeps = session.getSemanticResources();
            if (session instanceof DAnalysisSessionEObject) {
                semanticDeps = Iterables.concat((Iterable)semanticDeps, (Iterable)((DAnalysisSessionEObject)session).getControlledResources());
            }
            children.addAll(this.extractProjectDependencies(semanticDeps));
            Collection<Resource> analysesDeps = this.extractProjectDependencies(session.getAllSessionResources());
            for (Resource analysisRes : analysesDeps) {
                children.add(new AnalysisResourceItemImpl(session, analysisRes, this));
            }
        }
        return children;
    }

    private Collection<Resource> extractProjectDependencies(Iterable<Resource> dependencies) {
        LinkedHashSet deps = Sets.newLinkedHashSet();
        for (Resource resource : dependencies) {
            URI uri = resource.getURI();
            if (uri.isPlatformResource()) {
                IFile file = WorkspaceSynchronizer.getFile((Resource)resource);
                if (file == null || this.project.getProject().equals((Object)file.getProject())) continue;
                deps.add(resource);
                continue;
            }
            deps.add(resource);
        }
        return deps;
    }

    public String getText() {
        return Messages.ProjectDependenciesItemImpl_text;
    }

    public Image getImage() {
        return SiriusEditPlugin.getPlugin().getBundledImage("icons/obj16/ProjectDependencies.gif");
    }

    public IProject getProject() {
        return this.project == null ? null : this.project.getProject();
    }

    public Object getParent() {
        return this.getProject();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.project == null ? 0 : this.project.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        boolean equals = true;
        if (this == obj) {
            equals = true;
        } else if (obj == null) {
            equals = false;
        } else if (this.getClass() != obj.getClass()) {
            equals = false;
        } else {
            AbstractProjectDependenciesItem other = (AbstractProjectDependenciesItem)obj;
            if (this.project == null) {
                if (other.project != null) {
                    equals = false;
                }
            } else if (!this.project.equals((Object)other.project)) {
                equals = false;
            }
        }
        return equals;
    }
}

