/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.tools.api.views;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.sirius.ui.tools.api.views.common.item.RepresentationDescriptionItem;
import org.eclipse.sirius.ui.tools.internal.views.common.item.RepresentationItemImpl;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.provider.Messages;
import org.eclipse.ui.progress.UIJob;

public class RefreshLabelImageJob
extends UIJob {
    public static final String FAMILY = RefreshLabelImageJob.class.getName();
    public static final long REFRESH_JOB_DELAY = 200L;
    private final String[] refreshProperties = new String[]{"org.eclipse.jface.image"};
    private Collection<Object> elementsToRefresh = Collections.emptySet();
    private TreeViewer commonViewer;

    public RefreshLabelImageJob(TreeViewer commonViewer, Collection<Object> elementsToRefresh) {
        super(Messages.RefreshLabelImageJob_name);
        this.commonViewer = commonViewer;
        this.elementsToRefresh = elementsToRefresh;
    }

    public IStatus runInUIThread(IProgressMonitor monitor) {
        if (this.commonViewer != null && this.commonViewer.getTree() != null && !this.commonViewer.getTree().isDisposed()) {
            if (this.elementsToRefresh == null || this.elementsToRefresh.isEmpty()) {
                this.commonViewer.refresh();
            } else {
                List repDescs = this.elementsToRefresh.stream().filter(DRepresentationDescriptor.class::isInstance).collect(Collectors.toList());
                Object[] expandedElements = this.commonViewer.getExpandedElements();
                if (!repDescs.isEmpty() && expandedElements != null) {
                    ArrayList expandedElementsList = Lists.newArrayList((Object[])expandedElements);
                    for (RepresentationDescriptionItem item : expandedElementsList.stream().filter(RepresentationDescriptionItem.class::isInstance).map(RepresentationDescriptionItem.class::cast).collect(Collectors.toList())) {
                        for (RepresentationItemImpl repItem : Iterables.filter((Iterable)item.getChildren(), RepresentationItemImpl.class)) {
                            if (!repDescs.contains(repItem.getWrappedObject())) continue;
                            this.elementsToRefresh.add(repItem);
                        }
                    }
                }
                this.commonViewer.update(this.elementsToRefresh.toArray(), this.refreshProperties);
            }
        }
        if (this.elementsToRefresh != null) {
            this.elementsToRefresh.clear();
        }
        return Status.OK_STATUS;
    }

    public Collection<?> getElementsToRefresh() {
        return this.elementsToRefresh;
    }

    public boolean belongsTo(Object family) {
        return FAMILY.equals(family);
    }
}

