/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ext.base.relations;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterators;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.sirius.ext.base.relations.Relation;

public class UnionRelation<T>
implements Relation<T> {
    private final Set<Relation<T>> baseRelations;

    public UnionRelation(Relation<T> ... baseRelations) {
        this.baseRelations = ImmutableSet.copyOf((Iterator)Iterators.forArray((Object[])((Relation[])Preconditions.checkNotNull(baseRelations))));
    }

    @Override
    public Set<T> apply(T from) {
        HashSet result = Sets.newHashSet();
        for (Relation<T> rel : this.baseRelations) {
            result.addAll(rel.apply(from));
        }
        return ImmutableSet.copyOf((Collection)result);
    }
}

