/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.internal.edit.parts.locator;

import com.google.common.base.Preconditions;
import java.util.List;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Straight;
import org.eclipse.draw2d.geometry.Transform;
import org.eclipse.draw2d.geometry.Vector;
import org.eclipse.gmf.runtime.diagram.ui.editparts.LabelEditPart;
import org.eclipse.gmf.runtime.draw2d.ui.geometry.LineSeg;
import org.eclipse.gmf.runtime.draw2d.ui.geometry.PointListUtilities;
import org.eclipse.sirius.diagram.ui.business.internal.bracket.locators.BracketLabelLocator;
import org.eclipse.sirius.diagram.ui.part.SiriusVisualIDRegistry;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;

public class EdgeLabelQuery {
    private static final double DISTANCE_TOLERANCE = 0.001;
    private static final int NOT_ON_SAME_LINE = 0;
    private static final int ON_SAME_LINE_SAME_DIRECTION = 1;
    private static final int ON_SAME_LINE_OPPOSITE_DIRECTION = 2;
    private PointList oldBendPointList;
    private PointList newBendPointList;
    private boolean isEdgeWithObliqueRoutingStyle;
    private Point oldLabelOffset;
    private Integer keyPoint;
    private List<LineSeg> oldEdgeSegments;
    private List<LineSeg> newEdgeSegments;
    private boolean isOnBracketEdge;
    private Dimension labelSize;

    public static Point getSnapBackPosition(Integer keyPoint) {
        int percentage = EdgeLabelQuery.getLocation(keyPoint);
        Point snapBackPosition = 15 == percentage ? LabelEditPart.getSnapBackPosition((String)SiriusVisualIDRegistry.getType(6002)) : (85 == percentage ? LabelEditPart.getSnapBackPosition((String)SiriusVisualIDRegistry.getType(6003)) : LabelEditPart.getSnapBackPosition((String)SiriusVisualIDRegistry.getType(6001)));
        return snapBackPosition;
    }

    public static Point offsetFromRelativeCoordinate(Point labelCenter, PointList points, Point ref) {
        Vector fromAnchorToLabelCenterPointVector = new Vector((double)(labelCenter.x - ref.x), (double)(labelCenter.y - ref.y));
        List lineSegments = PointListUtilities.getLineSegments((PointList)points);
        LineSeg segmentContainingLabelAnchor = PointListUtilities.getNearestSegment((List)lineSegments, (int)ref.x, (int)ref.y);
        Vector rotatedVector = EdgeLabelQuery.getRotatedVector(fromAnchorToLabelCenterPointVector, segmentContainingLabelAnchor, false);
        return new PrecisionPoint(rotatedVector.x, rotatedVector.y);
    }

    public static Point relativeCenterCoordinateFromOffset(PointList points, Point ref, Point offset) {
        Vector fromAnchorToLabelCenterPointVector = new Vector((double)offset.x, (double)offset.y);
        List lineSegments = PointListUtilities.getLineSegments((PointList)points);
        LineSeg segmentContainingLabelAnchor = PointListUtilities.getNearestSegment((List)lineSegments, (int)ref.x, (int)ref.y);
        Vector rotatedVector = EdgeLabelQuery.getRotatedVector(fromAnchorToLabelCenterPointVector, segmentContainingLabelAnchor, true);
        return new PrecisionPoint((double)ref.x + rotatedVector.x, (double)ref.y + rotatedVector.y);
    }

    public EdgeLabelQuery(PointList oldBendPointList, PointList newBendPointList, boolean isEdgeWithObliqueRoutingStyle, Point oldLabelOffset, Dimension labelSize, Integer keyPoint, boolean isOnBracketEdge) {
        this.isEdgeWithObliqueRoutingStyle = isEdgeWithObliqueRoutingStyle;
        this.oldBendPointList = oldBendPointList;
        Preconditions.checkState((newBendPointList.size() > 0 ? 1 : 0) != 0);
        this.newBendPointList = newBendPointList;
        this.oldLabelOffset = oldLabelOffset;
        this.labelSize = labelSize;
        this.keyPoint = keyPoint;
        this.isOnBracketEdge = isOnBracketEdge;
        this.oldEdgeSegments = PointListUtilities.getLineSegments((PointList)oldBendPointList);
        this.newEdgeSegments = PointListUtilities.getLineSegments((PointList)newBendPointList);
    }

    public Point calculateGMFLabelOffset() {
        if (this.areBendpointsIdentical() && this.areSegmentsValid()) {
            return this.oldLabelOffset;
        }
        int anchorPointRatio = EdgeLabelQuery.getLocation(this.keyPoint);
        Point oldAnchorPoint = this.getAnchorPoint(this.oldBendPointList, anchorPointRatio);
        Point oldLabelCenter = EdgeLabelQuery.relativeCenterCoordinateFromOffset(this.oldBendPointList, oldAnchorPoint, this.oldLabelOffset);
        Point newAnchorPoint = this.getAnchorPoint(this.newBendPointList, anchorPointRatio);
        Point newLabelCenter = this.calculateNewCenterLocation(oldLabelCenter, this.getStandardLabelCenterLocation(this.newBendPointList, this.keyPoint));
        return EdgeLabelQuery.offsetFromRelativeCoordinate(newLabelCenter, this.newBendPointList, newAnchorPoint);
    }

    private Point getAnchorPoint(PointList pointList, int anchorPointRatio) {
        if (this.isOnBracketEdge && 50 == anchorPointRatio) {
            return BracketLabelLocator.getReferencePoint(pointList);
        }
        return PointListUtilities.calculatePointRelativeToLine((PointList)pointList, (int)0, (int)anchorPointRatio, (boolean)true);
    }

    private boolean areSegmentsValid() {
        boolean areSegmentsValid = true;
        for (LineSeg lineSeg : this.newEdgeSegments) {
            if (!lineSeg.getOrigin().equals((Object)lineSeg.getTerminus())) continue;
            areSegmentsValid = false;
            break;
        }
        if (areSegmentsValid) {
            for (LineSeg lineSeg : this.oldEdgeSegments) {
                if (!lineSeg.getOrigin().equals((Object)lineSeg.getTerminus())) continue;
                areSegmentsValid = false;
                break;
            }
        }
        return areSegmentsValid;
    }

    private boolean areBendpointsIdentical() {
        boolean areBendpointsIdentical = true;
        if (this.newBendPointList.size() == this.oldBendPointList.size()) {
            int i = 0;
            while (i < this.newBendPointList.size()) {
                Point oldPoint;
                Point newPoint = this.newBendPointList.getPoint(i);
                if (!newPoint.equals((Object)(oldPoint = this.oldBendPointList.getPoint(i)))) {
                    areBendpointsIdentical = false;
                    break;
                }
                ++i;
            }
        } else {
            areBendpointsIdentical = false;
        }
        return areBendpointsIdentical;
    }

    private Point calculateNewCenterLocation(Point oldCenterLabel, Point newDefaultLocation) {
        LineSeg oldNearestSeg;
        Vector fromOldToNewCenterVector = null;
        Object oldNearestPoint = (oldNearestSeg = PointListUtilities.getNearestSegment(this.oldEdgeSegments, (int)oldCenterLabel.x, (int)oldCenterLabel.y)).isHorizontal() ? new PrecisionPoint(oldCenterLabel.preciseX(), oldNearestSeg.getOrigin().preciseY()) : (oldNearestSeg.isVertical() ? new PrecisionPoint(oldNearestSeg.getOrigin().preciseX(), oldCenterLabel.preciseY()) : oldNearestSeg.perpIntersect(oldCenterLabel.x, oldCenterLabel.y));
        Option<Vector> fromOldToNewRefPoint = this.getVectorFromOldToNewForSegmentsOnSameLine(oldNearestSeg, (Point)oldNearestPoint, oldCenterLabel);
        if (fromOldToNewRefPoint.some()) {
            fromOldToNewCenterVector = (Vector)fromOldToNewRefPoint.get();
        } else if (!this.isEdgeWithObliqueRoutingStyle) {
            LineSeg oldRefVectorIntoSegment = null;
            oldRefVectorIntoSegment = oldCenterLabel.equals(oldNearestPoint) ? new LineSeg((Point)oldNearestPoint, (Point)new PrecisionPoint(oldNearestPoint.x + (oldNearestSeg.getOrigin().y - oldNearestSeg.getTerminus().y), oldNearestPoint.y - (oldNearestSeg.getOrigin().x - oldNearestSeg.getTerminus().x))) : new LineSeg(oldCenterLabel, (Point)oldNearestPoint);
            fromOldToNewCenterVector = this.getVectorForSegmentMoveCase(oldNearestSeg, (Point)oldNearestPoint, oldCenterLabel);
            if (fromOldToNewCenterVector == null && this.isOnBracketEdge) {
                fromOldToNewCenterVector = this.getVectorForBracketEdgeOrientationChangeCase(oldNearestSeg, (Point)oldNearestPoint, oldCenterLabel);
            }
            if (fromOldToNewCenterVector == null) {
                for (LineSeg lineSeg : this.newEdgeSegments) {
                    PointList linesIntersections = oldRefVectorIntoSegment.getLinesIntersections(lineSeg);
                    if (linesIntersections.size() != 1 || !((double)lineSeg.distanceToPoint(linesIntersections.getPoint((int)0).x, linesIntersections.getPoint((int)0).y) <= Math.sqrt(2.0))) continue;
                    Vector tempLabelMove = new Vector((double)(linesIntersections.getPoint((int)0).x - oldNearestPoint.x), (double)(linesIntersections.getPoint((int)0).y - oldNearestPoint.y));
                    if (fromOldToNewCenterVector != null && !(tempLabelMove.getLength() < fromOldToNewCenterVector.getLength())) continue;
                    fromOldToNewCenterVector = tempLabelMove;
                }
                Vector fromOldNearestPointToStandardLocation = new Vector((double)(newDefaultLocation.x - oldNearestPoint.x), (double)(newDefaultLocation.y - oldNearestPoint.y));
                if (fromOldToNewCenterVector == null || fromOldNearestPointToStandardLocation.getLength() < fromOldToNewCenterVector.getLength()) {
                    fromOldToNewCenterVector = null;
                }
            }
        } else if (this.newEdgeSegments.size() == this.oldEdgeSegments.size()) {
            LineSeg newRefSeg = this.newEdgeSegments.get(this.oldEdgeSegments.indexOf(oldNearestSeg));
            double oldRatio = oldNearestSeg.projection(oldCenterLabel.x, oldCenterLabel.y);
            PrecisionPoint refPointOnNewSegWithOldRatio = new PrecisionPoint((double)newRefSeg.getOrigin().x + oldRatio * (double)(newRefSeg.getTerminus().x - newRefSeg.getOrigin().x), (double)newRefSeg.getOrigin().y + oldRatio * (double)(newRefSeg.getTerminus().y - newRefSeg.getOrigin().y));
            fromOldToNewCenterVector = new Vector((double)(refPointOnNewSegWithOldRatio.x - oldNearestPoint.x), (double)(refPointOnNewSegWithOldRatio.y - oldNearestPoint.y));
            if (oldRatio < 0.0 || 1.0 < oldRatio) {
                double oldDistance = oldNearestSeg.distanceToPoint(oldCenterLabel.x(), oldCenterLabel.y());
                Point potentialNewCenter = oldCenterLabel.getTranslated(fromOldToNewCenterVector.x, fromOldToNewCenterVector.y);
                double newDistance = newRefSeg.distanceToPoint(potentialNewCenter.x(), potentialNewCenter.y());
                if (newDistance > oldDistance) {
                    fromOldToNewCenterVector = null;
                }
            }
        }
        if (fromOldToNewCenterVector == null) {
            return newDefaultLocation;
        }
        return oldCenterLabel.getTranslated(fromOldToNewCenterVector.x, fromOldToNewCenterVector.y);
    }

    private Vector getVectorForSegmentMoveCase(LineSeg oldNearestSeg, Point oldNearestPoint, Point oldCenterLabel) {
        Vector fromOldToNewCenterVector = null;
        if (this.newEdgeSegments.size() == this.oldEdgeSegments.size()) {
            int index = this.oldEdgeSegments.indexOf(oldNearestSeg);
            LineSeg newNearestSegment = this.newEdgeSegments.get(index);
            if (oldNearestSeg.isHorizontal() == newNearestSegment.isHorizontal()) {
                Vector oldVector = new Vector((double)(oldNearestSeg.getTerminus().x - oldNearestSeg.getOrigin().x), (double)(oldNearestSeg.getTerminus().y - oldNearestSeg.getOrigin().y));
                Vector newVector = new Vector((double)(newNearestSegment.getTerminus().x - newNearestSegment.getOrigin().x), (double)(newNearestSegment.getTerminus().y - newNearestSegment.getOrigin().y));
                boolean oppositeDirection = false;
                if (oldVector.getLength() != 0.0 && newVector.getLength() != 0.0) {
                    oppositeDirection = oldVector.getAngle(newVector) == 180.0;
                }
                fromOldToNewCenterVector = this.applyOldRatioOnNewSegment(oldNearestSeg, oldNearestPoint, oldCenterLabel, newNearestSegment, oppositeDirection, false);
            }
        }
        return fromOldToNewCenterVector;
    }

    private Vector getVectorForBracketEdgeOrientationChangeCase(LineSeg oldNearestSeg, Point oldNearestPoint, Point oldCenterLabel) {
        Vector fromOldToNewCenterVector = null;
        if (this.newEdgeSegments.size() == this.oldEdgeSegments.size()) {
            int index = this.oldEdgeSegments.indexOf(oldNearestSeg);
            LineSeg newNearestSegment = this.newEdgeSegments.get(index);
            if (oldNearestSeg.isHorizontal() != newNearestSegment.isHorizontal()) {
                Vector oldVector = new Vector((double)(oldNearestSeg.getTerminus().x - oldNearestSeg.getOrigin().x), (double)(oldNearestSeg.getTerminus().y - oldNearestSeg.getOrigin().y));
                Vector newVector = new Vector((double)(newNearestSegment.getTerminus().x - newNearestSegment.getOrigin().x), (double)(newNearestSegment.getTerminus().y - newNearestSegment.getOrigin().y));
                double angleInDegree = Math.toDegrees(EdgeLabelQuery.angleBetween2Lines(oldVector, newVector));
                fromOldToNewCenterVector = this.applyOldRatioOnNewOrthogonalSegment(oldNearestSeg, oldNearestPoint, oldCenterLabel, newNearestSegment, angleInDegree == 90.0 || angleInDegree == -270.0);
            }
        }
        return fromOldToNewCenterVector;
    }

    private Option<Vector> getVectorFromOldToNewForSegmentsOnSameLine(LineSeg oldRefSeg, Point oldRefPoint, Point oldCenterLabel) {
        LineSeg newRefSeg;
        Option result = Options.newNone();
        LineSeg newSegmentOnSameLineWithSameDirection = null;
        LineSeg newSegmentOnSameLineWithOppositeDirection = null;
        int sameLineStatus = 0;
        if (this.newEdgeSegments.size() == this.oldEdgeSegments.size()) {
            LineSeg newSegAtSameIndex = this.newEdgeSegments.get(this.oldEdgeSegments.indexOf(oldRefSeg));
            sameLineStatus = this.getSameLineStatus(oldRefSeg, newSegAtSameIndex);
            if (1 == sameLineStatus) {
                newSegmentOnSameLineWithSameDirection = newSegAtSameIndex;
            } else if (2 == sameLineStatus) {
                newSegmentOnSameLineWithOppositeDirection = newSegAtSameIndex;
            }
        }
        if (sameLineStatus == 0) {
            for (LineSeg newSeg : this.newEdgeSegments) {
                sameLineStatus = this.getSameLineStatus(oldRefSeg, newSeg);
                if (1 == sameLineStatus) {
                    newSegmentOnSameLineWithSameDirection = newSeg;
                    break;
                }
                if (2 != sameLineStatus) continue;
                newSegmentOnSameLineWithOppositeDirection = newSeg;
            }
        }
        if ((newRefSeg = newSegmentOnSameLineWithSameDirection) == null) {
            newRefSeg = newSegmentOnSameLineWithOppositeDirection;
        }
        if (newRefSeg != null) {
            result = Options.newSome((Object)this.applyOldRatioOnNewSegment(oldRefSeg, oldRefPoint, oldCenterLabel, newRefSeg, newSegmentOnSameLineWithOppositeDirection != null, true));
        }
        return result;
    }

    private int getSameLineStatus(LineSeg referenceSegment, LineSeg segment) {
        int result = 0;
        if (segment.length() != 0.0) {
            Vector referenceVector = new Vector((double)(referenceSegment.getTerminus().x - referenceSegment.getOrigin().x), (double)(referenceSegment.getTerminus().y - referenceSegment.getOrigin().y));
            Vector vector = new Vector((double)(segment.getTerminus().x - segment.getOrigin().x), (double)(segment.getTerminus().y - segment.getOrigin().y));
            if (referenceVector.getLength() == 0.0 || vector.getLength() == 0.0) {
                if (vector.getLength() == 0.0 && referenceSegment.containsPoint(segment.getOrigin(), 0) || referenceVector.getLength() == 0.0 && segment.containsPoint(referenceSegment.getOrigin(), 0)) {
                    result = 1;
                }
            } else {
                Straight straight;
                double distToInfiniteLine;
                double angle = referenceVector.getAngle(vector);
                if ((angle == 0.0 || angle == 180.0) && (distToInfiniteLine = (straight = new Straight(new PrecisionPoint(segment.getOrigin()), new PrecisionPoint(segment.getTerminus()))).getDistance(new Vector((double)referenceSegment.getOrigin().x, (double)referenceSegment.getOrigin().y))) < 0.001) {
                    result = angle == 180.0 ? 2 : 1;
                }
            }
        }
        return result;
    }

    private Vector applyOldRatioOnNewSegment(LineSeg oldRefSeg, Point oldRefPoint, Point oldCenterLabel, LineSeg newRefSeg, boolean oppositeDirection, boolean sameLine) {
        Vector result;
        double newRatio = newRefSeg.projection(oldCenterLabel.x, oldCenterLabel.y);
        if (sameLine && newRatio >= 0.0 && newRatio <= 1.0) {
            result = new Vector(0.0, 0.0);
        } else {
            double oldRatio = oldRefSeg.projection(oldCenterLabel.x, oldCenterLabel.y);
            PrecisionPoint newRefPoint = !oppositeDirection ? new PrecisionPoint((double)newRefSeg.getOrigin().x + oldRatio * (double)(newRefSeg.getTerminus().x - newRefSeg.getOrigin().x), (double)newRefSeg.getOrigin().y + oldRatio * (double)(newRefSeg.getTerminus().y - newRefSeg.getOrigin().y)) : new PrecisionPoint((double)newRefSeg.getOrigin().x - oldRatio * (double)(newRefSeg.getOrigin().x - newRefSeg.getTerminus().x), (double)newRefSeg.getOrigin().y - oldRatio * (double)(newRefSeg.getOrigin().y - newRefSeg.getTerminus().y));
            if (!sameLine && newRatio >= 0.0 && newRatio <= 1.0) {
                if (newRefSeg.isHorizontal()) {
                    newRefPoint.setX(oldRefPoint.x);
                } else {
                    newRefPoint.setY(oldRefPoint.y);
                }
            }
            Vector vectorFromOldToNewRefPoint = new Vector((double)(newRefPoint.x - oldRefPoint.x), (double)(newRefPoint.y - oldRefPoint.y));
            if (oldRatio >= 0.0 && oldRatio <= 1.0) {
                result = vectorFromOldToNewRefPoint;
            } else {
                Point potentialNewCenter = oldCenterLabel.getTranslated(vectorFromOldToNewRefPoint.x, vectorFromOldToNewRefPoint.y);
                result = newRatio > 1.0 && newRatio < newRefSeg.projection(potentialNewCenter.x, potentialNewCenter.y) || newRatio < 0.0 && newRatio > newRefSeg.projection(potentialNewCenter.x, potentialNewCenter.y) ? new Vector(0.0, 0.0) : vectorFromOldToNewRefPoint;
            }
        }
        return result;
    }

    private Vector applyOldRatioOnNewOrthogonalSegment(LineSeg oldRefSeg, Point oldRefPoint, Point oldCenterLabel, LineSeg newRefSeg, boolean is90Angle) {
        int invertedWidthHeight;
        Point vectorFromNewOriginToNewRefPoint;
        Vector vectorFromOldOriginToOldRefPoint;
        Point vectorFromNewTerminusToNewRefPoint;
        Vector vectorFromOldTerminusToOldRefPoint;
        Point newRefPoint;
        double oldRatio = oldRefSeg.projection(oldCenterLabel.x, oldCenterLabel.y);
        Transform rotateTransform = new Transform();
        if (is90Angle) {
            rotateTransform.setRotation(Math.toRadians(-90.0));
            if (0.0 <= oldRatio && oldRatio <= 1.0) {
                newRefPoint = new PrecisionPoint((double)newRefSeg.getOrigin().x - oldRatio * (double)(newRefSeg.getOrigin().x - newRefSeg.getTerminus().x), (double)newRefSeg.getOrigin().y - oldRatio * (double)(newRefSeg.getOrigin().y - newRefSeg.getTerminus().y));
            } else if (oldRatio > 1.0) {
                vectorFromOldTerminusToOldRefPoint = new Vector((double)(oldRefPoint.x - oldRefSeg.getTerminus().x), (double)(oldRefPoint.y - oldRefSeg.getTerminus().y));
                vectorFromNewTerminusToNewRefPoint = rotateTransform.getTransformed((Point)vectorFromOldTerminusToOldRefPoint.toPoint());
                newRefPoint = newRefSeg.getTerminus().getTranslated(vectorFromNewTerminusToNewRefPoint);
            } else {
                vectorFromOldOriginToOldRefPoint = new Vector((double)(oldRefPoint.x - oldRefSeg.getOrigin().x), (double)(oldRefPoint.y - oldRefSeg.getOrigin().y));
                vectorFromNewOriginToNewRefPoint = rotateTransform.getTransformed((Point)vectorFromOldOriginToOldRefPoint.toPoint());
                newRefPoint = newRefSeg.getOrigin().getTranslated(vectorFromNewOriginToNewRefPoint);
            }
        } else {
            rotateTransform.setRotation(Math.toRadians(90.0));
            if (0.0 <= oldRatio && oldRatio <= 1.0) {
                newRefPoint = new PrecisionPoint((double)newRefSeg.getOrigin().x + oldRatio * (double)(newRefSeg.getTerminus().x - newRefSeg.getOrigin().x), (double)newRefSeg.getOrigin().y + oldRatio * (double)(newRefSeg.getTerminus().y - newRefSeg.getOrigin().y));
            } else if (oldRatio > 1.0) {
                vectorFromOldTerminusToOldRefPoint = new Vector((double)(oldRefPoint.x - oldRefSeg.getTerminus().x), (double)(oldRefPoint.y - oldRefSeg.getTerminus().y));
                vectorFromNewTerminusToNewRefPoint = rotateTransform.getTransformed((Point)vectorFromOldTerminusToOldRefPoint.toPoint());
                newRefPoint = newRefSeg.getTerminus().getTranslated(vectorFromNewTerminusToNewRefPoint);
            } else {
                vectorFromOldOriginToOldRefPoint = new Vector((double)(oldRefPoint.x - oldRefSeg.getOrigin().x), (double)(oldRefPoint.y - oldRefSeg.getOrigin().y));
                vectorFromNewOriginToNewRefPoint = rotateTransform.getTransformed((Point)vectorFromOldOriginToOldRefPoint.toPoint());
                newRefPoint = newRefSeg.getOrigin().getTranslated(vectorFromNewOriginToNewRefPoint);
            }
        }
        Vector vectorFromOldRefPointToOldCenterLabel = new Vector((double)(oldCenterLabel.x - oldRefPoint.x), (double)(oldCenterLabel.y - oldRefPoint.y));
        Point fromNewRefPointToNewCenterLabel = rotateTransform.getTransformed((Point)vectorFromOldRefPointToOldCenterLabel.toPoint());
        if (newRefSeg.isHorizontal()) {
            if (0.0 <= oldRatio && oldRatio <= 1.0) {
                invertedWidthHeight = this.labelSize.width - this.labelSize.height;
                if (newRefSeg.getOrigin().x > newRefSeg.getTerminus().x) {
                    invertedWidthHeight = -invertedWidthHeight;
                }
                fromNewRefPointToNewCenterLabel.translate(0, invertedWidthHeight / 2);
            } else if (oldRatio > 1.0) {
                invertedWidthHeight = this.labelSize.width - this.labelSize.height;
                if (newRefSeg.getOrigin().x > newRefSeg.getTerminus().x) {
                    invertedWidthHeight = -invertedWidthHeight;
                }
                fromNewRefPointToNewCenterLabel.translate(invertedWidthHeight / 2, 0);
            } else {
                fromNewRefPointToNewCenterLabel.translate(0, 0);
                invertedWidthHeight = this.labelSize.width - this.labelSize.height;
                if (newRefSeg.getOrigin().x < newRefSeg.getTerminus().x) {
                    invertedWidthHeight = -invertedWidthHeight;
                }
                fromNewRefPointToNewCenterLabel.translate(invertedWidthHeight / 2, 0);
            }
        } else if (0.0 <= oldRatio && oldRatio <= 1.0) {
            invertedWidthHeight = this.labelSize.width - this.labelSize.height;
            if (newRefSeg.getOrigin().y > newRefSeg.getTerminus().y) {
                invertedWidthHeight = -invertedWidthHeight;
            }
            fromNewRefPointToNewCenterLabel.translate(invertedWidthHeight / 2, 0);
        } else if (oldRatio > 1.0) {
            invertedWidthHeight = this.labelSize.height - this.labelSize.width;
            if (newRefSeg.getOrigin().y > newRefSeg.getTerminus().y) {
                invertedWidthHeight = -invertedWidthHeight;
            }
            fromNewRefPointToNewCenterLabel.translate(0, invertedWidthHeight / 2);
        } else {
            invertedWidthHeight = this.labelSize.height - this.labelSize.width;
            if (newRefSeg.getOrigin().y < newRefSeg.getTerminus().y) {
                invertedWidthHeight = -invertedWidthHeight;
            }
            fromNewRefPointToNewCenterLabel.translate(0, invertedWidthHeight / 2);
        }
        Point newCenterLabel = newRefPoint.getTranslated(fromNewRefPointToNewCenterLabel);
        return new Vector((double)(newCenterLabel.x - oldCenterLabel.x), (double)(newCenterLabel.y - oldCenterLabel.y));
    }

    private static Vector getRotatedVector(Vector vector, LineSeg segment, boolean inverseRotation) {
        Vector result = new Vector(vector.x, vector.y);
        if (vector.x != 0.0 || vector.y != 0.0) {
            double angle = EdgeLabelQuery.angleBetween2Lines(new LineSeg(new Point(0, 0), new Point(1, 0)), segment) * (double)(inverseRotation ? -1 : 1);
            Transform rotateTransform = new Transform();
            rotateTransform.setRotation(angle);
            Point rotatedPoint = rotateTransform.getTransformed((Point)vector.toPoint());
            result.x = rotatedPoint.x;
            result.y = rotatedPoint.y;
        }
        return result;
    }

    private static double angleBetween2Lines(LineSeg line1, LineSeg line2) {
        if (line1 == null || line2 == null) {
            return 0.0;
        }
        double angle1 = Math.atan2(line1.getOrigin().y - line1.getTerminus().y, line1.getOrigin().x - line1.getTerminus().x);
        double angle2 = Math.atan2(line2.getOrigin().y - line2.getTerminus().y, line2.getOrigin().x - line2.getTerminus().x);
        return angle1 - angle2;
    }

    private static double angleBetween2Lines(Vector vector1, Vector vector2) {
        if (vector1 == null || vector2 == null) {
            return 0.0;
        }
        double angle1 = Math.atan2(vector1.y, vector1.x);
        double angle2 = Math.atan2(vector2.y, vector2.x);
        return angle1 - angle2;
    }

    private Point getStandardLabelCenterLocation(PointList pointsList, Integer keyPoint) {
        int percentage = EdgeLabelQuery.getLocation(keyPoint);
        Point newAnchorPoint = this.getAnchorPoint(pointsList, percentage);
        Point snapBackPosition = EdgeLabelQuery.getSnapBackPosition(keyPoint);
        Point standardLabelCenter = newAnchorPoint.getTranslated(snapBackPosition);
        return standardLabelCenter;
    }

    private static int getLocation(Integer keyPoint) {
        int location = 50;
        switch (keyPoint) {
            case 2: {
                location = 85;
                break;
            }
            case 3: {
                location = 15;
                break;
            }
            case 4: {
                location = 50;
                break;
            }
            default: {
                location = 50;
            }
        }
        return location;
    }
}

