/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire;

import java.util.List;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.ListPropertyBinding;
import org.eclipse.sapphire.Resource;
import org.eclipse.sapphire.util.IdentityCache;
import org.eclipse.sapphire.util.ListFactory;

public abstract class LayeredListPropertyBinding
extends ListPropertyBinding {
    private final IdentityCache<Object, Resource> cache = new IdentityCache();

    public final List<Resource> read() {
        this.cache.track();
        ListFactory<Resource> list = ListFactory.start();
        for (Object obj : this.readUnderlyingList()) {
            Resource resource = this.cache.get(obj);
            if (resource == null) {
                resource = this.resource(obj);
                this.cache.put(obj, resource);
            }
            list.add(resource);
        }
        this.cache.purge();
        return list.result();
    }

    protected abstract List<?> readUnderlyingList();

    @Override
    public final Resource insert(ElementType type, int position) {
        Object obj = this.insertUnderlyingObject(type, position);
        Resource resource = this.cache.get(obj);
        if (resource == null) {
            resource = this.resource(obj);
            this.cache.put(obj, resource);
        }
        return resource;
    }

    protected Object insertUnderlyingObject(ElementType type, int position) {
        throw new UnsupportedOperationException();
    }

    protected abstract Resource resource(Object var1);
}

