/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.ui.dialogs;

import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.rse.internal.ui.dialogs.SystemRenameTableRow;
import org.eclipse.rse.ui.validators.ISystemValidator;
import org.eclipse.swt.graphics.Image;

public class SystemRenameTableProvider
implements ITableLabelProvider,
IStructuredContentProvider {
    static final int COLUMN_ERROR = 0;
    static final int COLUMN_OLDNAME = 1;
    static final int COLUMN_NEWNAME = 2;
    static final int COLUMN_TYPE = 3;
    private Map imageTable = new Hashtable(20);
    private Object[] children = null;
    private ISystemValidator inputValidator = null;

    public void setNameValidator(ISystemValidator nameValidator) {
        this.inputValidator = nameValidator;
    }

    private SystemRenameTableRow getTableRow(Object element) {
        return (SystemRenameTableRow)element;
    }

    private Image getImageFromDescriptor(ImageDescriptor descriptor) {
        if (descriptor == null) {
            return null;
        }
        Image image = (Image)this.imageTable.get(descriptor);
        if (image == null) {
            image = descriptor.createImage();
            this.imageTable.put(descriptor, image);
        }
        return image;
    }

    public Image getColumnImage(Object element, int column) {
        if (column == 0) {
            SystemRenameTableRow row = this.getTableRow(element);
            if (row.getError()) {
                Image errorImage = JFaceResources.getImage((String)"dialog_message_error_image");
                return errorImage;
            }
            return null;
        }
        if (column == 1) {
            return this.getImageFromDescriptor(this.getTableRow(element).getImageDescriptor());
        }
        return null;
    }

    public String getColumnText(Object element, int column) {
        String text = "";
        if (column == 1) {
            text = this.getTableRow(element).getName();
        } else if (column == 2) {
            text = this.getTableRow(element).getNewName();
        } else if (column == 3) {
            text = this.getTableRow(element).getType();
        }
        return text;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
        Collection imageValues;
        if (this.imageTable != null && (imageValues = this.imageTable.values()) != null) {
            Iterator images = imageValues.iterator();
            if (images != null) {
                while (images.hasNext()) {
                    ((Image)images.next()).dispose();
                }
            }
            this.imageTable = null;
        }
    }

    public boolean isLabelProperty(Object element, String property) {
        return true;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public Object[] getElements(Object inputElement) {
        if (this.children == null) {
            IStructuredSelection iss = (IStructuredSelection)inputElement;
            this.children = new SystemRenameTableRow[iss.size()];
            Iterator i = iss.iterator();
            int idx = 0;
            while (i.hasNext()) {
                this.children[idx] = new SystemRenameTableRow(i.next(), idx);
                if (this.inputValidator != null) {
                    ((SystemRenameTableRow)this.children[idx]).setNameValidator(this.inputValidator);
                }
                ++idx;
            }
        }
        return this.children;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public int getRowNumber(SystemRenameTableRow row) {
        int matchRow = row.getRowNumber();
        return matchRow;
    }
}

