/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.remote.telnet.internal.ui;

import java.util.Set;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.remote.core.IRemoteConnectionHostService;
import org.eclipse.remote.core.IRemoteConnectionType;
import org.eclipse.remote.core.IRemoteConnectionWorkingCopy;
import org.eclipse.remote.core.exception.RemoteConnectionException;
import org.eclipse.remote.telnet.internal.ui.Activator;
import org.eclipse.remote.telnet.internal.ui.TelnetConnectionWizardPage;
import org.eclipse.remote.ui.IRemoteUIConnectionWizard;
import org.eclipse.swt.widgets.Shell;

public class TelnetConnectionWizard
extends Wizard
implements IRemoteUIConnectionWizard {
    private TelnetConnectionWizardPage page;
    private IRemoteConnectionWorkingCopy workingCopy;
    private final Shell shell;
    private final IRemoteConnectionType connectionType;

    public TelnetConnectionWizard(Shell shell, IRemoteConnectionType connectionType) {
        this.shell = shell;
        this.connectionType = connectionType;
    }

    public void addPages() {
        IRemoteConnectionHostService hostSvc;
        this.page = new TelnetConnectionWizardPage();
        if (this.workingCopy != null && (hostSvc = (IRemoteConnectionHostService)this.workingCopy.getService(IRemoteConnectionHostService.class)) != null) {
            this.page.setHost(hostSvc.getHostname());
            this.page.setPort(hostSvc.getPort());
            this.page.setTimeout(hostSvc.getTimeout());
        }
        this.addPage((IWizardPage)this.page);
    }

    public boolean performFinish() {
        IRemoteConnectionHostService hostSvc;
        IRemoteConnectionWorkingCopy conn = this.getConnection();
        if (conn != null && (hostSvc = (IRemoteConnectionHostService)conn.getService(IRemoteConnectionHostService.class)) != null) {
            hostSvc.setHostname(this.page.getHost());
            hostSvc.setPort(this.page.getPort());
            hostSvc.setTimeout(this.page.getTimeout());
            return true;
        }
        return false;
    }

    public IRemoteConnectionWorkingCopy open() {
        WizardDialog dialog = new WizardDialog(this.shell, (IWizard)this);
        dialog.setBlockOnOpen(true);
        if (dialog.open() == 0) {
            return this.getConnection();
        }
        return null;
    }

    public IRemoteConnectionWorkingCopy getConnection() {
        if (this.workingCopy == null) {
            try {
                this.workingCopy = this.connectionType.newConnection(this.page.getHost());
            }
            catch (RemoteConnectionException e) {
                Activator.log(e.getStatus());
            }
        }
        return this.workingCopy;
    }

    public void setConnection(IRemoteConnectionWorkingCopy connection) {
        this.workingCopy = connection;
    }

    public void setConnectionName(String name) {
    }

    public void setInvalidConnectionNames(Set<String> names) {
    }
}

