/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.utils.gson;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.Calendar;
import java.util.Date;
import javax.xml.bind.DatatypeConverter;

public class ISO8601DateParser
implements JsonDeserializer<Date>,
JsonSerializer<Date> {
    public Date deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        String date = json.getAsJsonPrimitive().getAsString();
        Calendar calendar = DatatypeConverter.parseDateTime((String)date);
        return calendar.getTime();
    }

    public JsonElement serialize(Date src, Type typeOfSrc, JsonSerializationContext context) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(src);
        return new JsonPrimitive(DatatypeConverter.printDateTime((Calendar)calendar));
    }
}

