/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.models.rcp.actions;

import com.google.common.base.Optional;
import com.google.common.eventbus.EventBus;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.recommenders.coordinates.DependencyInfo;
import org.eclipse.recommenders.coordinates.ProjectCoordinate;
import org.eclipse.recommenders.internal.models.rcp.EclipseModelRepository;
import org.eclipse.recommenders.models.IModelIndex;
import org.eclipse.recommenders.models.rcp.IProjectCoordinateProvider;
import org.eclipse.recommenders.models.rcp.actions.TriggerModelDownloadForProjectCoordinatesAction;

public class TriggerModelDownloadForDependencyInfosAction
extends TriggerModelDownloadForProjectCoordinatesAction {
    private IProjectCoordinateProvider pcProvider;
    private final Set<DependencyInfo> deps;

    public TriggerModelDownloadForDependencyInfosAction(String text, Set<DependencyInfo> deps, List<String> modelClassifier, IProjectCoordinateProvider pcProvider, IModelIndex modelIndex, EclipseModelRepository repo, EventBus bus) {
        super(text, modelClassifier, modelIndex, repo, bus);
        this.pcProvider = pcProvider;
        this.deps = deps;
    }

    @Override
    public void run() {
        HashSet<ProjectCoordinate> pcs = new HashSet<ProjectCoordinate>();
        for (DependencyInfo dep : this.deps) {
            Optional<ProjectCoordinate> opc = this.pcProvider.resolve(dep);
            if (!opc.isPresent()) continue;
            pcs.add((ProjectCoordinate)opc.get());
        }
        this.triggerDownloadForProjectCoordinates(pcs);
    }
}

