/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.actions.edit;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.RefactoringWizardOpenOperation;
import org.eclipse.rcptt.core.tags.Tag;
import org.eclipse.rcptt.core.workspace.RcpttCore;
import org.eclipse.rcptt.internal.core.model.Q7ProjectMetadata;
import org.eclipse.rcptt.internal.ui.Messages;
import org.eclipse.rcptt.internal.ui.Q7UIPlugin;
import org.eclipse.rcptt.ui.launching.LaunchUtils;
import org.eclipse.rcptt.ui.refactoring.delete.DeleteQ7ElementWizard;
import org.eclipse.rcptt.ui.refactoring.delete.DeleteTagWizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.DeleteResourceAction;

public class DeleteAction
extends DeleteResourceAction {
    private final IShellProvider provider;

    public DeleteAction(IShellProvider provider) {
        super(provider);
        this.provider = provider;
        ISharedImages images = PlatformUI.getWorkbench().getSharedImages();
        this.setDisabledImageDescriptor(images.getImageDescriptor("IMG_TOOL_DELETE_DISABLED"));
        this.setImageDescriptor(images.getImageDescriptor("IMG_TOOL_DELETE"));
        this.setActionDefinitionId("org.eclipse.ui.edit.delete");
    }

    public void run() {
        if (LaunchUtils.hasLaunchedTestCases()) {
            MessageDialog.openWarning((Shell)this.provider.getShell(), (String)Messages.DeleteAction_ErrorDialogTitle, (String)Messages.DeleteAction_ErrorDialogMsg);
            return;
        }
        if (this.containsOnlyTags(this.getStructuredSelection())) {
            this.run(new DeleteTagWizard(this.getSelectedTags()), this.provider.getShell());
        } else {
            IResource[] resources = this.getSelectedResourcesArray();
            this.run(new DeleteQ7ElementWizard(resources), this.provider.getShell());
        }
    }

    public void run(RefactoringWizard wizard, Shell parent) {
        try {
            RefactoringWizardOpenOperation operation = new RefactoringWizardOpenOperation(wizard);
            operation.run(parent, wizard.getWindowTitle());
        }
        catch (InterruptedException interruptedException) {}
    }

    private boolean containsQ7Elements(IResource[] resources) {
        IResource[] iResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            if (resource instanceof IFile && RcpttCore.isQ7File((IPath)resource.getFullPath())) {
                return true;
            }
            if (resource instanceof IContainer) {
                try {
                    IResource[] members = ((IContainer)resource).members();
                    if (this.containsQ7Elements(members)) {
                        return true;
                    }
                }
                catch (CoreException e) {
                    Q7UIPlugin.log(e);
                }
            }
            ++n2;
        }
        return false;
    }

    private IResource[] getSelectedResourcesArray() {
        List selection = this.getSelectedResources();
        IResource[] resources = new IResource[selection.size()];
        selection.toArray(resources);
        return resources;
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        Object[] objectArray = selection.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            if (o instanceof IFile && RcpttCore.isQ7ProjectMetadata((IPath)((IFile)o).getFullPath()) || o instanceof Q7ProjectMetadata) {
                return false;
            }
            ++n2;
        }
        if (this.containsOnlyTags(selection)) {
            return true;
        }
        return super.updateSelection(selection);
    }

    private boolean containsOnlyTags(IStructuredSelection selection) {
        int count = 0;
        Object[] objectArray = selection.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            if (!(o instanceof Tag)) {
                return false;
            }
            ++count;
            ++n2;
        }
        return count == 1;
    }

    private List<Tag> getSelectedTags() {
        ArrayList<Tag> tags = new ArrayList<Tag>();
        Object[] objectArray = this.getStructuredSelection().toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            if (o instanceof Tag) {
                tags.add((Tag)o);
            }
            ++n2;
        }
        return tags;
    }
}

