/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rm.lml.core.model;

import java.util.ArrayList;
import java.util.List;

public class RowColumnSorter<T> {
    private final List<T> originList;

    public RowColumnSorter(List<T> list) {
        this.originList = list;
    }

    public List<T> reorder(boolean highestRowFirst, boolean highestColFirst, int cols) {
        ArrayList result = new ArrayList();
        ArrayList<T> list = new ArrayList<T>(this.originList);
        if (highestRowFirst && !highestColFirst) {
            this.revertList(list);
            highestRowFirst = false;
            highestColFirst = true;
        }
        int maxRow = list.size() / cols - 1;
        if (list.size() % cols > 0) {
            ++maxRow;
        }
        int i = 0;
        while (i < cols * (maxRow + 1)) {
            int row = i / cols;
            int col = i % cols;
            int searchedRow = row;
            int searchedCol = col;
            if (highestRowFirst) {
                searchedRow = maxRow - row;
            }
            int maxCol = cols - 1;
            if (searchedRow == maxRow) {
                maxCol = (list.size() - 1) % cols;
            }
            if (highestColFirst) {
                searchedCol = maxCol - col;
            }
            if (searchedCol >= 0 && searchedCol <= maxCol) {
                int index = searchedRow * cols + searchedCol;
                result.add(list.get(index));
            }
            ++i;
        }
        return result;
    }

    private void revertList(List<T> list) {
        int i = 0;
        while (i < list.size() / 2) {
            T tmp = list.get(i);
            int index = list.size() - 1 - i;
            list.set(i, list.get(index));
            list.set(index, tmp);
            ++i;
        }
    }
}

