/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.refactoring.ui.actions;

import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.php.core.PHPVersion;
import org.eclipse.php.core.ast.nodes.ASTNode;
import org.eclipse.php.core.ast.nodes.ASTParser;
import org.eclipse.php.core.ast.nodes.Program;
import org.eclipse.php.core.project.ProjectOptions;
import org.eclipse.php.internal.core.ast.locator.Locator;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.actions.ActionUtils;
import org.eclipse.php.internal.ui.actions.RenamePHPElementAction;
import org.eclipse.php.internal.ui.dialogs.saveFiles.SaveFilesHandler;
import org.eclipse.php.internal.ui.editor.PHPStructuredEditor;
import org.eclipse.php.refactoring.ui.PHPRefactoringUIMessages;
import org.eclipse.php.refactoring.ui.rename.RefactoringExecutionStarter;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.actions.MoveResourceAction;
import org.eclipse.ui.actions.RenameResourceAction;
import org.eclipse.ui.actions.SelectionListenerAction;

public class RefactoringRenameElementAction
extends RenamePHPElementAction {
    private SelectionListenerAction action = null;

    public RefactoringRenameElementAction(IWorkbenchSite site) {
        super(site);
    }

    public RefactoringRenameElementAction(PHPStructuredEditor editor) {
        super(editor);
    }

    public void selectionChanged(IStructuredSelection selection) {
        this.setEnabled(true);
        if (selection instanceof ITextSelection) {
            this.setEnabled(true);
            return;
        }
        if (selection == null || selection.size() != 1) {
            this.setEnabled(false);
            return;
        }
        if (!selection.isEmpty()) {
            if (ActionUtils.containsOnlyProjects((List)selection.toList())) {
                this.setEnabled(this.createWorkbenchAction(selection).isEnabled());
                return;
            }
            this.setEnabled(true);
        }
    }

    public void selectionChanged(ITextSelection selection) {
        this.setEnabled(true);
    }

    private SelectionListenerAction createWorkbenchAction(IStructuredSelection selection) {
        List list = selection.toList();
        if (list.size() == 0 || list.get(0) instanceof IProject) {
            this.action = new RenameResourceAction((IShellProvider)this.getSite());
            this.action.selectionChanged(selection);
        } else {
            this.action = new MoveResourceAction((IShellProvider)this.getSite());
            this.action.selectionChanged(selection);
        }
        return this.action;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void run(IStructuredSelection selection) {
        if (!this.isEnabled()) {
            return;
        }
        try {
            IProject project;
            IResource resource;
            IFile file = null;
            ASTNode locateNode = null;
            if (this.fEditor == null) {
                if (!(selection.getFirstElement() instanceof IResource)) throw new UnsupportedOperationException(String.valueOf(PHPRefactoringUIMessages.getString("RefactoringRenameElementAction.0")) + selection.getFirstElement().getClass().getName());
                resource = (IResource)selection.getFirstElement();
                if (resource instanceof IFile) {
                    file = (IFile)resource;
                }
                project = resource.getProject();
            } else {
                file = ((IFileEditorInput)this.fEditor.getEditorInput()).getFile();
                resource = file;
                if (file == null) {
                    throw new UnsupportedOperationException(String.valueOf(PHPRefactoringUIMessages.getString("RefactoringRenameElementAction.0")) + selection.getFirstElement().getClass().getName());
                }
                IDocument doc = this.fEditor.getDocumentProvider().getDocument((Object)this.fEditor.getEditorInput());
                ITextSelection sel = (ITextSelection)this.fEditor.getSelectionProvider().getSelection();
                int offset = sel.getOffset() + sel.getLength();
                project = resource.getProject();
                ASTParser parser = ASTParser.newParser((Reader)new StringReader(doc.get()), (PHPVersion)ProjectOptions.getPHPVersion((IProject)project), (boolean)ProjectOptions.useShortTags((IProject)project));
                Program program = parser.createAST((IProgressMonitor)new NullProgressMonitor());
                locateNode = Locator.locateNode((Program)program, (int)offset);
            }
            if (!this.checkProjectSaved(project)) return;
            RefactoringExecutionStarter.startRenameRefactoring(resource, locateNode, this.getShell());
            return;
        }
        catch (Exception e) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)PHPUIMessages.RenamePHPElementAction_name, (String)PHPUIMessages.RenamePHPElementAction_not_available);
        }
    }

    private boolean checkProjectSaved(IProject project) {
        SaveFilesHandler.SaveFilesResult result = SaveFilesHandler.handle((IProject)project, (boolean)false, (boolean)false, (IProgressMonitor)new NullProgressMonitor());
        if (!result.isAccepted()) {
            return false;
        }
        List dirtyEditors = SaveFilesHandler.getDirtyEditors((IProject)project);
        return dirtyEditors.size() == 0;
    }

    public void run(ITextSelection selection) {
    }
}

