/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.commands;

import org.eclipse.core.commands.Command;
import org.eclipse.pde.internal.ui.commands.CommandComposerPart;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.forms.widgets.FormToolkit;

public abstract class QueryControl {
    protected final CommandComposerPart fCSP;
    protected final FormToolkit fToolkit;
    protected Button fRadioButton;
    protected Group fGroup;

    protected QueryControl(CommandComposerPart csp, Composite parent) {
        this.fCSP = csp;
        this.fToolkit = csp.getToolkit();
        this.createGroup(parent);
    }

    protected ICommandService getCommandService() {
        return this.fCSP.getCommandService();
    }

    private Group createGroup(Composite parent) {
        this.fRadioButton = this.fToolkit.createButton(parent, "", 16);
        this.fRadioButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.enable(this.fRadioButton.getSelection())));
        this.fGroup = new Group(parent, 0);
        GridData gd = new GridData(768);
        this.fGroup.setLayoutData((Object)gd);
        this.fGroup.setLayout((Layout)new GridLayout());
        this.fGroup.setText(this.getName());
        this.createGroupContents(this.fGroup);
        this.fToolkit.adapt((Control)this.fGroup, false, false);
        return this.fGroup;
    }

    protected QueryControl select(boolean select) {
        this.fRadioButton.setSelection(select);
        return this;
    }

    protected abstract void createGroupContents(Group var1);

    protected abstract String getName();

    protected abstract void enable(boolean var1);

    protected abstract Command[] getCommands();
}

