/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.textedit.port.xtext.ui.contribution;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.uml.alf.naming.ALFIDConverter;
import org.eclipse.papyrus.uml.tools.utils.MultiplicityElementUtil;
import org.eclipse.papyrus.uml.tools.utils.NamedElementUtil;
import org.eclipse.papyrus.uml.tools.utils.PortUtil;
import org.eclipse.papyrus.uml.tools.utils.PropertyUtil;
import org.eclipse.papyrus.uml.xtext.integration.CompletionProposalUtils;
import org.eclipse.uml2.uml.LiteralBoolean;
import org.eclipse.uml2.uml.LiteralInteger;
import org.eclipse.uml2.uml.LiteralNull;
import org.eclipse.uml2.uml.LiteralReal;
import org.eclipse.uml2.uml.LiteralString;
import org.eclipse.uml2.uml.LiteralUnlimitedNatural;
import org.eclipse.uml2.uml.MultiplicityElement;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.util.UMLSwitch;

public class UMLPortEditorPropertyUtil
extends PortUtil {
    public static String getLabel(Port port) {
        String defaultValue;
        StringBuffer buffer = new StringBuffer();
        buffer.append(NamedElementUtil.getVisibilityAsSign((NamedElement)port));
        buffer.append(" ");
        buffer.append(UMLPortEditorPropertyUtil.getDerived((Property)port));
        buffer.append(ALFIDConverter.nameToID((String)UMLPortEditorPropertyUtil.getName((Property)port)));
        if (port.isConjugated()) {
            buffer.append(" : ~");
        } else {
            buffer.append(" : ");
        }
        if (port.getType() != null) {
            buffer.append(CompletionProposalUtils.getQualifiedNameLabelWithSufficientDepth((NamedElement)port.getType(), (Namespace)port.getNamespace()));
        } else {
            buffer.append("<Undefined>");
        }
        String multiplicity = MultiplicityElementUtil.getMultiplicityAsString((MultiplicityElement)port, (boolean)true);
        if (!multiplicity.trim().equals("[1]")) {
            buffer.append(multiplicity);
        }
        buffer.append(" ");
        String modifiers = PropertyUtil.getModifiersAsString((Property)port, (boolean)false);
        if (!"".equals(modifiers)) {
            buffer.append(modifiers);
            buffer.append(" ");
        }
        if (port.getDefaultValue() != null && (defaultValue = (String)new UMLSwitch<String>(){

            public String caseLiteralBoolean(LiteralBoolean object) {
                return Boolean.toString(object.booleanValue());
            }

            public String caseLiteralInteger(LiteralInteger object) {
                return Integer.toString(object.integerValue());
            }

            public String caseLiteralNull(LiteralNull object) {
                return "null";
            }

            public String caseLiteralString(LiteralString object) {
                return "\"" + object.stringValue() + "\"";
            }

            public String caseLiteralReal(LiteralReal object) {
                return Double.toString(object.getValue());
            }

            public String caseLiteralUnlimitedNatural(LiteralUnlimitedNatural object) {
                return object.getValue() < 0 ? "*" : Integer.toString(object.getValue());
            }
        }.doSwitch((EObject)port.getDefaultValue())) != null) {
            buffer.append("= ");
            buffer.append(defaultValue);
        }
        return buffer.toString();
    }
}

