/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.decoratormodel.internal.resource.index;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.uml2.uml.UMLPackage;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class AbstractUMLIndexHandler
extends DefaultHandler {
    protected final URI fileURI;
    private final Map<String, Map<String, String>> packageToProfileApplications = Maps.newHashMap();
    private String umlNamespace;
    private String umlPrefix;
    private String xmiType;
    private String xmiID;
    private Set<String> packageTypes;
    private String eAnnotations;
    private String references;
    private UMLElement top;
    private int ignore;
    protected UMLElement currentPackage;
    private Await await = new Await();

    public AbstractUMLIndexHandler(URI fileURI) {
        this.fileURI = fileURI;
    }

    public URI getFileURI() {
        return this.fileURI;
    }

    public Map<String, Map<String, String>> getProfileApplicationsByPackage() {
        return this.packageToProfileApplications;
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        if (uri.startsWith("http://schema.omg.org/spec/XMI/") || uri.startsWith("http://www.omg.org/spec/XMI/")) {
            this.xmiType = this.qname(prefix, "type");
            this.xmiID = this.qname(prefix, "id");
        } else if (EPackage.Registry.INSTANCE.getEPackage(uri) == UMLPackage.eINSTANCE) {
            this.umlNamespace = uri;
            this.umlPrefix = prefix;
            this.initializeUMLElementNames();
        }
    }

    protected void initializeUMLElementNames() {
        this.packageTypes = ImmutableSet.of((Object)this.umlElement("Package"), (Object)this.umlElement("Model"), (Object)this.umlElement("Profile"));
        this.eAnnotations = "eAnnotations";
        this.references = "references";
    }

    protected final String umlElement(String name) {
        return this.qname(this.umlPrefix, name);
    }

    protected final String qname(String prefix, String name) {
        StringBuilder buf = new StringBuilder(prefix.length() + name.length() + 1);
        return buf.append(prefix).append(':').append(name).toString();
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if ((this.umlNamespace.equals(uri) || this.top != null) && !this.ignore(qName, attributes)) {
            this.push(qName, attributes);
            this.handleUMLElement(this.top, attributes);
        }
    }

    protected boolean ignore(String qName, Attributes attributes) {
        boolean result = false;
        if (attributes != null) {
            boolean bl = result = this.ignore > 0 || this.eAnnotations.equals(qName) && !"http://www.eclipse.org/uml2/2.0.0/UML".equals(attributes.getValue("source"));
            if (result) {
                ++this.ignore;
            }
        } else {
            boolean bl = result = this.ignore > 0;
            if (result) {
                --this.ignore;
            }
        }
        return result;
    }

    protected final void push(String qName, Attributes attributes) {
        this.top = new UMLElement(qName, attributes);
    }

    protected final UMLElement pop() {
        UMLElement result = this.top;
        if (this.top != null) {
            this.top = this.top.parent;
        }
        return result;
    }

    protected void handleUMLElement(UMLElement element, Attributes attributes) throws SAXException {
        if (element.isPackage() && element.getHREF() == null) {
            this.currentPackage = element;
            this.enterPackage(this.currentPackage, attributes);
        }
        if (!this.doHandleUMLElement(element, attributes)) {
            if (element.isA("http://www.eclipse.org/uml2/2.0.0/UML")) {
                this.await.push(this.references);
            } else if (this.await.isAwaiting(element)) {
                if (element.isRole(this.references)) {
                    this.handleAnnotationReferences(element);
                } else {
                    this.handleAwaitedElement(element);
                }
                this.await.pop();
            }
        }
    }

    protected void enterPackage(UMLElement package_, Attributes attributes) {
    }

    protected void exitPackage(UMLElement package_) {
    }

    protected abstract boolean doHandleUMLElement(UMLElement var1, Attributes var2);

    protected final void await(String elementName) {
        this.await.push(elementName);
    }

    protected void handleAnnotationReferences(UMLElement references) {
    }

    protected abstract void handleAwaitedElement(UMLElement var1);

    protected abstract void summarize();

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (!this.ignore(qName, null)) {
            if (this.await.stopAt(this.pop())) {
                this.await.pop();
            }
            if (this.top != null) {
                UMLElement newPackage = this.top.nearestPackage();
                if (newPackage != this.currentPackage && this.currentPackage != null) {
                    this.exitPackage(this.currentPackage);
                }
                this.currentPackage = newPackage;
            }
            if (this.top == null) {
                this.summarize();
                throw new OperationCanceledException();
            }
        }
    }

    private final class Await {
        final Await parent;
        final String awaiting;
        final UMLElement limit;

        Await() {
            this(null);
        }

        private Await(String awaiting) {
            this.parent = AbstractUMLIndexHandler.this.await;
            this.awaiting = awaiting;
            this.limit = AbstractUMLIndexHandler.this.top;
        }

        boolean isRoot() {
            return this.parent == null;
        }

        boolean isAwaiting(UMLElement element) {
            return !this.isRoot() && element.isRole(this.awaiting);
        }

        boolean stopAt(UMLElement element) {
            return !this.isRoot() && this.limit == element;
        }

        Await push(String elementName) {
            Await result = new Await(elementName);
            AbstractUMLIndexHandler.this.await = result;
            return result;
        }

        void pop() {
            if (!this.isRoot()) {
                AbstractUMLIndexHandler.this.await = this.parent;
            }
        }
    }

    protected final class UMLElement {
        final UMLElement parent;
        final String role;
        final String type;
        final String id;
        final String href;

        UMLElement(String qName, Attributes attributes) {
            String type;
            this.parent = AbstractUMLIndexHandler.this.top;
            if (qName.equals(AbstractUMLIndexHandler.this.eAnnotations)) {
                type = attributes.getValue("source");
            } else {
                type = attributes.getValue(AbstractUMLIndexHandler.this.xmiType);
                if (Strings.isNullOrEmpty((String)type)) {
                    type = qName;
                }
            }
            this.role = qName;
            this.type = type;
            this.id = attributes.getValue(AbstractUMLIndexHandler.this.xmiID);
            this.href = attributes.getValue("href");
        }

        boolean isPackage() {
            return AbstractUMLIndexHandler.this.packageTypes.contains(this.type);
        }

        boolean isRole(String roleName) {
            return roleName.equals(this.role);
        }

        boolean isA(String xmiType) {
            return xmiType.equals(this.type);
        }

        URI getHREF() {
            return Strings.isNullOrEmpty((String)this.href) ? null : URI.createURI((String)this.href).resolve(AbstractUMLIndexHandler.this.fileURI);
        }

        UMLElement nearestPackage() {
            UMLElement next = this;
            while (next != null) {
                if (next.isPackage()) {
                    return next;
                }
                next = next.parent;
            }
            return null;
        }
    }

    protected static final class URIPair {
        public URI first;
        public URI second;

        protected URIPair() {
        }
    }
}

