/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.services.decoration.util;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.papyrus.infra.services.decoration.Activator;
import org.eclipse.papyrus.infra.services.decoration.IDecorationSpecificFunctions;

public class DecorationSpecificFunctions {
    public static final String DECORATION_SPECIFIC_FUNCTIONS_ID = "org.eclipse.papyrus.infra.services.decoration.decorationSpecificFunctions";
    public static final String DECORATION_TYPE_ID = "decorationType";
    public static Map<String, IDecorationSpecificFunctions> decorationFunctions;

    public static IDecorationSpecificFunctions getDecorationInterface(String decorationType) {
        if (decorationFunctions == null) {
            DecorationSpecificFunctions.parseDecorationFunctions();
        }
        return decorationFunctions.get(decorationType);
    }

    private static void parseDecorationFunctions() {
        IConfigurationElement[] configElements;
        decorationFunctions = new HashMap<String, IDecorationSpecificFunctions>();
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = configElements = reg.getConfigurationElementsFor(DECORATION_SPECIFIC_FUNCTIONS_ID);
        int n = configElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement configElement = iConfigurationElementArray[n2];
            try {
                String iConfiguratorIDext = configElement.getAttribute(DECORATION_TYPE_ID);
                if (iConfiguratorIDext != null) {
                    Object obj = configElement.createExecutableExtension("class");
                    if (obj instanceof IDecorationSpecificFunctions) {
                        decorationFunctions.put(iConfiguratorIDext, (IDecorationSpecificFunctions)obj);
                    } else {
                        Activator.log.warn(String.format("The plug-in %s contributed an invalid class to the %s extension point. Contributions should extend %s", configElement.getContributor(), DECORATION_SPECIFIC_FUNCTIONS_ID, IDecorationSpecificFunctions.class.getSimpleName()));
                    }
                }
            }
            catch (CoreException exception) {
                Activator.log.error((Throwable)exception);
            }
            ++n2;
        }
    }
}

