/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.emf.utils;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.emf.ecore.xmi.impl.URIHandlerImpl;

public class ResourceUtils {
    private ResourceUtils() {
    }

    public static IFile getFile(Resource resource) {
        if (resource != null) {
            URI uri = resource.getURI();
            uri = resource.getResourceSet().getURIConverter().normalize(uri);
            if (uri.isPlatformResource()) {
                String uriPlatformString = uri.toPlatformString(true);
                return ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(uriPlatformString));
            }
        }
        return null;
    }

    public static Collection<String> getAllResourceIds(XMIResource resource) {
        HashSet<String> ids = new HashSet<String>();
        TreeIterator iterator = resource.getAllContents();
        while (iterator.hasNext()) {
            EObject current = (EObject)iterator.next();
            String id = resource.getID(current);
            Assert.isNotNull((Object)id);
            Assert.isTrue((!ids.contains(id) ? 1 : 0) != 0);
            ids.add(id);
        }
        return ids;
    }

    public static Map<String, Object> getSaveOptions() {
        HashMap<String, Object> saveOptions = new HashMap<String, Object>();
        saveOptions.put("DECLARE_XML", Boolean.TRUE);
        saveOptions.put("PROCESS_DANGLING_HREF", "DISCARD");
        saveOptions.put("SCHEMA_LOCATION", Boolean.TRUE);
        saveOptions.put("USE_XMI_TYPE", Boolean.TRUE);
        saveOptions.put("SAVE_TYPE_INFORMATION", Boolean.TRUE);
        saveOptions.put("SKIP_ESCAPE_URI", Boolean.FALSE);
        saveOptions.put("ENCODING", "UTF-8");
        saveOptions.put("URI_HANDLER", new URIHandlerImpl.PlatformSchemeAware());
        return saveOptions;
    }
}

