/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.library;

import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.OperationCallExp;
import org.eclipse.ocl.pivot.TypedElement;
import org.eclipse.ocl.pivot.evaluation.Evaluator;
import org.eclipse.ocl.pivot.evaluation.Executor;
import org.eclipse.ocl.pivot.ids.TypeId;
import org.eclipse.ocl.pivot.library.AbstractOperation;
import org.eclipse.ocl.pivot.library.LibraryBinaryOperation;
import org.eclipse.ocl.pivot.library.LibraryTernaryOperation;
import org.eclipse.ocl.pivot.library.LibraryUnaryOperation;

public abstract class AbstractPolyOperation
extends AbstractOperation
implements LibraryUnaryOperation.LibraryUnaryOperationExtension,
LibraryBinaryOperation.LibraryBinaryOperationExtension,
LibraryTernaryOperation.LibraryTernaryOperationExtension {
    @Override
    public @Nullable Object dispatch(@NonNull Executor executor, @NonNull OperationCallExp callExp, @Nullable Object sourceValue) {
        TypeId typeId = callExp.getTypeId();
        List<OCLExpression> arguments = callExp.getOwnedArguments();
        if (arguments.size() == 0) {
            return this.evaluate(executor, typeId, sourceValue);
        }
        OCLExpression argument0 = arguments.get(0);
        assert (argument0 != null);
        Object firstArgument = executor.evaluate(argument0);
        if (arguments.size() == 1) {
            return this.evaluate(executor, typeId, sourceValue, firstArgument);
        }
        OCLExpression argument1 = arguments.get(1);
        assert (argument1 != null);
        Object secondArgument = executor.evaluate(argument1);
        if (arguments.size() == 2) {
            return this.evaluate(executor, typeId, sourceValue, firstArgument, secondArgument);
        }
        Object[] argumentValues = new Object[arguments.size()];
        argumentValues[0] = firstArgument;
        argumentValues[1] = secondArgument;
        int i = 2;
        while (i < arguments.size()) {
            OCLExpression argument = arguments.get(i);
            assert (argument != null);
            argumentValues[i] = executor.evaluate(argument);
            ++i;
        }
        return this.evaluate(executor, typeId, sourceValue, (Object)argumentValues);
    }

    @Override
    @Deprecated
    public @Nullable Object evaluate(@NonNull Evaluator evaluator, @NonNull TypeId returnTypeId, @Nullable Object sourceValue) {
        return this.evaluate(AbstractPolyOperation.getExecutor(evaluator), returnTypeId, sourceValue);
    }

    @Override
    @Deprecated
    public @Nullable Object evaluate(@NonNull Evaluator evaluator, @NonNull TypeId returnTypeId, @Nullable Object sourceValue, @Nullable Object argVal) {
        return this.evaluate(AbstractPolyOperation.getExecutor(evaluator), returnTypeId, sourceValue, argVal);
    }

    @Override
    @Deprecated
    public @Nullable Object evaluate(@NonNull Evaluator evaluator, @NonNull TypeId returnTypeId, @Nullable Object sourceValue, @Nullable Object firstArgumentValue, @Nullable Object secondArgumentValue) {
        return this.evaluate(AbstractPolyOperation.getExecutor(evaluator), returnTypeId, sourceValue, firstArgumentValue, secondArgumentValue);
    }

    @Override
    public @Nullable Object evaluate(@NonNull Executor executor, @NonNull TypedElement caller, @Nullable Object @NonNull [] boxedSourceAndArgumentValues) {
        TypeId typeId = caller.getTypeId();
        if (boxedSourceAndArgumentValues.length == 1) {
            return this.evaluate(executor, typeId, boxedSourceAndArgumentValues[0]);
        }
        if (boxedSourceAndArgumentValues.length == 2) {
            return this.evaluate(executor, typeId, boxedSourceAndArgumentValues[0], boxedSourceAndArgumentValues[1]);
        }
        if (boxedSourceAndArgumentValues.length == 3) {
            return this.evaluate(executor, typeId, boxedSourceAndArgumentValues[0], boxedSourceAndArgumentValues[1], boxedSourceAndArgumentValues[2]);
        }
        return this.evaluate(executor, typeId, (Object)boxedSourceAndArgumentValues);
    }
}

