/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.values;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.ids.CollectionTypeId;
import org.eclipse.ocl.pivot.ids.IdResolver;
import org.eclipse.ocl.pivot.internal.values.BagImpl;
import org.eclipse.ocl.pivot.internal.values.CollectionValueImpl;
import org.eclipse.ocl.pivot.internal.values.SparseSequenceValueImpl;
import org.eclipse.ocl.pivot.values.Bag;
import org.eclipse.ocl.pivot.values.BagValue;
import org.eclipse.ocl.pivot.values.CollectionValue;
import org.eclipse.ocl.pivot.values.InvalidValueException;
import org.eclipse.ocl.pivot.values.SequenceValue;
import org.eclipse.ocl.pivot.values.ValuesPackage;

public class BagValueImpl
extends CollectionValueImpl
implements BagValue {
    @Override
    protected EClass eStaticClass() {
        return ValuesPackage.Literals.BAG_VALUE;
    }

    public static @NonNull Bag<Object> createBagOfEach(@Nullable Object @NonNull [] boxedValues) {
        BagImpl<Object> result = new BagImpl<Object>();
        Object[] objectArray = boxedValues;
        int n = boxedValues.length;
        int n2 = 0;
        while (n2 < n) {
            Object boxedValue = objectArray[n2];
            result.add(boxedValue);
            ++n2;
        }
        return result;
    }

    public BagValueImpl(@NonNull CollectionTypeId typeId, @NonNull Bag<? extends Object> boxedValues) {
        super(typeId, boxedValues);
    }

    @Override
    public @NonNull BagValue asBagValue() {
        return this;
    }

    @Override
    public @NonNull Bag<Object> asUnboxedObject(@NonNull IdResolver idResolver) {
        BagImpl<Object> unboxedValues = new BagImpl<Object>();
        for (Object boxedValue : this.elements) {
            unboxedValues.add(idResolver.unboxedValueOf(boxedValue));
        }
        return unboxedValues;
    }

    public boolean equals(Object thatObject) {
        if (this == thatObject) {
            return true;
        }
        if (!(thatObject instanceof BagValue)) {
            return false;
        }
        return this.elements.equals(((BagValue)thatObject).getElements());
    }

    @Override
    public @NonNull BagValue excluding(@Nullable Object value) {
        BagImpl result = new BagImpl();
        if (value == null) {
            for (Object element : this.elements) {
                if (element == null) continue;
                result.add(element);
            }
        } else {
            for (Object element : this.elements) {
                if (value.equals(element)) continue;
                result.add(element);
            }
        }
        if (result.size() < this.elements.size()) {
            return new BagValueImpl(this.getTypeId(), result);
        }
        return this;
    }

    @Override
    public @NonNull BagValue excludingAll(@NonNull CollectionValue values) {
        BagImpl result = new BagImpl();
        for (Object element : this.elements) {
            boolean reject = false;
            if (element == null) {
                for (Object value : values) {
                    if (value != null) continue;
                    reject = true;
                    break;
                }
            } else {
                for (Object value : values) {
                    if (value == null || !value.equals(element)) continue;
                    reject = true;
                    break;
                }
            }
            if (reject) continue;
            result.add(element);
        }
        if (result.size() < this.elements.size()) {
            return new BagValueImpl(this.getTypeId(), result);
        }
        return this;
    }

    @Override
    public @NonNull BagValue flatten() {
        BagImpl<Object> flattened = new BagImpl<Object>();
        if (this.flatten(flattened)) {
            return new BagValueImpl(this.getTypeId(), (Bag<? extends Object>)flattened);
        }
        return this;
    }

    public @NonNull Bag<? extends Object> getElements() {
        return (Bag)this.elements;
    }

    @Override
    public @NonNull String getKind() {
        return "Bag";
    }

    @Override
    public @NonNull BagValue including(@Nullable Object value) {
        assert (!(value instanceof InvalidValueException));
        Collection iterables = this.elements;
        BagImpl<Object> result = new BagImpl<Object>(iterables);
        result.add(value);
        return new BagValueImpl(this.getTypeId(), (Bag<? extends Object>)result);
    }

    @Override
    public @NonNull BagValue includingAll(@NonNull CollectionValue values) {
        Collection iterables = this.elements;
        BagImpl<Object> result = new BagImpl<Object>(iterables);
        for (Object value : values) {
            result.add(value);
        }
        return new BagValueImpl(this.getTypeId(), (Bag<? extends Object>)result);
    }

    @Override
    public boolean isOrdered() {
        return false;
    }

    @Override
    public boolean isUnique() {
        return false;
    }

    @Override
    public @NonNull SequenceValue sort(@NonNull Comparator<Object> comparator) {
        ArrayList values = new ArrayList(this.elements);
        Collections.sort(values, comparator);
        return new SparseSequenceValueImpl(this.getSequenceTypeId(), values);
    }

    @Override
    public @NonNull SequenceValue toSequenceValue() {
        return new SparseSequenceValueImpl(this.getSequenceTypeId(), new ArrayList(this.elements));
    }

    @Override
    public void toString(@NonNull StringBuilder s, int lengthLimit) {
        s.append("Bag");
        super.toString(s, lengthLimit);
    }

    public static class Accumulator
    extends BagValueImpl
    implements BagValue.Accumulator {
        public Accumulator(@NonNull CollectionTypeId typeId) {
            super(typeId, new BagImpl());
        }

        @Override
        public boolean add(@Nullable Object value) {
            return this.elements.add(value);
        }
    }
}

