/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.internal.osgi.weaving;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.zip.CRC32;
import org.eclipse.objectteams.otequinox.TransformerPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.hooks.weaving.WovenClass;

public class BCELPatcher {
    static final String BCEL_PLUGIN_ID = "org.apache.bcel";
    private static final String BCEL_PATH_DIR = "bcelpatch/";

    public static void fixBCEL(WovenClass clazz) {
        String detail;
        long crc;
        CRC32 crc32;
        String name = clazz.getClassName();
        byte[] classbytes = clazz.getBytes();
        boolean shouldPatch = false;
        if ("org.apache.bcel.generic.InstructionHandle".equals(name)) {
            crc32 = new CRC32();
            crc32.update(classbytes);
            crc = crc32.getValue();
            detail = "";
            if (classbytes.length != 5667) {
                detail = String.valueOf(detail) + "\n\tlength=" + classbytes.length;
            }
            if (crc != 1108549767L && crc != 3676018777L) {
                detail = String.valueOf(detail) + "\n\tcrc=" + crc;
            }
            if (classbytes[3840] != 24) {
                detail = String.valueOf(detail) + "\n\tmodifiers of getInstructionHandle=" + classbytes[3840];
            }
            if (classbytes[4188] != 4) {
                detail = String.valueOf(detail) + "\n\tmodifiers of addHandle=" + classbytes[4188];
            }
            if (detail.length() == 0) {
                shouldPatch = true;
            } else {
                TransformerPlugin.log(2, "Class org.apache.bcel.generic.InstructionHandle needs a hot-patch but has unexpected byte code:" + detail);
            }
        } else if ("org.apache.bcel.generic.BranchHandle".equals(name)) {
            crc32 = new CRC32();
            crc32.update(classbytes);
            crc = crc32.getValue();
            detail = "";
            if (classbytes.length != 2545) {
                detail = String.valueOf(detail) + "\n\tlength=" + classbytes.length;
            }
            if (crc != 3552803865L && crc != 1958668062L) {
                detail = String.valueOf(detail) + "\n\tcrc=" + crc;
            }
            if (classbytes[1662] != 24) {
                detail = String.valueOf(detail) + "\n\tmodifiers of getBranchHandle=" + classbytes[1662];
            }
            if (classbytes[1784] != 4) {
                detail = String.valueOf(detail) + "\n\tmodifiers of addHandle=" + classbytes[1784];
            }
            if (detail.length() == 0) {
                shouldPatch = true;
            } else {
                TransformerPlugin.log(2, "Class org.apache.bcel.generic.BranchHandle needs a hot-patch but has unexpected byte code:" + detail);
            }
        }
        if (shouldPatch) {
            Bundle otequinoxBundle = TransformerPlugin.getBundle();
            URL entry = otequinoxBundle.getEntry(BCEL_PATH_DIR + name + ".class");
            try {
                Throwable throwable = null;
                Object var7_7 = null;
                try (InputStream stream = entry.openStream();){
                    int len = stream.available();
                    byte[] newBytes = new byte[len];
                    stream.read(newBytes);
                    TransformerPlugin.log(1, "hot-patched a bug in class " + name + "\n" + "\tsee https://bugs.eclipse.org/bugs/show_bug.cgi?id=344350");
                    clazz.setBytes(newBytes);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                TransformerPlugin.log(e, "Failed to hot-patch bcel class " + name);
            }
        }
    }
}

