/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.search.strategy;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.regex.PatternSyntaxException;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.coordinate.PositionCoordinate;
import org.eclipse.nebula.widgets.nattable.coordinate.Range;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.search.strategy.AbstractSearchStrategy;
import org.eclipse.nebula.widgets.nattable.search.strategy.CellDisplayValueSearchUtil;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;

public class GridSearchStrategy
extends AbstractSearchStrategy {
    private final IConfigRegistry configRegistry;

    public GridSearchStrategy(IConfigRegistry configRegistry, boolean wrapSearch, boolean columnFirst) {
        this(configRegistry, wrapSearch, "forward", columnFirst);
    }

    public GridSearchStrategy(IConfigRegistry configRegistry, boolean wrapSearch, String searchDirection, boolean columnFirst) {
        this.configRegistry = configRegistry;
        this.wrapSearch = wrapSearch;
        this.searchDirection = searchDirection;
        this.columnFirst = columnFirst;
    }

    @Override
    public PositionCoordinate executeSearch(Object valueToMatch) throws PatternSyntaxException {
        boolean startWithNextCell;
        int secondDimEnd;
        int secondDimStart;
        int firstDimEnd;
        int firstDimStart;
        ILayerCell cellByPosition;
        int secondDimCount;
        int secondDimPosition;
        int firstDimCount;
        int firstDimPosition;
        boolean hadSelectionAnchor;
        ILayer contextLayer = this.getContextLayer();
        if (!(contextLayer instanceof SelectionLayer)) {
            throw new RuntimeException("For the GridSearchStrategy to work it needs the selectionLayer to be passed as the contextLayer.");
        }
        SelectionLayer selectionLayer = (SelectionLayer)contextLayer;
        PositionCoordinate selectionAnchor = selectionLayer.getSelectionAnchor();
        int direction = this.searchDirection.equals("forward") ? 1 : -1;
        boolean bl = hadSelectionAnchor = selectionAnchor.columnPosition >= 0 && selectionAnchor.rowPosition >= 0;
        if (!hadSelectionAnchor) {
            selectionAnchor.columnPosition = 0;
            selectionAnchor.rowPosition = 0;
        }
        if (this.columnFirst) {
            firstDimPosition = selectionAnchor.columnPosition;
            firstDimCount = selectionLayer.getColumnCount();
            secondDimPosition = selectionAnchor.rowPosition;
            secondDimCount = selectionLayer.getRowCount();
            if (direction < 0) {
                cellByPosition = selectionLayer.getCellByPosition(selectionAnchor.columnPosition, selectionAnchor.rowPosition);
                firstDimPosition = selectionAnchor.columnPosition + cellByPosition.getColumnSpan() - 1;
            }
        } else {
            firstDimPosition = selectionAnchor.rowPosition;
            firstDimCount = selectionLayer.getRowCount();
            secondDimPosition = selectionAnchor.columnPosition;
            secondDimCount = selectionLayer.getColumnCount();
            if (direction < 0) {
                cellByPosition = selectionLayer.getCellByPosition(selectionAnchor.columnPosition, selectionAnchor.rowPosition);
                firstDimPosition = selectionAnchor.rowPosition + cellByPosition.getRowSpan() - 1;
            }
        }
        if (direction == 1) {
            firstDimStart = 0;
            firstDimEnd = firstDimCount;
            secondDimStart = 0;
            secondDimEnd = secondDimCount;
        } else {
            firstDimStart = firstDimCount - 1;
            firstDimEnd = -1;
            secondDimStart = secondDimCount - 1;
            secondDimEnd = -1;
        }
        boolean bl2 = startWithNextCell = hadSelectionAnchor && !this.isIncremental();
        if (startWithNextCell) {
            if (secondDimPosition + direction != secondDimEnd) {
                secondDimPosition += direction;
            } else {
                secondDimPosition = secondDimStart;
                if (firstDimPosition + direction != firstDimEnd) {
                    firstDimPosition += direction;
                } else if (this.wrapSearch) {
                    firstDimPosition = firstDimStart;
                } else {
                    return null;
                }
            }
        }
        List<GridRectangle> gridRanges = this.getRanges(firstDimPosition, secondDimPosition, direction, firstDimStart, firstDimEnd, secondDimStart, secondDimEnd);
        Comparator<String> comparator = this.getComparator();
        return CellDisplayValueSearchUtil.findCell(this.getContextLayer(), this.configRegistry, gridRanges, valueToMatch, comparator, this.isCaseSensitive(), this.isWholeWord(), this.isRegex(), this.isColumnFirst(), this.isIncludeCollapsed());
    }

    private List<GridRectangle> getRanges(int firstDimPosition, int secondDimPosition, int direction, int firstDimStart, int firstDimEnd, int secondDimStart, int secondDimEnd) {
        ArrayList<GridRectangle> gridRanges = new ArrayList<GridRectangle>();
        GridRectangle gridRange = new GridRectangle();
        gridRange.firstDim = new Range(firstDimPosition, firstDimPosition + direction);
        gridRange.secondDim = new Range(secondDimPosition, secondDimEnd);
        gridRanges.add(gridRange);
        if (firstDimStart == 0 && firstDimEnd == 0) {
            return gridRanges;
        }
        gridRange = new GridRectangle();
        gridRange.firstDim = new Range(firstDimPosition + direction, firstDimEnd);
        gridRange.secondDim = new Range(secondDimStart, secondDimEnd);
        gridRanges.add(gridRange);
        if (!this.wrapSearch || firstDimPosition == firstDimStart && secondDimPosition == secondDimStart) {
            return gridRanges;
        }
        gridRange = new GridRectangle();
        gridRange.firstDim = new Range(firstDimStart, firstDimPosition);
        gridRange.secondDim = new Range(secondDimStart, secondDimEnd);
        gridRanges.add(gridRange);
        gridRange = new GridRectangle();
        gridRange.firstDim = new Range(firstDimPosition, firstDimPosition + direction);
        gridRange.secondDim = new Range(secondDimStart, secondDimPosition);
        gridRanges.add(gridRange);
        return gridRanges;
    }

    public static class GridRectangle {
        Range firstDim;
        Range secondDim;
    }
}

