/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.inspections;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import java.util.regex.Pattern;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.internal.Messages;
import org.eclipse.mat.query.Bytes;
import org.eclipse.mat.query.Column;
import org.eclipse.mat.query.ContextProvider;
import org.eclipse.mat.query.IContextObject;
import org.eclipse.mat.query.IQuery;
import org.eclipse.mat.query.IResult;
import org.eclipse.mat.query.IResultTree;
import org.eclipse.mat.query.ResultMetaData;
import org.eclipse.mat.query.annotations.Argument;
import org.eclipse.mat.query.annotations.CommandName;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.util.IProgressListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@CommandName(value="big_drops_in_dominator_tree")
public class BigDropsQuery
implements IQuery,
IResultTree {
    private static final int ROOT_ID = -1;
    private static final String ROOT_LABEL = Messages.BigDropsQuery_Root;
    @Argument
    public ISnapshot snapshot;
    @Argument(advice=Argument.Advice.CLASS_NAME_PATTERN, isMandatory=false, flag="skip")
    public Pattern pattern = Pattern.compile("java.*|com\\.sun.\\.*");
    public int thresholdPercent = 1;
    BigDropEntry rootEntry;

    public IResult execute(IProgressListener listener) throws Exception {
        this.buildTree((long)this.thresholdPercent * this.snapshot.getSnapshotInfo().getUsedHeapSize() / 100L, listener);
        return this;
    }

    private void buildTree(long threshold, IProgressListener listener) throws SnapshotException {
        StackEntry entry = new StackEntry(-1, this.snapshot.getSnapshotInfo().getUsedHeapSize(), this.snapshot.getImmediateDominatedIds(-1), 0);
        Stack<StackEntry> stack = new Stack<StackEntry>();
        stack.push(entry);
        this.rootEntry = new BigDropEntry(-1, ROOT_LABEL, this.snapshot.getSnapshotInfo().getUsedHeapSize(), entry.children.length, -1, ROOT_LABEL, this.snapshot.getSnapshotInfo().getUsedHeapSize());
        Stack<BigDropEntry> dropsStack = new Stack<BigDropEntry>();
        dropsStack.push(this.rootEntry);
        int iterations = 0;
        while (stack.size() > 0) {
            if ((++iterations & 0xFFF) == 0 && listener.isCanceled()) {
                throw new IProgressListener.OperationCanceledException();
            }
            entry = (StackEntry)stack.peek();
            if (entry.nextChild == 0) {
                if (entry.children.length == 0) {
                    if (entry.parentSize > threshold && stack.size() > 1) {
                        IObject obj = this.snapshot.getObject(entry.parentId);
                        IObject dominatorObject = this.getDominator(obj);
                        BigDropEntry newBigDrop = null;
                        newBigDrop = dominatorObject == null ? new BigDropEntry(obj.getObjectId(), obj.getDisplayName(), obj.getRetainedHeapSize(), entry.children.length, -1, ROOT_LABEL, this.rootEntry.objectRetainedSize.getValue()) : new BigDropEntry(obj.getObjectId(), obj.getDisplayName(), obj.getRetainedHeapSize(), entry.children.length, dominatorObject.getObjectId(), dominatorObject.getDisplayName(), dominatorObject.getRetainedHeapSize());
                        BigDropEntry dropParent = (BigDropEntry)dropsStack.peek();
                        dropParent.children.add(newBigDrop);
                    }
                    stack.pop();
                    continue;
                }
                long childRetainedSize = this.snapshot.getRetainedHeapSize(entry.children[entry.nextChild]);
                if (entry.parentSize - childRetainedSize > threshold) {
                    if (stack.size() > 1) {
                        IObject obj = this.snapshot.getObject(entry.parentId);
                        IObject dominatorObject = this.getDominator(obj);
                        BigDropEntry newBigDrop = null;
                        newBigDrop = dominatorObject == null ? new BigDropEntry(obj.getObjectId(), obj.getDisplayName(), obj.getRetainedHeapSize(), entry.children.length, -1, ROOT_LABEL, this.rootEntry.objectRetainedSize.getValue()) : new BigDropEntry(obj.getObjectId(), obj.getDisplayName(), obj.getRetainedHeapSize(), entry.children.length, dominatorObject.getObjectId(), dominatorObject.getDisplayName(), dominatorObject.getRetainedHeapSize());
                        BigDropEntry dropParent = (BigDropEntry)dropsStack.peek();
                        dropParent.children.add(newBigDrop);
                        dropsStack.push(newBigDrop);
                    }
                } else {
                    stack.pop();
                    stack.push(new StackEntry(entry.children[entry.nextChild], childRetainedSize, this.snapshot.getImmediateDominatedIds(entry.children[entry.nextChild]), 0));
                    continue;
                }
            }
            if (entry.nextChild < entry.children.length) {
                long childRetainedSize = this.snapshot.getRetainedHeapSize(entry.children[entry.nextChild]);
                if (childRetainedSize > threshold) {
                    stack.push(new StackEntry(entry.children[entry.nextChild], childRetainedSize, this.snapshot.getImmediateDominatedIds(entry.children[entry.nextChild]), 0));
                    ++entry.nextChild;
                    continue;
                }
                stack.pop();
                if (entry.parentId != ((BigDropEntry)dropsStack.peek()).objectId) continue;
                dropsStack.pop();
                continue;
            }
            stack.pop();
            if (entry.parentId != ((BigDropEntry)dropsStack.peek()).objectId) continue;
            dropsStack.pop();
        }
    }

    private IObject getDominator(IObject object) throws SnapshotException {
        while (this.pattern.matcher(object.getTechnicalName()).matches()) {
            int dominatorId = this.snapshot.getImmediateDominatorId(object.getObjectId());
            if (dominatorId == -1) {
                return null;
            }
            object = this.snapshot.getObject(dominatorId);
        }
        return object;
    }

    public ResultMetaData getResultMetaData() {
        ResultMetaData.Builder b = new ResultMetaData.Builder();
        ContextProvider[] contextProviderArray = this.getContextProviders();
        int n = contextProviderArray.length;
        int n2 = 0;
        while (n2 < n) {
            ContextProvider prov = contextProviderArray[n2];
            b.addContext(prov);
            ++n2;
        }
        return b.build();
    }

    public Column[] getColumns() {
        return new Column[]{new Column(Messages.BigDropsQuery_Column_AccumulationPoint), new Column(Messages.BigDropsQuery_Column_AccPtSize, Bytes.class), new Column(Messages.BigDropsQuery_Column_NumChildren, Long.class), new Column(Messages.BigDropsQuery_Column_Dominator), new Column(Messages.BigDropsQuery_Column_DomRetainedSize, Bytes.class)};
    }

    public List<?> getChildren(Object parent) {
        return ((BigDropEntry)parent).children;
    }

    public Object getColumnValue(Object row, int columnIndex) {
        BigDropEntry element = (BigDropEntry)row;
        switch (columnIndex) {
            case 0: {
                return element.objectLabel;
            }
            case 1: {
                return element.objectRetainedSize;
            }
            case 2: {
                return element.numberOfChildren;
            }
            case 3: {
                return element.dominatorLabel;
            }
            case 4: {
                return element.dominatorRetainedSize;
            }
        }
        return null;
    }

    public List<?> getElements() {
        return this.rootEntry.children;
    }

    public boolean hasChildren(Object parent) {
        return ((BigDropEntry)parent).children.size() > 0;
    }

    public IContextObject getContext(final Object row) {
        return new IContextObject(){

            public int getObjectId() {
                return ((BigDropEntry)row).objectId;
            }
        };
    }

    public ContextProvider[] getContextProviders() {
        return new ContextProvider[]{new ContextProvider(Messages.BigDropsQuery_AccumulationPoint){

            public IContextObject getContext(Object row) {
                return BigDropsQuery.this.getAccumulationPoint(row);
            }
        }, new ContextProvider(Messages.BigDropsQuery_Dominator){

            public IContextObject getContext(Object row) {
                return BigDropsQuery.this.getDominator(row);
            }
        }};
    }

    IContextObject getAccumulationPoint(final Object row) {
        return new IContextObject(){

            public int getObjectId() {
                return ((BigDropEntry)row).objectId;
            }
        };
    }

    IContextObject getDominator(final Object row) {
        return new IContextObject(){

            public int getObjectId() {
                return ((BigDropEntry)row).dominatorId;
            }
        };
    }

    public static class BigDropEntry {
        int objectId;
        String objectLabel;
        Bytes objectRetainedSize;
        int numberOfChildren;
        int dominatorId;
        String dominatorLabel;
        Bytes dominatorRetainedSize;
        List<BigDropEntry> children = new ArrayList<BigDropEntry>(1);

        public BigDropEntry(int objectId, String objectLabel, long objectRetainedSize, int numberOfChildren, int dominatorId, String dominatorLabel, long dominatorRetainedSize) {
            this.objectId = objectId;
            this.objectLabel = objectLabel;
            this.objectRetainedSize = new Bytes(objectRetainedSize);
            this.numberOfChildren = numberOfChildren;
            this.dominatorId = dominatorId;
            this.dominatorLabel = dominatorLabel;
            this.dominatorRetainedSize = new Bytes(dominatorRetainedSize);
        }
    }

    private static class StackEntry {
        int parentId;
        int[] children;
        int nextChild;
        long parentSize;

        public StackEntry(int parentId, long parentSize, int[] children, int nextChild) {
            this.parentId = parentId;
            this.parentSize = parentSize;
            this.children = children;
            this.nextChild = nextChild;
        }
    }
}

