/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.common.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.m2m.internal.qvt.oml.common.io.CFile;
import org.eclipse.m2m.internal.qvt.oml.common.io.IOResource;

public class IOFile
extends IOResource
implements CFile {
    private String myUnitName;

    public IOFile(String file) {
        this(new File(file));
    }

    public IOFile(File file) {
        super(file);
        if (file.exists() && !file.isFile()) {
            throw new IllegalArgumentException("Not a file: " + file);
        }
        this.myUnitName = this.myFile.getName();
        int dot = this.myUnitName.lastIndexOf(46);
        if (dot != -1) {
            this.myUnitName = this.myUnitName.substring(0, dot);
        }
    }

    public boolean equals(Object other) {
        return other instanceof IOFile && ((IOFile)other).myFile.equals(this.myFile);
    }

    public int hashCode() {
        return this.myFile.hashCode();
    }

    public InputStream getContents() throws IOException {
        return new FileInputStream(this.myFile);
    }

    public String getUnitName() {
        return this.myUnitName;
    }

    public String getCharset() throws IOException {
        return IOFile.getWorkspaceCharset();
    }
}

