/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ldt.ui.internal.properties;

import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.dltk.core.SourceParserUtil;
import org.eclipse.dltk.internal.ui.util.CoreUtility;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ldt.core.internal.LuaLanguageToolkit;
import org.eclipse.ldt.core.internal.grammar.LuaGrammarManager;
import org.eclipse.ldt.ui.internal.grammar.GrammarContentProvider;
import org.eclipse.ldt.ui.internal.properties.Messages;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class GrammarPropertyPage
extends PropertyPage
implements IWorkbenchPropertyPage {
    private ComboViewer availableGrammarComboViewer;
    private IProject project;

    private void initialize() {
        this.project = (IProject)this.getElement().getAdapter(IResource.class);
        this.noDefaultAndApplyButton();
        this.setDescription(Messages.GrammarPropertyPage_page_description);
        if (this.project != null) {
            this.setPreferenceStore((IPreferenceStore)new ScopedPreferenceStore((IScopeContext)new ProjectScope(this.project), LuaLanguageToolkit.getDefault().getPreferenceQualifier()));
        }
    }

    protected Control createContents(Composite parent) {
        this.initialize();
        Composite containerComposite = new Composite(parent, 0);
        GridLayoutFactory.swtDefaults().margins(0, 0).numColumns(1).applyTo(containerComposite);
        this.createDescriptionLabel(containerComposite);
        this.availableGrammarComboViewer = new ComboViewer(containerComposite, 2056);
        this.availableGrammarComboViewer.setContentProvider((IContentProvider)new GrammarContentProvider());
        GridDataFactory.swtDefaults().align(1, 1).grab(true, false).applyTo(this.availableGrammarComboViewer.getControl());
        this.initializePage();
        return containerComposite;
    }

    private void initializePage() {
        if (this.availableGrammarComboViewer == null || this.availableGrammarComboViewer.getControl().isDisposed() || this.getPreferenceStore() == null) {
            return;
        }
        List availableGrammars = LuaGrammarManager.getAvailableGrammars();
        this.availableGrammarComboViewer.setInput((Object)availableGrammars);
        String defaultGrammar = this.getPreferenceStore().getString("Grammar__default_id");
        this.availableGrammarComboViewer.setSelection((ISelection)new StructuredSelection((Object)defaultGrammar));
    }

    public String getSelectedGrammar() {
        Object firstElement;
        ISelection selection = this.availableGrammarComboViewer.getSelection();
        if (selection instanceof IStructuredSelection && (firstElement = ((IStructuredSelection)selection).getFirstElement()) instanceof String) {
            return (String)firstElement;
        }
        return null;
    }

    public boolean performOk() {
        String oldGrammar = this.getPreferenceStore().getString("Grammar__default_id");
        String newGrammar = this.getSelectedGrammar();
        this.getPreferenceStore().setValue("Grammar__default_id", newGrammar);
        IWorkbenchPreferenceContainer container = null;
        if (this.getContainer() instanceof IWorkbenchPreferenceContainer) {
            container = (IWorkbenchPreferenceContainer)this.getContainer();
        }
        boolean needsBuild = oldGrammar != null && !oldGrammar.equals(newGrammar) && container != null;
        boolean doBuild = false;
        if (needsBuild) {
            MessageDialog dialog = new MessageDialog(this.getShell(), Messages.GrammarPropertyPage_rebuild_dialog_title, null, Messages.GrammarPropertyPage_rebuild_dialog_message, 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL}, 2);
            int res = dialog.open();
            if (res == 0) {
                doBuild = true;
            } else if (res != 1) {
                return false;
            }
        }
        if (doBuild) {
            Job job = CoreUtility.getBuildJob((IProject)this.project);
            SourceParserUtil.clearCache();
            container.registerUpdateJob(job);
        }
        return super.performOk();
    }
}

