/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.we_view_editor.wizards;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jwt.we.misc.views.ViewEcoreManager;
import org.eclipse.jwt.we_view_editor.PluginProperties;
import org.eclipse.jwt.we_view_editor.wizards.NewViewWizardPage;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public class NewViewWizard
extends Wizard
implements INewWizard {
    private NewViewWizardPage page;
    private ISelection selection;

    public NewViewWizard() {
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.page = new NewViewWizardPage(this.selection);
        this.addPage((IWizardPage)this.page);
    }

    public boolean performFinish() {
        final String containerName = this.page.getContainerName();
        final String fileName = this.page.getFileName();
        ViewEcoreManager.getInstance().setName(this.page.getViewnameText());
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    try {
                        NewViewWizard.this.doFinish(containerName, fileName, monitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            this.getContainer().run(true, false, op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable realException = e.getTargetException();
            MessageDialog.openError((Shell)this.getShell(), (String)PluginProperties.newWizard_error, (String)realException.getMessage());
            return false;
        }
        return true;
    }

    private void doFinish(String containerName, String fileName, IProgressMonitor monitor) throws CoreException {
        File file;
        monitor.beginTask(String.valueOf(PluginProperties.newWizard_creating) + fileName, 2);
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        if (!containerName.equals("")) {
            IResource resource = root.findMember((IPath)new Path(containerName));
            if (!resource.exists() || !(resource instanceof IContainer)) {
                this.throwCoreException(String.valueOf(PluginProperties.newWizard_projectDoesntExist_part1) + "\"" + "\"" + PluginProperties.newWizard_projectDoesntExist_part2);
            }
            IContainer container = (IContainer)resource;
            file = container.getFile((IPath)new Path(fileName));
        } else {
            file = new File(URI.createFileURI((String)fileName).toFileString());
        }
        monitor.worked(1);
        monitor.setTaskName(PluginProperties.newWizard_openFileForEditing);
        this.getShell().getDisplay().asyncExec(new Runnable(){

            public void run() {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                if (file instanceof IFile) {
                    try {
                        IDE.openEditor((IWorkbenchPage)page, (IFile)((IFile)file), (boolean)true);
                    }
                    catch (PartInitException partInitException) {}
                } else {
                    URI fileUri = URI.createFileURI((String)((File)file).getAbsolutePath());
                    IEditorDescriptor editorDescriptor = null;
                    try {
                        editorDescriptor = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(fileUri.toString());
                        if (editorDescriptor == null) {
                            return;
                        }
                        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)new URIEditorInput(fileUri), editorDescriptor.getId());
                    }
                    catch (Exception exception) {
                        return;
                    }
                }
            }
        });
        monitor.worked(1);
    }

    private void throwCoreException(String message) throws CoreException {
        Status status = new Status(4, "org.eclipse.jwt.we_view_editor", 0, message, null);
        throw new CoreException((IStatus)status);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
    }
}

