/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.we.commands.scope;

import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jwt.meta.commands.interfaces.IInterruptibleCommand;
import org.eclipse.jwt.meta.model.processes.Activity;
import org.eclipse.jwt.meta.model.processes.ActivityLinkNode;
import org.eclipse.jwt.meta.model.processes.ProcessesPackage;
import org.eclipse.jwt.meta.model.processes.Scope;
import org.eclipse.jwt.we.PluginProperties;
import org.eclipse.jwt.we.commands.gefEmfAdapter.EmfToGefCommandAdapter;
import org.eclipse.jwt.we.commands.scope.InsertScopeCopyCommand;
import org.eclipse.jwt.we.editors.WEEditor;
import org.eclipse.jwt.we.editors.preferences.PreferenceReader;
import org.eclipse.jwt.we.misc.factories.EcoreFactory;
import org.eclipse.jwt.we.misc.util.GeneralHelper;
import org.eclipse.jwt.we.parts.processes.ScopeEditPart;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;

public class InsertScopeCommand
extends Command
implements IInterruptibleCommand {
    private WEEditor weeditor;
    private EditingDomain editingDomain;
    private CreateRequest request;
    private Scope mainScope;
    private Point insertPoint;
    private CompoundCommand insertCommand;
    private Object select;
    private int result;

    public InsertScopeCommand(WEEditor weeditor, EditingDomain editingDomain, CreateRequest request, Scope scope, Point insertPoint) {
        super(PluginProperties.insertActivity);
        this.editingDomain = editingDomain;
        this.mainScope = scope;
        this.request = request;
        this.weeditor = weeditor;
        this.insertPoint = insertPoint;
        if (insertPoint == null) {
            insertPoint = new Point(0, 0);
        }
    }

    private void selectAddedObject() {
        if (this.select == null) {
            return;
        }
        this.getViewer().getControl().forceFocus();
        Object editpart = this.getViewer().getEditPartRegistry().get(this.select);
        if (editpart instanceof EditPart) {
            this.getViewer().flush();
            this.getViewer().select((EditPart)editpart);
        }
    }

    private EditPartViewer getViewer() {
        return this.weeditor.getCurrentActivitySheet().getGraphicalViewer();
    }

    public boolean checkIfCommandCanBeExecuted() {
        Shell shell = GeneralHelper.getActiveShell();
        String mainScopeName = org.eclipse.jwt.meta.PluginProperties.model_Unnamed_name;
        String insertScopeName = org.eclipse.jwt.meta.PluginProperties.model_Unnamed_name;
        try {
            mainScopeName = ((Activity)this.mainScope).getName() != null ? ((Activity)this.mainScope).getName() : "<>";
            insertScopeName = ((Activity)this.request.getNewObject()).getName() != null ? ((Activity)this.request.getNewObject()).getName() : "<>";
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        String title = PluginProperties.editor_DropActivity_Title;
        String question = NLS.bind((String)PluginProperties.editor_DropActivity_Question, (Object)mainScopeName, (Object)insertScopeName);
        String[] buttons = new String[]{PluginProperties.editor_DropActivity_Copy, PluginProperties.editor_DropActivity_SAN, PluginProperties.editor_DropActivity_LAN, PluginProperties.editor_Cancel_message};
        MessageDialog md = new MessageDialog(shell, title, null, question, 3, buttons, 0);
        md.setBlockOnOpen(true);
        this.result = md.open();
        return this.result != 3;
    }

    public boolean canExecute() {
        return this.editingDomain != null && this.mainScope != null && this.request.getNewObjectType() instanceof Class && Scope.class.isAssignableFrom((Class)this.request.getNewObjectType());
    }

    public void execute() {
        this.select = this.mainScope;
        this.insertCommand = new CompoundCommand();
        switch (this.result) {
            case 0: {
                InsertScopeCopyCommand scopeCopy = new InsertScopeCopyCommand(this.weeditor, this.editingDomain, this.request, this.mainScope, this.insertPoint);
                scopeCopy.prepareCopy();
                this.insertCommand.add((Command)scopeCopy);
                break;
            }
            case 1: {
                try {
                    CreateRequest cr = new CreateRequest();
                    cr.setType((Object)"create child");
                    cr.setLocation(this.insertPoint);
                    cr.setFactory((CreationFactory)new EcoreFactory(ProcessesPackage.Literals.STRUCTURED_ACTIVITY_NODE));
                    InsertScopeCopyCommand scopeCopy = new InsertScopeCopyCommand(this.weeditor, this.editingDomain, this.request, (Scope)cr.getNewObject(), new Point(0, 0));
                    scopeCopy.prepareCopy();
                    cr.setSize(new Dimension(scopeCopy.getMaxPoint().x - scopeCopy.getMinPoint().x + 70, scopeCopy.getMaxPoint().y - scopeCopy.getMinPoint().y + 70));
                    this.insertCommand.add(((ScopeEditPart)this.getViewer().getEditPartRegistry().get(this.mainScope)).getCommand((Request)cr));
                    this.insertCommand.add((Command)scopeCopy);
                    this.select = cr.getNewObject();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                break;
            }
            case 2: {
                CreateRequest cr = new CreateRequest();
                cr.setType((Object)"create child");
                cr.setLocation(this.insertPoint);
                cr.setSize(PreferenceReader.appearanceFigureIconSize.get());
                cr.setFactory((CreationFactory)new EcoreFactory(ProcessesPackage.Literals.ACTIVITY_LINK_NODE));
                try {
                    this.insertCommand.add(((ScopeEditPart)this.getViewer().getEditPartRegistry().get(this.mainScope)).getCommand((Request)cr));
                    this.insertCommand.add((Command)new EmfToGefCommandAdapter(SetCommand.create((EditingDomain)this.editingDomain, (Object)cr.getNewObject(), (Object)ProcessesPackage.Literals.ACTIVITY_LINK_NODE__LINKSTO, (Object)this.request.getNewObject())));
                    ((ActivityLinkNode)cr.getNewObject()).setName(((Activity)this.request.getNewObject()).getName());
                    this.select = cr.getNewObject();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                break;
            }
        }
        if (this.insertCommand.getCommands().size() != 0 && this.insertCommand.canExecute()) {
            this.insertCommand.execute();
            this.selectAddedObject();
        }
    }

    public void redo() {
        if (this.insertCommand.getCommands().size() != 0 && this.insertCommand.canExecute()) {
            this.insertCommand.redo();
        }
        this.selectAddedObject();
    }

    public void undo() {
        if (this.insertCommand.getCommands().size() != 0 && this.insertCommand.canUndo()) {
            this.insertCommand.undo();
        }
    }
}

