/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.we.conf.edit.ui;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jwt.we.conf.edit.provider.ConfItemProviderAdapterFactory;
import org.eclipse.jwt.we.conf.edit.ui.internal.Messages;
import org.eclipse.jwt.we.conf.edit.ui.internal.StatusDialog;
import org.eclipse.jwt.we.conf.edit.ui.internal.UIUtils;
import org.eclipse.jwt.we.conf.edit.ui.provider.AdapterFactoryColumnLabelProvider;
import org.eclipse.jwt.we.conf.edit.ui.provider.AdapterFactoryContentProviderWithList;
import org.eclipse.jwt.we.conf.edit.ui.provider.MissingProfileLabelProvider;
import org.eclipse.jwt.we.conf.edit.ui.viewer.ClassViewFilter;
import org.eclipse.jwt.we.conf.model.AspectInstance;
import org.eclipse.jwt.we.conf.model.ConfModel;
import org.eclipse.jwt.we.conf.model.Profile;
import org.eclipse.jwt.we.conf.model.aspects.AspectManager;
import org.eclipse.jwt.we.conf.model.aspects.ConfRegistry;
import org.eclipse.jwt.we.conf.model.resource.ConfModelResourceManager;
import org.eclipse.jwt.we.conf.model.resource.ConfModelStatus;
import org.eclipse.jwt.we.conf.model.resource.ConfResourceException;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManageActivatedProfilesUI {
    private static final List<Profile> EMPTY_PROFILE_LIST = new ArrayList<Profile>(0);
    private AdapterFactory adapterFactory;
    private String importFilePath = null;
    private EObject selectedModel = null;
    private ConfModelStatus selectedModelStatus = null;
    private int checkMissingProfilesStatus;
    private String checkMissingProfilesTitleText;
    private String checkMissingProfilesInfoText;
    private Label warningMissingProfilesLabel;
    private Label adviceProfilesLabel;
    private Button showStatusDetailsButton;
    private Text exportTargetFileText;
    private Button chooseExportTargetFileButton;
    private Button exportToFileButton;
    private Combo usingEmbeddedProfilesCombo;
    private TreeViewer missingProfilesTreeViewer;
    private TreeViewer installedProfilesTreeViewer;
    private TreeViewer embeddedProfilesTreeViewer;
    private StackLayout enableProfileStackLayout;
    private Group enableProfileGroup;
    private Composite profileUiComposite;
    private Composite stackComposite;
    private Label enableProfileLabel;
    private Action activateInstalledProfileAction = null;
    private Action disableEmbeddedProfileAction = null;

    public ManageActivatedProfilesUI(AdapterFactory adapterFactory) {
        this.adapterFactory = adapterFactory != null ? adapterFactory : new ConfItemProviderAdapterFactory();
    }

    public EObject getSelectedModel() {
        return this.selectedModel;
    }

    public void setSelectedModel(EObject selectedModel) {
        URI selectedModelUri;
        Resource selectedModelResource;
        this.selectedModel = selectedModel;
        this.importFilePath = "";
        if (selectedModel != null && (selectedModelResource = selectedModel.eResource()) != null && (selectedModelUri = selectedModelResource.getURI()) != null) {
            String modelFileName = selectedModelUri.lastSegment();
            String confFileName = modelFileName.substring(0, modelFileName.lastIndexOf(46));
            this.importFilePath = "conf/imported/" + confFileName + ".conf";
        }
    }

    protected List<Profile> getMissingProfiles() {
        if (this.selectedModel == null) {
            return EMPTY_PROFILE_LIST;
        }
        List missingProfiles = AspectManager.INSTANCE.getMissingInstalledProfiles(this.selectedModel);
        return missingProfiles;
    }

    protected boolean useEmbeddedConf() {
        ConfModel selectedConfModel = this.getSelectedModelConfModel();
        return selectedConfModel == null ? false : selectedConfModel.getUseEmbeddedConf();
    }

    protected ConfModel getSelectedModelConfModel() {
        return this.selectedModel == null ? null : AspectManager.INSTANCE.getConfModel(this.selectedModel);
    }

    private boolean importToFileHasAllRequiredInfo() {
        if (this.importFilePath != null) {
            File importToFile = new File(this.importFilePath);
            return importToFile.canRead() && importToFile.isFile() || !importToFile.exists() && importToFile.getParentFile() != null && importToFile.getParentFile().exists();
        }
        return false;
    }

    public void dispose() {
    }

    public void refresh() {
        if (this.selectedModel == null) {
            if (this.enableProfileStackLayout.topControl != this.enableProfileLabel) {
                this.enableProfileStackLayout.topControl = this.enableProfileLabel;
                this.stackComposite.layout();
            }
            return;
        }
        this.selectedModelStatus = new ConfModelStatus();
        this.selectedModelStatus.setBypassFlaggedUnavailable(true);
        ConfModel mySelectedModelConfModel = AspectManager.INSTANCE.getConfModel(this.selectedModel, this.selectedModelStatus);
        if (this.selectedModelStatus.getSeverity() == 4) {
            IStatus resourceDoesNotExistErrorStatus = null;
            IStatus patchableMissingEmfErrorStatus = null;
            IStatus[] iStatusArray = this.selectedModelStatus.getChildren();
            int n = iStatusArray.length;
            int n2 = 0;
            while (n2 < n) {
                IStatus childStatus = iStatusArray[n2];
                if (childStatus.getCode() == 401) {
                    resourceDoesNotExistErrorStatus = childStatus;
                    break;
                }
                if (childStatus.getCode() == 402) {
                    patchableMissingEmfErrorStatus = childStatus;
                    break;
                }
                ++n2;
            }
            if (resourceDoesNotExistErrorStatus == null) {
                if (patchableMissingEmfErrorStatus != null) {
                    String msg = patchableMissingEmfErrorStatus.getException() == null ? patchableMissingEmfErrorStatus.getMessage() : patchableMissingEmfErrorStatus.getException().getMessage();
                    int tryPatchingMissingEmfError = ErrorDialog.openError((Shell)this.stackComposite.getShell(), (String)Messages.confirmTryPatching_title, (String)Messages.bind((String)Messages.confirmTryPatching_body, (Object)msg), (IStatus)this.selectedModelStatus);
                    if (tryPatchingMissingEmfError == 0) {
                        this.selectedModelStatus = new ConfModelStatus();
                        this.selectedModelStatus.setTryPatchingMissingEmf(true);
                        this.selectedModelStatus.setBypassFlaggedUnavailable(true);
                        mySelectedModelConfModel = AspectManager.INSTANCE.getConfModel(this.selectedModel, this.selectedModelStatus);
                        if (this.selectedModelStatus.getSeverity() == 4) {
                            String retryMsg = this.selectedModelStatus.getException() == null ? this.selectedModelStatus.getMessage() : this.selectedModelStatus.getException().getMessage();
                            ErrorDialog.openError((Shell)this.stackComposite.getShell(), (String)Messages.errorPatching_title, (String)Messages.bind((String)Messages.errorPatching_body, (Object)retryMsg), (IStatus)this.selectedModelStatus);
                        } else {
                            MessageDialog.openInformation((Shell)this.stackComposite.getShell(), (String)Messages.successfullyPatched_title, (String)Messages.successfullyPatched_body);
                        }
                    } else {
                        ErrorDialog.openError((Shell)this.stackComposite.getShell(), (String)Messages.noPatchApplied_title, (String)Messages.noPatchApplied_body, (IStatus)this.selectedModelStatus);
                    }
                } else {
                    ErrorDialog.openError((Shell)this.stackComposite.getShell(), (String)Messages.errorLoadingConfModel_title, (String)Messages.errorLoadingConfModel_body, (IStatus)this.selectedModelStatus);
                }
            }
        }
        if (mySelectedModelConfModel != null) {
            if (this.enableProfileStackLayout.topControl != this.profileUiComposite) {
                this.enableProfileStackLayout.topControl = this.profileUiComposite;
            }
            this.updateWarnings();
            this.updateImportToFile();
            this.updateAvailableProfiles();
            this.stackComposite.layout();
        } else if (this.enableProfileStackLayout.topControl != this.enableProfileGroup) {
            this.enableProfileStackLayout.topControl = this.enableProfileGroup;
            this.stackComposite.layout();
        }
    }

    protected void updateWarnings() {
        this.checkMissingProfilesTitleText = "";
        this.checkMissingProfilesInfoText = "";
        this.checkMissingProfilesStatus = 0;
        if (this.getMissingProfiles().isEmpty()) {
            this.checkMissingProfilesTitleText = Messages.noMissingProfilesTitle;
            if (this.useEmbeddedConf()) {
                this.checkMissingProfilesInfoText = Messages.advertUseEmbeddedProfiles;
            }
        } else if (this.useEmbeddedConf()) {
            this.checkMissingProfilesTitleText = Messages.missingProfilesWarningTitle;
            this.checkMissingProfilesStatus = 2;
            this.checkMissingProfilesInfoText = Messages.missingProfilesEmbeddedConfText;
        } else {
            this.checkMissingProfilesTitleText = Messages.missingProfilesWarningTitle;
            this.checkMissingProfilesStatus = 4;
            this.checkMissingProfilesInfoText = Messages.missingProfilesNotEmbeddedConfText;
        }
        this.warningMissingProfilesLabel.setText(this.checkMissingProfilesTitleText);
        this.adviceProfilesLabel.setText(this.checkMissingProfilesInfoText);
        switch (this.checkMissingProfilesStatus) {
            case 2: {
                this.addFontStyle((Control)this.warningMissingProfilesLabel, 1);
                break;
            }
            case 4: {
                this.addFontStyle((Control)this.warningMissingProfilesLabel, 1);
                break;
            }
            default: {
                this.removeFontStyle((Control)this.warningMissingProfilesLabel, 1);
            }
        }
    }

    private void updateImportToFile() {
        this.importFilePath = this.importFilePath == null ? "" : this.importFilePath;
        this.exportTargetFileText.setText(this.importFilePath);
        this.exportToFileButton.setEnabled(this.importToFileHasAllRequiredInfo());
        this.chooseExportTargetFileButton.setEnabled(!this.getMissingProfiles().isEmpty());
        this.exportToFileButton.setEnabled(!this.getMissingProfiles().isEmpty() && this.importToFileHasAllRequiredInfo());
        this.usingEmbeddedProfilesCombo.setText("" + this.useEmbeddedConf());
    }

    private void updateAvailableProfiles() {
        this.usingEmbeddedProfilesCombo.setText("" + this.useEmbeddedConf());
        this.missingProfilesTreeViewer.setInput(this.getMissingProfiles());
        this.installedProfilesTreeViewer.setInput((Object)ConfRegistry.INSTANCE.getInstalledProfiles());
        this.embeddedProfilesTreeViewer.setInput((Object)this.getSelectedModelConfModel());
    }

    public Composite createControl(Composite parent, CommandStack commandStack) {
        this.enableProfileStackLayout = new StackLayout();
        this.stackComposite = new Composite(parent, 0);
        this.stackComposite.setLayout((Layout)this.enableProfileStackLayout);
        this.enableProfileLabel = new Label(this.stackComposite, 0);
        this.enableProfileLabel.setText(Messages.noWorkflowModelSelected);
        this.enableProfileGroup = new Group(this.stackComposite, 0);
        this.enableProfileGroup.setText(Messages.enableProfile);
        this.enableProfileGroup.setLayout((Layout)new GridLayout(1, false));
        Label enableProfileLabel = new Label((Composite)this.enableProfileGroup, 0);
        enableProfileLabel.setText(Messages.profileDisabled);
        Button enableProfileButton = new Button((Composite)this.enableProfileGroup, 131072);
        enableProfileButton.setText(Messages.enable);
        this.profileUiComposite = new Composite(this.stackComposite, 0);
        this.profileUiComposite.setLayout((Layout)new GridLayout(1, false));
        Group warningGroup = new Group(this.profileUiComposite, 0);
        warningGroup.setText(Messages.warningAndAdvice);
        GridLayout gL = new GridLayout(2, false);
        gL.makeColumnsEqualWidth = true;
        warningGroup.setLayout((Layout)gL);
        warningGroup.setLayoutData((Object)new GridData(1808));
        this.warningMissingProfilesLabel = new Label((Composite)warningGroup, 0);
        Label missingProfilesLabel = new Label((Composite)warningGroup, 0);
        missingProfilesLabel.setLayoutData((Object)new GridData(2));
        missingProfilesLabel.setText(Messages.missingProfiles);
        this.adviceProfilesLabel = new Label((Composite)warningGroup, 0);
        this.missingProfilesTreeViewer = this.createProfileTreeViewer((Composite)warningGroup, null);
        GridData gD = new GridData(1808);
        gD.minimumHeight = 100;
        gD.verticalSpan = 2;
        this.missingProfilesTreeViewer.getTree().setLayoutData((Object)gD);
        this.missingProfilesTreeViewer.getTree().setHeaderVisible(true);
        this.missingProfilesTreeViewer.getTree().setLinesVisible(true);
        this.showStatusDetailsButton = new Button((Composite)warningGroup, 0);
        this.showStatusDetailsButton.setText(Messages.showStatusDetails_button);
        Group availableProfilesGroup = new Group(this.profileUiComposite, 0);
        availableProfilesGroup.setText(Messages.detailAvailableProfiles);
        availableProfilesGroup.setLayout((Layout)new GridLayout(1, false));
        availableProfilesGroup.setLayoutData((Object)new GridData(1808));
        Label installedProfilesLabel = new Label((Composite)availableProfilesGroup, 0);
        installedProfilesLabel.setLayoutData((Object)new GridData(2));
        installedProfilesLabel.setText(Messages.installedProfiles);
        this.addFontStyle((Control)installedProfilesLabel, 1);
        this.installedProfilesTreeViewer = this.createProfileTreeViewer((Composite)availableProfilesGroup, null);
        GridData treeLayoutData = new GridData(1808);
        treeLayoutData.minimumHeight = 150;
        this.installedProfilesTreeViewer.getTree().setLayoutData((Object)treeLayoutData);
        this.installedProfilesTreeViewer.getTree().setHeaderVisible(true);
        this.installedProfilesTreeViewer.getTree().setLinesVisible(true);
        Label embeddedProfilesLabel = new Label((Composite)availableProfilesGroup, 0);
        embeddedProfilesLabel.setLayoutData((Object)new GridData(2));
        embeddedProfilesLabel.setText(Messages.embeddedProfiles);
        this.addFontStyle((Control)embeddedProfilesLabel, 1);
        this.embeddedProfilesTreeViewer = this.createProfileTreeViewer((Composite)availableProfilesGroup, (IBaseLabelProvider)new MissingProfileLabelProvider(this.adapterFactory, (Map<Integer, String>)new HashMap<Integer, String>(){
            {
                this.put(1, Messages.version);
                this.put(2, Messages.description);
            }
        }));
        GridData embeddedProfilesTreeViewerLayoutData = new GridData(1808);
        embeddedProfilesTreeViewerLayoutData.minimumHeight = 150;
        this.embeddedProfilesTreeViewer.getTree().setLayoutData((Object)embeddedProfilesTreeViewerLayoutData);
        this.embeddedProfilesTreeViewer.getTree().setHeaderVisible(true);
        this.embeddedProfilesTreeViewer.getTree().setLinesVisible(true);
        Group exportMissingProfileGroup = new Group(this.profileUiComposite, 0);
        exportMissingProfileGroup.setText(Messages.exportMissingProfiles);
        exportMissingProfileGroup.setLayout((Layout)new GridLayout(3, false));
        exportMissingProfileGroup.setLayoutData((Object)new GridData(1808));
        this.chooseExportTargetFileButton = new Button((Composite)exportMissingProfileGroup, 0);
        this.chooseExportTargetFileButton.setText(Messages.choose);
        this.exportTargetFileText = new Text((Composite)exportMissingProfileGroup, 2052);
        this.exportTargetFileText.setLayoutData((Object)new GridData(768));
        this.exportTargetFileText.setEnabled(false);
        this.exportToFileButton = new Button((Composite)exportMissingProfileGroup, 0);
        this.exportToFileButton.setText(Messages.exportToConfFile);
        Group developmentToolsGroup = new Group(this.profileUiComposite, 0);
        developmentToolsGroup.setText(Messages.developmentTools);
        developmentToolsGroup.setLayout((Layout)new GridLayout(4, false));
        developmentToolsGroup.setLayoutData((Object)new GridData(1808));
        Label usingEmbeddedProfilesLabel = new Label((Composite)developmentToolsGroup, 0);
        usingEmbeddedProfilesLabel.setText(Messages.usingEmbeddedProfiles);
        this.usingEmbeddedProfilesCombo = new Combo((Composite)developmentToolsGroup, 4);
        this.usingEmbeddedProfilesCombo.setItems(new String[]{"true", "false"});
        this.usingEmbeddedProfilesCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                boolean oldUseEmbeddedConf;
                boolean newUseEmbeddedConf = Boolean.valueOf(ManageActivatedProfilesUI.this.usingEmbeddedProfilesCombo.getText());
                if (newUseEmbeddedConf != (oldUseEmbeddedConf = ManageActivatedProfilesUI.this.useEmbeddedConf())) {
                    ManageActivatedProfilesUI.this.getSelectedModelConfModel().setUseEmbeddedConf(Boolean.valueOf(newUseEmbeddedConf));
                    ManageActivatedProfilesUI.this.refresh();
                }
            }
        });
        Button disableProfileButton = new Button((Composite)developmentToolsGroup, 131072);
        disableProfileButton.setText(Messages.disableProfiles);
        this.showStatusDetailsButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                String msg = Messages.bind((String)Messages.statusDetails_body, (Object[])new Object[]{ManageActivatedProfilesUI.this.selectedModel.eResource().getURI(), ManageActivatedProfilesUI.this.selectedModelStatus.getSeverity() == 0 || ManageActivatedProfilesUI.this.selectedModelStatus.getSeverity() == 1 ? "OK" : (ManageActivatedProfilesUI.this.selectedModelStatus.getSeverity() == 2 ? "WARNING" : "ERROR")});
                msg = String.valueOf(msg) + "\n" + (ManageActivatedProfilesUI.this.selectedModelStatus.getChildren() == null || ManageActivatedProfilesUI.this.selectedModelStatus.getChildren().length == 0 ? Messages.statusDetails_body_nodetails : Messages.statusDetails_body_details);
                StatusDialog.openStatus(ManageActivatedProfilesUI.this.stackComposite.getShell(), Messages.statusDetails_title, msg, (IStatus)ManageActivatedProfilesUI.this.selectedModelStatus);
            }
        });
        this.chooseExportTargetFileButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                FileDialog dialog = new FileDialog(ManageActivatedProfilesUI.this.stackComposite.getShell(), 4096);
                dialog.setFileName(ManageActivatedProfilesUI.this.importFilePath);
                dialog.setFilterExtensions(new String[]{"*.conf", "*.*"});
                ManageActivatedProfilesUI.this.importFilePath = dialog.open();
                ManageActivatedProfilesUI.this.refresh();
            }
        });
        this.exportToFileButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                try {
                    File importFile = new File(ManageActivatedProfilesUI.this.importFilePath);
                    ConfModel exportConfModel = ConfModelResourceManager.INSTANCE.exportProfilesToFile(ManageActivatedProfilesUI.this.getMissingProfiles(), importFile);
                    ConfRegistry.INSTANCE.addDiscoveredConf(exportConfModel);
                    ConfModel confModel = ManageActivatedProfilesUI.this.getSelectedModelConfModel();
                    if (confModel.getUseEmbeddedConf().booleanValue()) {
                        confModel.setUseEmbeddedConf(Boolean.valueOf(false));
                    }
                    MessageDialog.openInformation((Shell)ManageActivatedProfilesUI.this.stackComposite.getShell(), (String)Messages.Success, (String)Messages.bind((String)Messages.importSuccess, (Object)ManageActivatedProfilesUI.this.exportToFileButton));
                }
                catch (Exception e) {
                    ErrorDialog.openError((Shell)ManageActivatedProfilesUI.this.stackComposite.getShell(), (String)Messages.importError, (String)e.getMessage(), (IStatus)new Status(4, "org.eclipse.jwt.we.conf.model.edit", 0, e.getMessage(), (Throwable)e));
                }
                ManageActivatedProfilesUI.this.refresh();
            }
        });
        enableProfileButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                if (ManageActivatedProfilesUI.this.selectedModel == null) {
                    return;
                }
                try {
                    ConfModel newlyLoadedConfModel = ConfModelResourceManager.INSTANCE.loadConfModelOfModel(ManageActivatedProfilesUI.this.selectedModel, true);
                    if (newlyLoadedConfModel == null) {
                        String msg = Messages.enablementError;
                        ErrorDialog.openError((Shell)ManageActivatedProfilesUI.this.stackComposite.getShell(), (String)Messages.errorCreatingOrReloadingConfModel, (String)msg, (IStatus)new Status(4, "org.eclipse.jwt.we.conf.model.edit", 0, msg, null));
                    }
                }
                catch (ConfResourceException crex) {
                    ErrorDialog.openError((Shell)ManageActivatedProfilesUI.this.stackComposite.getShell(), (String)Messages.enablementError, (String)crex.getMessage(), (IStatus)new Status(4, "org.eclipse.jwt.we.conf.model.edit", 0, crex.getMessage(), (Throwable)crex));
                }
                ManageActivatedProfilesUI.this.refresh();
            }
        });
        disableProfileButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                boolean confirm = MessageDialog.openConfirm((Shell)ManageActivatedProfilesUI.this.stackComposite.getShell(), (String)Messages.confirmConfRemoval_Title, (String)Messages.confirmConfRemoval_Body);
                if (!confirm) {
                    return;
                }
                if (!ConfModelResourceManager.INSTANCE.deleteConfModel(AspectManager.INSTANCE.getConfModel(ManageActivatedProfilesUI.this.selectedModel))) {
                    String msg = Messages.confModelNotDeleted;
                    ErrorDialog.openError((Shell)ManageActivatedProfilesUI.this.stackComposite.getShell(), (String)Messages.errorDisablingProfiles, (String)msg, (IStatus)new Status(4, "org.eclipse.jwt.we.conf.model.edit", 0, msg, null));
                }
                ManageActivatedProfilesUI.this.refresh();
            }
        });
        this.makeActions(commandStack);
        this.hookContextMenu(this.installedProfilesTreeViewer, new Action[]{this.activateInstalledProfileAction});
        this.hookContextMenu(this.embeddedProfilesTreeViewer, new Action[]{this.disableEmbeddedProfileAction});
        return this.stackComposite;
    }

    private void addFontStyle(Control textControl, int swtFontStyle) {
        Font font = textControl.getFont();
        FontData fontData = font.getFontData()[0];
        fontData.setStyle(fontData.getStyle() | swtFontStyle);
        textControl.setFont(new Font(font.getDevice(), fontData));
    }

    private void removeFontStyle(Control textControl, int swtFontStyle) {
        Font font = textControl.getFont();
        FontData fontData = font.getFontData()[0];
        fontData.setStyle(fontData.getStyle() & swtFontStyle);
        textControl.setFont(new Font(font.getDevice(), fontData));
    }

    private TreeViewer createProfileTreeViewer(Composite parentComposite, IBaseLabelProvider optCustomLabelProvider) {
        TreeViewer profilesTreeViewer = new TreeViewer(parentComposite, 2816);
        Tree profilesTree = profilesTreeViewer.getTree();
        TreeColumn column0 = new TreeColumn(profilesTree, 16384);
        column0.setText("");
        column0.setWidth(300);
        TreeColumn column1 = new TreeColumn(profilesTree, 16384);
        column1.setText(Messages.version);
        column1.setWidth(100);
        TreeColumn column2 = new TreeColumn(profilesTree, 16384);
        column2.setText(Messages.description);
        column2.setWidth(300);
        profilesTreeViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProviderWithList(this.adapterFactory));
        profilesTreeViewer.addFilter((ViewerFilter)new ClassViewFilter(AspectInstance.class));
        if (optCustomLabelProvider == null) {
            optCustomLabelProvider = new AdapterFactoryColumnLabelProvider(this.adapterFactory, (Map<Integer, String>)new HashMap<Integer, String>(){
                {
                    this.put(1, Messages.version);
                    this.put(2, Messages.description);
                }
            });
        }
        profilesTreeViewer.setLabelProvider(optCustomLabelProvider);
        return profilesTreeViewer;
    }

    private void hookContextMenu(TreeViewer viewer, final Action[] actions) {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ManageActivatedProfilesUI.this.fillContextMenu(manager, actions);
            }
        });
        Menu menu = menuMgr.createContextMenu(viewer.getControl());
        viewer.getControl().setMenu(menu);
        if (UIUtils.getActiveEditor() != null) {
            UIUtils.getActiveEditor().getSite().registerContextMenu(menuMgr, (ISelectionProvider)viewer);
        }
    }

    private void fillContextMenu(IMenuManager manager, Action[] actions) {
        Action[] actionArray = actions;
        int n = actions.length;
        int n2 = 0;
        while (n2 < n) {
            Action action = actionArray[n2];
            manager.add((IAction)action);
            ++n2;
        }
    }

    private void makeActions(CommandStack commandStack) {
        this.activateInstalledProfileAction = new ManageProfilesAction(this, this.installedProfilesTreeViewer, commandStack){

            protected Command createManageCommand(EObject selectedModel, Profile selectedProfile) {
                return AspectManager.INSTANCE.createActivateProfileCommand(selectedModel, selectedProfile);
            }

            protected CompoundCommand createCompoundCommand() {
                return new CompoundCommand();
            }
        };
        this.activateInstalledProfileAction.setText(Messages.activate);
        this.activateInstalledProfileAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_FORWARD"));
        this.disableEmbeddedProfileAction = new ManageProfilesAction(this, this.embeddedProfilesTreeViewer, commandStack){

            protected Command createManageCommand(EObject selectedModel, Profile selectedProfile) {
                return AspectManager.INSTANCE.createDisableProfileCommand(selectedModel, selectedProfile);
            }

            protected CompoundCommand createCompoundCommand() {
                return new CompoundCommand(){

                    protected boolean prepare() {
                        boolean confirm = MessageDialog.openConfirm((Shell)stackComposite.getShell(), (String)Messages.disableProfiles_Title, (String)Messages.disableProfiles_Body);
                        if (!confirm) {
                            return false;
                        }
                        return super.prepare();
                    }
                };
            }
        };
        this.disableEmbeddedProfileAction.setText(Messages.disable);
        this.disableEmbeddedProfileAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_DELETE"));
    }

    private abstract class ManageProfilesAction
    extends Action {
        private TreeViewer profilesViewer;
        private CommandStack emfCommandStack;

        public ManageProfilesAction(TreeViewer profilesViewer, CommandStack emfCommandStack) {
            this.profilesViewer = profilesViewer;
            this.emfCommandStack = emfCommandStack;
        }

        public void run() {
            ISelection selection = this.profilesViewer.getSelection();
            if (!(selection instanceof IStructuredSelection)) {
                return;
            }
            CompoundCommand subcommands = this.createCompoundCommand();
            for (Object selectedObject : ((IStructuredSelection)selection).toList()) {
                if (!(selectedObject instanceof Profile)) continue;
                Profile selectedProfile = (Profile)selectedObject;
                Command activateSelectedObjectCommand = this.createManageCommand(ManageActivatedProfilesUI.this.getSelectedModel(), selectedProfile);
                subcommands.append(activateSelectedObjectCommand);
            }
            this.emfCommandStack.execute((Command)subcommands);
            ManageActivatedProfilesUI.this.refresh();
        }

        protected abstract Command createManageCommand(EObject var1, Profile var2);

        protected abstract CompoundCommand createCompoundCommand();
    }
}

