/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.provider.selectionprovider;

import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;

public class SelectionProviderIntermediate
implements IPostSelectionProvider {
    private final ListenerList m_selectionListeners = new ListenerList();
    private final ListenerList m_postSelectionListeners = new ListenerList();
    private ISelectionProvider m_delegate;
    private ISelectionChangedListener m_selectionListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            SelectionProviderIntermediate.this.fireSelectionChanged(event.getSelection());
        }
    };
    private ISelectionChangedListener m_postSelectionListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            SelectionProviderIntermediate.this.firePostSelectionChanged(event.getSelection());
        }
    };

    public void setSelectionProviderDelegate(ISelectionProvider newDelegate) {
        if (this.m_delegate == newDelegate) {
            return;
        }
        if (this.m_delegate != null) {
            this.m_delegate.removeSelectionChangedListener(this.m_selectionListener);
            if (this.m_delegate instanceof IPostSelectionProvider) {
                ((IPostSelectionProvider)this.m_delegate).removePostSelectionChangedListener(this.m_postSelectionListener);
            }
        }
        this.m_delegate = newDelegate;
        if (newDelegate != null) {
            newDelegate.addSelectionChangedListener(this.m_selectionListener);
            if (newDelegate instanceof IPostSelectionProvider) {
                ((IPostSelectionProvider)newDelegate).addPostSelectionChangedListener(this.m_postSelectionListener);
            }
            this.fireSelectionChanged(newDelegate.getSelection());
            this.firePostSelectionChanged(newDelegate.getSelection());
        }
    }

    protected void fireSelectionChanged(ISelection selection) {
        this.fireSelectionChanged(this.m_selectionListeners, selection);
    }

    protected void firePostSelectionChanged(ISelection selection) {
        this.fireSelectionChanged(this.m_postSelectionListeners, selection);
    }

    private void fireSelectionChanged(ListenerList list, ISelection selection) {
        SelectionChangedEvent event = new SelectionChangedEvent(this.m_delegate, selection);
        Object[] listeners = list.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ISelectionChangedListener listener = (ISelectionChangedListener)listeners[i];
            listener.selectionChanged(event);
            ++i;
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.m_selectionListeners.add((Object)listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.m_selectionListeners.remove((Object)listener);
    }

    public void addPostSelectionChangedListener(ISelectionChangedListener listener) {
        this.m_postSelectionListeners.add((Object)listener);
    }

    public void removePostSelectionChangedListener(ISelectionChangedListener listener) {
        this.m_postSelectionListeners.remove((Object)listener);
    }

    public ISelection getSelection() {
        return this.m_delegate == null ? null : this.m_delegate.getSelection();
    }

    public void setSelection(ISelection selection) {
        if (this.m_delegate != null) {
            this.m_delegate.setSelection(selection);
        }
    }
}

