/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.launcher;

import java.io.File;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.debug.ui.classpath.ClasspathEntry;
import org.eclipse.jdt.internal.debug.ui.launcher.LauncherMessages;
import org.eclipse.jdt.internal.launching.JREContainer;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry2;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class RuntimeClasspathEntryLabelProvider
extends LabelProvider {
    private WorkbenchLabelProvider lp = new WorkbenchLabelProvider();
    private ILaunchConfiguration fLaunchConfiguration;

    public Image getImage(Object element) {
        IRuntimeClasspathEntry entry = (IRuntimeClasspathEntry)element;
        IResource resource = entry.getResource();
        switch (entry.getType()) {
            case 1: {
                IJavaElement proj = JavaCore.create((IResource)resource);
                if (proj == null) {
                    return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_PROJECT_CLOSED");
                }
                return this.lp.getImage((Object)proj);
            }
            case 2: {
                if (resource instanceof IContainer) {
                    return this.lp.getImage((Object)resource);
                }
                boolean external = resource == null;
                boolean source = entry.getSourceAttachmentPath() != null && !Path.EMPTY.equals((Object)entry.getSourceAttachmentPath());
                String key = null;
                if (external) {
                    IPath path = entry.getPath();
                    if (path != null) {
                        File file = path.toFile();
                        key = file.exists() && file.isDirectory() ? "org.eclipse.jdt.ui.packagefolder_obj.gif" : (source ? "org.eclipse.jdt.ui.jar_lsrc_obj.gif" : "org.eclipse.jdt.ui.jar_l_obj.gif");
                    }
                } else {
                    key = source ? "org.eclipse.jdt.ui.jar_src_obj.gif" : "org.eclipse.jdt.ui.jar_obj.gif";
                }
                return JavaUI.getSharedImages().getImage(key);
            }
            case 3: {
                return DebugUITools.getImage((String)"IMG_OBJS_ENV_VAR");
            }
            case 4: {
                return JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.library_obj.gif");
            }
            case 5: {
                Image image;
                IRuntimeClasspathEntry delegate = entry;
                if (entry instanceof ClasspathEntry) {
                    delegate = ((ClasspathEntry)entry).getDelegate();
                }
                if ((image = this.lp.getImage((Object)delegate)) != null) {
                    return image;
                }
                if (resource == null) {
                    return JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.library_obj.gif");
                }
                return this.lp.getImage((Object)resource);
            }
        }
        return null;
    }

    public String getText(Object element) {
        IRuntimeClasspathEntry entry = (IRuntimeClasspathEntry)element;
        switch (entry.getType()) {
            case 1: {
                IResource res = entry.getResource();
                IJavaElement proj = JavaCore.create((IResource)res);
                if (proj == null) {
                    return entry.getPath().lastSegment();
                }
                return this.lp.getText((Object)proj);
            }
            case 2: {
                IPath path = entry.getPath();
                if (path == null) {
                    return NLS.bind((String)LauncherMessages.RuntimeClasspathEntryLabelProvider_Invalid_path, (Object[])new String[]{"null"});
                }
                if (!path.isAbsolute() || !path.isValidPath(path.toString())) {
                    return NLS.bind((String)LauncherMessages.RuntimeClasspathEntryLabelProvider_Invalid_path, (Object[])new String[]{path.toOSString()});
                }
                String[] segments = path.segments();
                StringBuffer displayPath = new StringBuffer();
                if (segments.length > 0) {
                    displayPath.append(segments[segments.length - 1]);
                    displayPath.append(" - ");
                    String device = path.getDevice();
                    if (device != null) {
                        displayPath.append(device);
                    }
                    displayPath.append(File.separator);
                    int i = 0;
                    while (i < segments.length - 1) {
                        displayPath.append(segments[i]).append(File.separator);
                        ++i;
                    }
                } else {
                    displayPath.append(path.toOSString());
                }
                return displayPath.toString();
            }
            case 3: {
                IPath path = entry.getPath();
                IPath srcPath = entry.getSourceAttachmentPath();
                StringBuffer buf = new StringBuffer(path.toString());
                if (srcPath != null) {
                    buf.append(" [");
                    buf.append(srcPath.toString());
                    IPath rootPath = entry.getSourceAttachmentRootPath();
                    if (rootPath != null) {
                        buf.append('/');
                        buf.append(rootPath.toString());
                    }
                    buf.append(']');
                }
                if (path.equals((Object)new Path("JRE_LIB")) && this.fLaunchConfiguration != null) {
                    try {
                        IVMInstall vm = JavaRuntime.computeVMInstall((ILaunchConfiguration)this.fLaunchConfiguration);
                        buf.append(" - ");
                        buf.append(vm.getName());
                    }
                    catch (CoreException coreException) {}
                }
                return buf.toString();
            }
            case 4: {
                IPath path = entry.getPath();
                if (this.fLaunchConfiguration != null) {
                    try {
                        IJavaProject project = null;
                        try {
                            project = JavaRuntime.getJavaProject((ILaunchConfiguration)this.fLaunchConfiguration);
                        }
                        catch (CoreException coreException) {}
                        if (project == null) {
                            IVMInstall vm;
                            if (path.segmentCount() > 0 && path.segment(0).equals(JavaRuntime.JRE_CONTAINER) && (vm = JavaRuntime.getVMInstall((IPath)path)) != null) {
                                JREContainer container = new JREContainer(vm, path, project);
                                return container.getDescription();
                            }
                        } else {
                            IClasspathContainer container = JavaCore.getClasspathContainer((IPath)entry.getPath(), (IJavaProject)project);
                            if (container != null) {
                                return container.getDescription();
                            }
                        }
                    }
                    catch (CoreException coreException) {}
                }
                return entry.getPath().toString();
            }
            case 5: {
                String name;
                IRuntimeClasspathEntry delegate = entry;
                if (entry instanceof ClasspathEntry) {
                    delegate = ((ClasspathEntry)entry).getDelegate();
                }
                if ((name = this.lp.getText((Object)delegate)) == null || name.length() == 0) {
                    return ((IRuntimeClasspathEntry2)delegate).getName();
                }
                return name;
            }
        }
        return "";
    }

    public void dispose() {
        super.dispose();
        this.lp.dispose();
    }

    public void setLaunchConfiguration(ILaunchConfiguration configuration) {
        this.fLaunchConfiguration = configuration;
        this.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)this));
    }
}

