/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.metatype.impl;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.eclipse.equinox.metatype.EquinoxAttributeDefinition;
import org.eclipse.equinox.metatype.EquinoxObjectClassDefinition;
import org.eclipse.equinox.metatype.impl.AttributeDefinitionImpl;
import org.eclipse.equinox.metatype.impl.ExtendableHelper;
import org.eclipse.equinox.metatype.impl.FragmentUtils;
import org.eclipse.equinox.metatype.impl.Icon;
import org.eclipse.equinox.metatype.impl.LocalizationElement;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectClassDefinitionImpl
extends LocalizationElement
implements EquinoxObjectClassDefinition,
Cloneable {
    private static final Comparator<Icon> iconComparator = new Comparator<Icon>(){

        @Override
        public int compare(Icon icon1, Icon icon2) {
            return icon1.getIconSize().compareTo(icon2.getIconSize());
        }
    };
    private final String _name;
    private final String _id;
    private final String _description;
    private final int _type;
    private final Vector<AttributeDefinitionImpl> _required = new Vector(7);
    private final Vector<AttributeDefinitionImpl> _optional = new Vector(7);
    private final ExtendableHelper helper;
    private List<Icon> icons;

    public ObjectClassDefinitionImpl(String name, String description, String id, String localization, Map<String, Map<String, String>> extensionAttributes) {
        this(name, description, id, 0, localization, new ExtendableHelper(extensionAttributes));
    }

    public ObjectClassDefinitionImpl(String name, String description, String id, int type, String localization, ExtendableHelper helper) {
        super(localization);
        this._name = name;
        this._id = id;
        this._description = description;
        this._type = type;
        this.helper = helper;
    }

    public synchronized Object clone() {
        AttributeDefinitionImpl ad;
        ObjectClassDefinitionImpl ocd = new ObjectClassDefinitionImpl(this._name, this._description, this._id, this._type, this.getLocalization(), this.helper);
        int i = 0;
        while (i < this._required.size()) {
            ad = this._required.elementAt(i);
            ocd.addAttributeDefinition((AttributeDefinitionImpl)ad.clone(), true);
            ++i;
        }
        i = 0;
        while (i < this._optional.size()) {
            ad = this._optional.elementAt(i);
            ocd.addAttributeDefinition((AttributeDefinitionImpl)ad.clone(), false);
            ++i;
        }
        if (this.icons != null) {
            ocd.setIcons(new ArrayList<Icon>(this.icons));
        }
        return ocd;
    }

    public String getName() {
        return this.getLocalized(this._name);
    }

    public String getID() {
        return this._id;
    }

    public String getDescription() {
        return this.getLocalized(this._description);
    }

    @Override
    public EquinoxAttributeDefinition[] getAttributeDefinitions(int filter) {
        switch (filter) {
            case 1: {
                EquinoxAttributeDefinition[] atts = new EquinoxAttributeDefinition[this._required.size()];
                this._required.toArray(atts);
                return atts;
            }
            case 2: {
                EquinoxAttributeDefinition[] atts = new EquinoxAttributeDefinition[this._optional.size()];
                this._optional.toArray(atts);
                return atts;
            }
        }
        EquinoxAttributeDefinition[] atts = new EquinoxAttributeDefinition[this._required.size() + this._optional.size()];
        Enumeration<AttributeDefinitionImpl> e = this._required.elements();
        int i = 0;
        while (e.hasMoreElements()) {
            atts[i] = e.nextElement();
            ++i;
        }
        e = this._optional.elements();
        while (e.hasMoreElements()) {
            atts[i] = e.nextElement();
            ++i;
        }
        return atts;
    }

    void addAttributeDefinition(AttributeDefinitionImpl ad, boolean isRequired) {
        if (isRequired) {
            this._required.addElement(ad);
        } else {
            this._optional.addElement(ad);
        }
    }

    public synchronized InputStream getIcon(int sizeHint) throws IOException {
        Icon icon = new Icon(null, sizeHint, null);
        List<Icon> icons = this.icons;
        if (icons == null) {
            return null;
        }
        int index = Collections.binarySearch(icons, icon, iconComparator);
        if (index < 0) {
            int average;
            Icon greaterThan;
            int insertionPoint = -(index + 1);
            Icon lessThan = insertionPoint == 0 ? null : icons.get(insertionPoint - 1);
            Icon icon2 = greaterThan = insertionPoint == icons.size() ? null : icons.get(insertionPoint);
            icon = lessThan == null ? greaterThan : (greaterThan == null ? lessThan : (sizeHint < (average = (greaterThan.getIconSize() + lessThan.getIconSize()) / 2) ? lessThan : greaterThan));
        } else {
            icon = icons.get(index);
        }
        Bundle b = icon.getIconBundle();
        URL[] urls = FragmentUtils.findEntries(b, this.getLocalized(icon.getIconName()));
        if (urls != null && urls.length > 0) {
            return urls[0].openStream();
        }
        return null;
    }

    synchronized void setIcons(List<Icon> icons) {
        if (icons == null || icons.isEmpty()) {
            return;
        }
        Collections.sort(icons, iconComparator);
        this.icons = Collections.unmodifiableList(icons);
    }

    void setResourceBundle(String assignedLocale, Bundle bundle) {
        this.setLocaleAndBundle(assignedLocale, bundle);
        Enumeration<AttributeDefinitionImpl> allADReqs = this._required.elements();
        while (allADReqs.hasMoreElements()) {
            AttributeDefinitionImpl ad = allADReqs.nextElement();
            ad.setLocaleAndBundle(assignedLocale, bundle);
        }
        Enumeration<AttributeDefinitionImpl> allADOpts = this._optional.elements();
        while (allADOpts.hasMoreElements()) {
            AttributeDefinitionImpl ad = allADOpts.nextElement();
            ad.setLocaleAndBundle(assignedLocale, bundle);
        }
    }

    @Override
    public Map<String, String> getExtensionAttributes(String schema) {
        return this.helper.getExtensionAttributes(schema);
    }

    @Override
    public Set<String> getExtensionUris() {
        return this.helper.getExtensionUris();
    }
}

