/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.ui.dialogs;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.text.AbstractDocument;
import org.eclipse.emf.cdo.common.model.CDOModelUtil;
import org.eclipse.emf.cdo.common.model.CDOPackageInfo;
import org.eclipse.emf.cdo.common.model.CDOPackageRegistry;
import org.eclipse.emf.cdo.common.model.CDOPackageUnit;
import org.eclipse.emf.cdo.common.model.EMFUtil;
import org.eclipse.emf.cdo.internal.ui.actions.RegisterFilesystemPackagesAction;
import org.eclipse.emf.cdo.internal.ui.actions.RegisterGeneratedPackagesAction;
import org.eclipse.emf.cdo.internal.ui.messages.Messages;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.ui.shared.SharedIcons;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.net4j.util.ObjectUtil;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.container.IPluginContainer;
import org.eclipse.net4j.util.ui.UIUtil;
import org.eclipse.net4j.util.ui.widgets.CustomizeableComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IWorkbenchPage;

public class PackageRegistryDialog
extends TitleAreaDialog {
    public static final String PRODUCT_GROUP = "org.eclipse.emf.cdo.ui.packageRegistryDialogCustomizers";
    private static final String TITLE = Messages.getString("PackageRegistryDialog.0");
    private static final Color GRAY = UIUtil.getDisplay().getSystemColor(15);
    private IWorkbenchPage page;
    private CDOSession session;
    private TableViewer viewer;

    public PackageRegistryDialog(IWorkbenchPage page, CDOSession session) {
        super(page.getWorkbenchWindow().getShell());
        this.page = page;
        this.session = session;
        this.setShellStyle(this.getShellStyle() | 0x10000 | 0x400 | 0x20 | 0x10);
    }

    public IWorkbenchPage getPage() {
        return this.page;
    }

    public CDOSession getSession() {
        return this.session;
    }

    protected Point getInitialSize() {
        return new Point(660, 500);
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(TITLE);
        this.setTitle(this.session.toString());
        this.setTitleImage(SharedIcons.getImage((String)"wizban/PackageManager.gif"));
        Composite composite = (Composite)super.createDialogArea(parent);
        this.viewer = new TableViewer(composite, 0);
        Table table = this.viewer.getTable();
        table.setHeaderVisible(true);
        table.setLayoutData((Object)UIUtil.createGridData());
        this.addColumn(table, Messages.getString("PackageRegistryDialog.1"), 400, 16384);
        this.addColumn(table, Messages.getString("PackageRegistryDialog.2"), 75, 0x1000000);
        this.addColumn(table, Messages.getString("PackageRegistryDialog.3"), 75, 0x1000000);
        this.addColumn(table, Messages.getString("PackageRegistryDialog.4"), 75, 0x1000000);
        this.viewer.setContentProvider((IContentProvider)new EPackageContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new EPackageLabelProvider());
        this.viewer.setInput((Object)this.session);
        return composite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        Button button = this.createButton(parent, -1, Messages.getString("PackageRegistryDialog.5"), false);
        button.setEnabled(this.isGlobalPackageAvaliable());
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                new RegisterGeneratedPackagesAction(PackageRegistryDialog.this.page, PackageRegistryDialog.this.session){

                    @Override
                    protected void postRegistration(List<EPackage> ePackages) {
                        PackageRegistryDialog.this.refreshViewer();
                    }
                }.run();
            }
        });
        this.createButton(parent, -1, Messages.getString("PackageRegistryDialog.7"), false).addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                new RegisterFilesystemPackagesAction(PackageRegistryDialog.this.page, PackageRegistryDialog.this.session){

                    @Override
                    protected void postRegistration(List<EPackage> ePackages) {
                        PackageRegistryDialog.this.refreshViewer();
                    }
                }.run();
            }
        });
        CustomizeableComposite.customize((Composite)parent, (IManagedContainer)IPluginContainer.INSTANCE, (String)PRODUCT_GROUP, (Object)((Object)this));
        this.createButton(parent, 1, IDialogConstants.CLOSE_LABEL, false);
    }

    public Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        return super.createButton(parent, id, label, defaultButton);
    }

    private boolean isGlobalPackageAvaliable() {
        HashSet uris = new HashSet(EPackage.Registry.INSTANCE.keySet());
        uris.removeAll(this.session.getPackageRegistry().keySet());
        return !uris.isEmpty();
    }

    private void addColumn(Table table, String title, int width, int alignment) {
        TableColumn column = new TableColumn(table, alignment);
        column.setText(title);
        column.setWidth(width);
    }

    protected Image getContentIcon(AbstractDocument.Content content) {
        return null;
    }

    public void refreshViewer() {
        this.page.getWorkbenchWindow().getShell().getDisplay().asyncExec(new Runnable(){

            public void run() {
                try {
                    PackageRegistryDialog.this.viewer.refresh();
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }
        });
    }

    public static class EPackageContentProvider
    implements IStructuredContentProvider {
        private static final Object[] NO_ELEMENTS = new Object[0];
        private CDOSession session;

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            if (newInput instanceof CDOSession && !ObjectUtil.equals((Object)this.session, (Object)newInput)) {
                this.session = (CDOSession)newInput;
            }
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement != this.session) {
                return NO_ELEMENTS;
            }
            return EMFUtil.getSortedRegistryEntries((EPackage.Registry)this.session.getPackageRegistry());
        }
    }

    public class EPackageLabelProvider
    extends BaseLabelProvider
    implements ITableLabelProvider,
    IColorProvider {
        public String getColumnText(Object element, int columnIndex) {
            Map.Entry entry = (Map.Entry)element;
            CDOPackageInfo packageInfo = CDOModelUtil.getPackageInfo(entry.getValue(), (CDOPackageRegistry)PackageRegistryDialog.this.session.getPackageRegistry());
            if (packageInfo != null) {
                switch (columnIndex) {
                    case 0: {
                        return packageInfo.getPackageURI();
                    }
                    case 1: {
                        return packageInfo.getPackageUnit().getState().toString();
                    }
                    case 2: {
                        if (packageInfo.getPackageUnit().getType() == CDOPackageUnit.Type.UNKNOWN) {
                            return Messages.getString("PackageRegistryDialog.8");
                        }
                        return packageInfo.getPackageUnit().getType().toString();
                    }
                    case 3: {
                        return packageInfo.getPackageUnit().getOriginalType().toString();
                    }
                }
            }
            switch (columnIndex) {
                case 0: {
                    return (String)entry.getKey();
                }
            }
            return "";
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 0) {
                Map.Entry entry = (Map.Entry)element;
                CDOPackageInfo packageInfo = CDOModelUtil.getPackageInfo(entry.getValue(), (CDOPackageRegistry)PackageRegistryDialog.this.session.getPackageRegistry());
                if (packageInfo != null) {
                    switch (packageInfo.getPackageUnit().getType()) {
                        case LEGACY: {
                            return SharedIcons.getDescriptor((String)"obj16/EPackageLegacy.gif").createImage();
                        }
                        case NATIVE: {
                            return SharedIcons.getDescriptor((String)"obj16/EPackageNative.gif").createImage();
                        }
                        case DYNAMIC: {
                            return SharedIcons.getDescriptor((String)"obj16/EPackageDynamic.gif").createImage();
                        }
                    }
                }
                return SharedIcons.getDescriptor((String)"obj16/EPackageUnknown.gif").createImage();
            }
            return null;
        }

        public Color getBackground(Object element) {
            return null;
        }

        public Color getForeground(Object element) {
            Map.Entry entry = (Map.Entry)element;
            CDOPackageInfo packageInfo = CDOModelUtil.getPackageInfo(entry.getValue(), (CDOPackageRegistry)PackageRegistryDialog.this.session.getPackageRegistry());
            if (packageInfo != null) {
                return null;
            }
            return GRAY;
        }
    }
}

