/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.explorer.checkouts;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.WeakHashMap;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchManager;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.explorer.CDOExplorerUtil;
import org.eclipse.emf.cdo.explorer.checkouts.CDOCheckout;
import org.eclipse.emf.cdo.explorer.repositories.CDORepository;
import org.eclipse.emf.cdo.internal.explorer.AbstractElement;
import org.eclipse.emf.cdo.internal.explorer.AbstractManager;
import org.eclipse.emf.cdo.internal.explorer.bundle.OM;
import org.eclipse.emf.cdo.internal.explorer.checkouts.CDOCheckoutManagerImpl;
import org.eclipse.emf.cdo.internal.explorer.repositories.CDORepositoryImpl;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.util.CDOUtil;
import org.eclipse.emf.cdo.util.ReadOnlyException;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.cdo.view.CDOViewLocksChangedEvent;
import org.eclipse.emf.cdo.view.CDOViewTargetChangedEvent;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.spi.cdo.InternalCDOObject;
import org.eclipse.emf.spi.cdo.InternalCDOView;
import org.eclipse.net4j.util.ObjectUtil;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.container.IPluginContainer;
import org.eclipse.net4j.util.event.IEvent;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.lifecycle.ILifecycle;
import org.eclipse.net4j.util.lifecycle.ILifecycleEvent;
import org.eclipse.net4j.util.lifecycle.LifecycleEventAdapter;

public abstract class CDOCheckoutImpl
extends AbstractElement
implements CDOCheckout {
    public static final String PROP_ROOT_ID = "rootID";
    public static final String PROP_READ_ONLY = "readOnly";
    public static final String PROP_TIME_STAMP = "timeStamp";
    public static final String PROP_BRANCH_ID = "branchID";
    public static final String PROP_BRANCH_PATH = "branchPath";
    public static final String PROP_BRANCH_POINTS = "branchPoints";
    public static final String PROP_REPOSITORY = "repository";
    public static final String EDITOR_PROPERTIES = "editor.properties";
    public static final String CHECKOUT_KEY = CDOCheckout.class.getName();
    private static final CDOBranchPoint[] NO_BRANCH_POINTS = new CDOBranchPoint[0];
    private static final int BRANCH_POINTS_MAX = 10;
    private static final String BRANCH_POINT_SEPARATOR = ",";
    private static final String BRANCH_AND_POINT_SEPARATOR = "_";
    private final Set<CDOView> views = new HashSet<CDOView>();
    private final Map<CDOID, String> editorIDs = new WeakHashMap<CDOID, String>();
    private CDORepository repository;
    private int branchID;
    private String branchPath;
    private String branchPoints;
    private long timeStamp;
    private boolean readOnly;
    private CDOID rootID;
    private CDOCheckout.State state = CDOCheckout.State.Closed;
    private CDOView view;
    private EObject rootObject;
    private URI uri;

    public CDOCheckoutImpl() {
    }

    public CDOCheckoutImpl(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public final CDOCheckoutManagerImpl getManager() {
        return OM.getCheckoutManager();
    }

    public final CDORepository getRepository() {
        return this.repository;
    }

    public final int getBranchID() {
        return this.branchID;
    }

    public final void setBranchID(int branchID) {
        this.setBranchPoint(branchID, this.timeStamp);
    }

    public String getBranchPath() {
        return this.branchPath;
    }

    public final void setBranchPath(String branchPath) {
        if (!ObjectUtil.equals((Object)this.branchPath, (Object)branchPath)) {
            this.branchPath = branchPath;
            this.save();
        }
    }

    public final CDOBranchPoint getBranchPoint() {
        return this.view;
    }

    public final void setBranchPoint(CDOBranchPoint branchPoint) {
        int branchID = branchPoint.getBranch().getID();
        long timeStamp = branchPoint.getTimeStamp();
        this.setBranchPoint(branchID, timeStamp);
    }

    public final void setBranchPoint(int branchID, long timeStamp) {
        if (this.branchID != branchID || this.timeStamp != timeStamp) {
            this.addBranchPoint(this.branchID, this.timeStamp);
            this.branchID = branchID;
            this.timeStamp = timeStamp;
            if (this.isOpen()) {
                this.branchPath = this.doSetBranchPoint(branchID, timeStamp);
                CDOView[] cDOViewArray = this.getViews();
                int n = cDOViewArray.length;
                int n2 = 0;
                while (n2 < n) {
                    CDOView view = cDOViewArray[n2];
                    if (view != this.view) {
                        view.setBranchPoint((CDOBranchPoint)this.view);
                    }
                    ++n2;
                }
            } else {
                this.branchPath = null;
            }
            this.save();
        }
    }

    public final CDOBranchPoint getBranchPoint(CDOCheckout fromCheckout) {
        if (this.repository == fromCheckout.getRepository() && this.repository.isConnected()) {
            CDOBranchManager branchManager = this.repository.getSession().getBranchManager();
            CDOBranch branch = branchManager.getBranch(fromCheckout.getBranchID());
            return branch.getPoint(fromCheckout.getTimeStamp());
        }
        return null;
    }

    protected String doSetBranchPoint(int branchID, long timeStamp) {
        CDOBranch branch = this.view.getSession().getBranchManager().getBranch(branchID);
        this.view.setBranchPoint(branch.getPoint(timeStamp));
        return branch.getPathName();
    }

    public CDOBranchPoint[] getBranchPoints() {
        if (this.branchPoints != null && this.isOpen()) {
            ArrayList<CDOBranchPoint> result = new ArrayList<CDOBranchPoint>();
            CDOBranchManager branchManager = this.view.getSession().getBranchManager();
            String[] stringArray = this.branchPoints.split(BRANCH_POINT_SEPARATOR);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String token = stringArray[n2];
                String[] branchAndPoint = token.split(BRANCH_AND_POINT_SEPARATOR);
                int branchID = Integer.parseInt(branchAndPoint[0]);
                CDOBranch branch = branchManager.getBranch(branchID);
                if (branch != null) {
                    long timeStamp = branchAndPoint.length >= 2 ? Long.parseLong(branchAndPoint[1]) : 0L;
                    result.add(branch.getPoint(timeStamp));
                }
                ++n2;
            }
            return result.toArray(new CDOBranchPoint[result.size()]);
        }
        return NO_BRANCH_POINTS;
    }

    public boolean addBranchPoint(CDOBranchPoint branchPoint) {
        long timeStamp;
        int branchID = branchPoint.getBranch().getID();
        boolean changed = this.addBranchPoint(branchID, timeStamp = branchPoint.getTimeStamp());
        if (changed) {
            this.save();
        }
        return changed;
    }

    private boolean addBranchPoint(int branchID, long timeStamp) {
        String oldBranchPoints = this.branchPoints;
        String newToken = Integer.toString(branchID);
        if (timeStamp != 0L) {
            newToken = String.valueOf(newToken) + BRANCH_AND_POINT_SEPARATOR + timeStamp;
        }
        if (this.branchPoints != null) {
            StringBuilder builder = new StringBuilder(newToken);
            int count = 1;
            String[] stringArray = this.branchPoints.split(BRANCH_POINT_SEPARATOR);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String token = stringArray[n2];
                if (count++ == 10) break;
                if (!token.equals(newToken)) {
                    builder.append(BRANCH_POINT_SEPARATOR);
                    builder.append(token);
                }
                ++n2;
            }
            this.branchPoints = builder.toString();
        } else {
            this.branchPoints = newToken;
        }
        return !ObjectUtil.equals((Object)this.branchPoints, (Object)oldBranchPoints);
    }

    public final long getTimeStamp() {
        return this.timeStamp;
    }

    public final void setTimeStamp(long timeStamp) {
        this.setBranchPoint(this.branchID, timeStamp);
    }

    public final boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        if (this.state != CDOCheckout.State.Closed) {
            throw new IllegalStateException("Checkout is not closed: " + this);
        }
        if (this.readOnly != readOnly) {
            this.readOnly = readOnly;
            this.save();
        }
    }

    public final CDOID getRootID() {
        return this.rootID;
    }

    public final void setRootID(CDOID rootID) {
        this.rootID = rootID;
    }

    public CDOCheckout duplicate() {
        Properties properties = new Properties();
        this.collectDuplicationProperties(properties);
        CDOCheckout copy = CDOExplorerUtil.getCheckoutManager().addCheckout(properties);
        if (this.isOpen()) {
            copy.open();
        }
        return copy;
    }

    protected void collectDuplicationProperties(Properties properties) {
        properties.setProperty("type", this.getType());
        properties.setProperty("label", this.getManager().getUniqueLabel(this.getLabel()));
        properties.setProperty(PROP_REPOSITORY, this.getRepository().getID());
        properties.setProperty(PROP_BRANCH_ID, Integer.toString(this.getBranchID()));
        properties.setProperty(PROP_TIME_STAMP, Long.toString(this.getTimeStamp()));
        properties.setProperty(PROP_READ_ONLY, Boolean.toString(this.isReadOnly()));
        properties.setProperty(PROP_ROOT_ID, CDOCheckoutImpl.getCDOIDString(this.getRootID()));
    }

    public final CDOCheckout.State getState() {
        return this.state;
    }

    public final boolean isOpen() {
        return this.view != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void open() {
        CDOCheckoutManagerImpl manager = this.getManager();
        CDOCheckout.State oldState = null;
        CDOCheckout.State newState = null;
        try {
            CDOCheckoutImpl cDOCheckoutImpl = this;
            synchronized (cDOCheckoutImpl) {
                oldState = this.state;
                if (!this.isOpen()) {
                    try {
                        this.state = CDOCheckout.State.Opening;
                        if (manager != null) {
                            manager.fireCheckoutOpenEvent(this, null, oldState, this.state);
                        }
                        oldState = this.state;
                        this.prepareOpen();
                        CDOSession session = ((CDORepositoryImpl)this.repository).openCheckout(this);
                        this.view = this.openView(session);
                        this.view.addListener((IListener)new LifecycleEventAdapter(){

                            protected void onDeactivated(ILifecycle lifecycle) {
                                CDOCheckoutImpl.this.removeView(CDOCheckoutImpl.this.view);
                                if (CDOCheckoutImpl.this.state != CDOCheckout.State.Closing) {
                                    CDOCheckoutImpl.this.close();
                                }
                            }
                        });
                        this.configureView(this.view);
                        this.rootObject = this.loadRootObject();
                        this.rootObject.eAdapters().add((Object)this);
                        newState = this.state = CDOCheckout.State.Open;
                    }
                    catch (RuntimeException ex) {
                        this.view = null;
                        this.rootObject = null;
                        newState = this.state = CDOCheckout.State.Closed;
                        throw ex;
                    }
                    catch (Error ex) {
                        this.view = null;
                        this.rootObject = null;
                        newState = this.state = CDOCheckout.State.Closed;
                        throw ex;
                    }
                }
            }
        }
        catch (Throwable throwable) {
            if (manager != null && oldState != null && newState != null && newState != oldState) {
                manager.fireCheckoutOpenEvent(this, this.view, oldState, newState);
            }
            throw throwable;
        }
        if (manager != null && oldState != null && newState != null && newState != oldState) {
            manager.fireCheckoutOpenEvent(this, this.view, oldState, newState);
        }
    }

    protected void prepareOpen() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void close() {
        CDOCheckoutManagerImpl manager;
        boolean closed = false;
        CDOView oldView = null;
        CDOCheckoutImpl cDOCheckoutImpl = this;
        synchronized (cDOCheckoutImpl) {
            if (this.isOpen()) {
                try {
                    this.state = CDOCheckout.State.Closing;
                    oldView = this.view;
                    try {
                        CDOView[] remainingViews;
                        this.rootObject.eAdapters().remove((Object)this);
                        this.closeView();
                        CDOView[] cDOViewArray = remainingViews = this.getViews();
                        int n = remainingViews.length;
                        int n2 = 0;
                        while (n2 < n) {
                            CDOView remainingView = cDOViewArray[n2];
                            remainingView.close();
                            ++n2;
                        }
                    }
                    finally {
                        ((CDORepositoryImpl)this.repository).closeCheckout(this);
                    }
                }
                finally {
                    this.rootObject = null;
                    this.view = null;
                    this.state = CDOCheckout.State.Closed;
                }
                closed = true;
            }
        }
        if (closed && (manager = this.getManager()) != null) {
            manager.fireCheckoutOpenEvent(this, oldView, CDOCheckout.State.Open, CDOCheckout.State.Closed);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addView(CDOView view) {
        CDOCheckoutImpl cDOCheckoutImpl = this;
        synchronized (cDOCheckoutImpl) {
            this.views.add(view);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeView(CDOView view) {
        CDOCheckoutImpl cDOCheckoutImpl = this;
        synchronized (cDOCheckoutImpl) {
            this.views.remove(view);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CDOView[] getViews() {
        CDOCheckoutImpl cDOCheckoutImpl = this;
        synchronized (cDOCheckoutImpl) {
            return this.views.toArray(new CDOView[this.views.size()]);
        }
    }

    public final CDOView getView() {
        return this.view;
    }

    public final URI getURI() {
        return this.uri;
    }

    public final EObject getRootObject() {
        return this.rootObject;
    }

    public final CDOCheckout.ObjectType getRootType() {
        return CDOCheckout.ObjectType.valueFor(this.rootObject);
    }

    protected ResourceSetImpl createResourceSet() {
        return new ResourceSetImpl();
    }

    public final CDOView openView() {
        return this.openView((ResourceSet)this.createResourceSet());
    }

    public CDOView openView(ResourceSet resourceSet) {
        return this.openView(this.readOnly, resourceSet);
    }

    public final CDOView openView(boolean readOnly) {
        return this.openView(readOnly, (ResourceSet)this.createResourceSet());
    }

    public CDOView openView(boolean readOnly, ResourceSet resourceSet) {
        return this.openAndConfigureView(readOnly, resourceSet);
    }

    public final CDOTransaction openTransaction() {
        return this.openTransaction((ResourceSet)this.createResourceSet());
    }

    public CDOTransaction openTransaction(ResourceSet resourceSet) {
        if (this.readOnly) {
            throw new ReadOnlyException("Checkout '" + this.getLabel() + "' is read-only");
        }
        return (CDOTransaction)this.openAndConfigureView(false, resourceSet);
    }

    private CDOView openAndConfigureView(boolean readOnly, ResourceSet resourceSet) {
        CDOView view = this.doOpenView(readOnly, resourceSet);
        view = this.configureView(view);
        EObject object = view.getObject(this.rootObject);
        object.eAdapters().add((Object)this);
        return view;
    }

    protected CDOView doOpenView(boolean readOnly, ResourceSet resourceSet) {
        if (this.view == null) {
            return null;
        }
        CDOSession session = this.view.getSession();
        if (readOnly) {
            return session.openView((CDOBranchPoint)this.view, resourceSet);
        }
        CDOBranch branch = this.view.getBranch();
        CDOBranchPoint head = branch.getHead();
        return session.openTransaction(head, resourceSet);
    }

    protected CDOView configureView(final CDOView view) {
        CDOUtil.configureView((CDOView)view);
        ((InternalCDOView)view).setRepositoryName(this.repository.getLabel());
        view.properties().put((Object)"timeMachineDisabled", (Object)(!this.isReadOnly() ? 1 : 0));
        view.properties().put((Object)CHECKOUT_KEY, (Object)this);
        view.addListener(new IListener(){

            public void notifyEvent(IEvent event) {
                ILifecycleEvent e;
                if (event instanceof CDOViewLocksChangedEvent) {
                    CDOCheckoutManagerImpl manager;
                    CDOViewLocksChangedEvent e2 = (CDOViewLocksChangedEvent)event;
                    Object[] objects = e2.getAffectedObjects();
                    if (objects.length != 0 && (manager = CDOCheckoutImpl.this.getManager()) != null) {
                        manager.fireElementsChangedEvent(objects);
                    }
                } else if (event instanceof CDOViewTargetChangedEvent) {
                    CDOViewTargetChangedEvent e3 = (CDOViewTargetChangedEvent)event;
                    CDOCheckoutImpl.this.setBranchPoint(e3.getBranchPoint());
                } else if (event instanceof ILifecycleEvent && (e = (ILifecycleEvent)event).getKind() == ILifecycleEvent.Kind.DEACTIVATED) {
                    CDOCheckoutImpl.this.removeView(view);
                }
            }
        });
        URI from = URI.createURI((String)("cdo://" + view.getSession().getRepositoryInfo().getUUID() + "/"));
        URI to = this.uri.appendSegment("");
        view.getResourceSet().getURIConverter().getURIMap().put(from, to);
        this.addView(view);
        return view;
    }

    public URI createResourceURI(String path) {
        String authority = this.getID();
        if (StringUtil.isEmpty((String)path)) {
            return URI.createHierarchicalURI((String)"cdo.checkout", (String)authority, null, null, null, null);
        }
        String[] segments = new Path(path).segments();
        return URI.createHierarchicalURI((String)"cdo.checkout", (String)authority, null, (String[])segments, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getEditorOpenerID(CDOID objectID) {
        Map<CDOID, String> map = this.editorIDs;
        synchronized (map) {
            String editorID = this.editorIDs.get(objectID);
            if (editorID != null) {
                return editorID;
            }
            Properties properties = AbstractManager.loadProperties(this.getFolder(), EDITOR_PROPERTIES);
            if (properties != null) {
                String idString = CDOCheckoutImpl.getCDOIDString(objectID);
                return properties.getProperty(idString);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEditorOpenerID(CDOID objectID, String editorID) {
        Map<CDOID, String> map = this.editorIDs;
        synchronized (map) {
            String exisingEditorID = this.editorIDs.get(objectID);
            if (ObjectUtil.equals((Object)exisingEditorID, (Object)editorID)) {
                return;
            }
            Properties properties = AbstractManager.loadProperties(this.getFolder(), EDITOR_PROPERTIES);
            if (properties == null) {
                properties = new Properties();
            }
            String idString = CDOCheckoutImpl.getCDOIDString(objectID);
            properties.setProperty(idString, editorID);
            this.saveProperties(EDITOR_PROPERTIES, properties);
            this.editorIDs.put(objectID, editorID);
        }
    }

    public void delete(boolean deleteContents) {
        this.close();
        CDOCheckoutManagerImpl manager = this.getManager();
        if (manager != null) {
            manager.removeElement(this);
        }
        super.delete(deleteContents);
        ((CDORepositoryImpl)this.repository).removeCheckout(this);
        this.repository = null;
    }

    public boolean isAdapterForType(Object type) {
        if (type == CDOCheckout.class) {
            return true;
        }
        return super.isAdapterForType(type);
    }

    public Object getAdapter(Class adapter) {
        if (this.isOpen() && adapter == CDOView.class) {
            return this.view;
        }
        return super.getAdapter(adapter);
    }

    public String toString() {
        return this.getLabel();
    }

    protected void init(File folder, String type, Properties properties) {
        super.init(folder, type, properties);
        String repositoryID = properties.getProperty(PROP_REPOSITORY);
        this.repository = (CDORepository)OM.getRepositoryManager().getElement(repositoryID);
        if (this.repository == null) {
            throw new IllegalStateException("Repository not found: " + repositoryID);
        }
        this.branchID = Integer.parseInt(properties.getProperty(PROP_BRANCH_ID));
        this.branchPath = properties.getProperty(PROP_BRANCH_PATH);
        this.branchPoints = properties.getProperty(PROP_BRANCH_POINTS);
        this.timeStamp = Long.parseLong(properties.getProperty(PROP_TIME_STAMP));
        this.readOnly = this.isOnline() ? Boolean.parseBoolean(properties.getProperty(PROP_READ_ONLY)) : false;
        String property = properties.getProperty(PROP_ROOT_ID);
        if (property != null) {
            this.rootID = CDOIDUtil.read((String)property);
        }
        this.uri = this.createResourceURI(null);
        ((CDORepositoryImpl)this.repository).addCheckout(this);
    }

    protected void collectProperties(Properties properties) {
        super.collectProperties(properties);
        properties.setProperty(PROP_REPOSITORY, this.repository.getID());
        properties.setProperty(PROP_BRANCH_ID, Integer.toString(this.branchID));
        properties.setProperty(PROP_TIME_STAMP, Long.toString(this.timeStamp));
        properties.setProperty(PROP_READ_ONLY, Boolean.toString(this.isOnline() ? this.readOnly : false));
        if (this.branchPath != null) {
            properties.setProperty(PROP_BRANCH_PATH, this.branchPath);
        }
        if (this.branchPoints != null) {
            properties.setProperty(PROP_BRANCH_POINTS, this.branchPoints);
        }
        if (!CDOIDUtil.isNull((CDOID)this.rootID)) {
            String string = CDOCheckoutImpl.getCDOIDString(this.rootID);
            properties.setProperty(PROP_ROOT_ID, string);
        }
    }

    protected IManagedContainer getContainer() {
        return IPluginContainer.INSTANCE;
    }

    protected EObject loadRootObject() {
        if (CDOIDUtil.isNull((CDOID)this.rootID)) {
            this.rootID = this.view.getSession().getRepositoryInfo().getRootResourceID();
        }
        InternalCDOObject cdoObject = (InternalCDOObject)this.view.getObject(this.rootID);
        return cdoObject.cdoInternalInstance();
    }

    protected abstract CDOView openView(CDOSession var1);

    protected void closeView() {
        this.view.close();
    }

    public static String getCDOIDString(CDOID id) {
        StringBuilder builder = new StringBuilder();
        CDOIDUtil.write((StringBuilder)builder, (CDOID)id);
        return builder.toString();
    }
}

