/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.editor.saveparticipant;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.editor.saveparticipant.IPostSaveListener;
import org.eclipse.dltk.ui.editor.saveparticipant.SaveParticipantMessages;
import org.eclipse.dltk.utils.PriorityNatureExtensionManager;
import org.eclipse.osgi.util.NLS;

public final class SaveParticipantRegistry
extends PriorityNatureExtensionManager<IPostSaveListener> {
    private static final IPostSaveListener[] EMPTY_ARRAY = new IPostSaveListener[0];

    public SaveParticipantRegistry() {
        super("org.eclipse.dltk.ui.saveParticipants", IPostSaveListener.class);
    }

    protected boolean isValidElement(IConfigurationElement element) {
        return "saveParticipant".equals(element.getName());
    }

    public IPostSaveListener[] getEnabledPostSaveListeners(ISourceModule module) {
        ArrayList<IPostSaveListener> result = null;
        IDLTKLanguageToolkit toolkit = DLTKLanguageManager.getLanguageToolkit((IModelElement)module);
        if (toolkit != null) {
            IPostSaveListener[] iPostSaveListenerArray = (IPostSaveListener[])this.getInstances(toolkit.getNatureId());
            int n = iPostSaveListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                IPostSaveListener descriptor = iPostSaveListenerArray[n2];
                if (descriptor.isEnabled(module)) {
                    if (result == null) {
                        result = new ArrayList<IPostSaveListener>();
                    }
                    result.add(descriptor);
                }
                ++n2;
            }
        }
        if (result == null) {
            return EMPTY_ARRAY;
        }
        return result.toArray(new IPostSaveListener[result.size()]);
    }

    protected IPostSaveListener[] createEmptyResult() {
        return EMPTY_ARRAY;
    }

    public static boolean isChangedRegionsRequired(final ISourceModule unit, IPostSaveListener[] listeners) throws CoreException {
        String message = SaveParticipantMessages.SaveParticipantRegistry_needsChangedRegionFailed;
        final MultiStatus errorStatus = new MultiStatus("org.eclipse.dltk.ui", 10007, message, null);
        try {
            final boolean[] result = new boolean[1];
            int i = 0;
            while (i < listeners.length) {
                final IPostSaveListener listener = listeners[i];
                SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                    public void run() throws Exception {
                        if (listener.needsChangedRegions(unit)) {
                            result[0] = true;
                        }
                    }

                    public void handleException(Throwable ex) {
                        String msg = NLS.bind((String)"The save participant ''{0}'' caused an exception.", (Object)listener.getId());
                        DLTKUIPlugin.log((IStatus)new Status(4, "org.eclipse.dltk.ui", 10006, msg, ex));
                        String participantName = listener.getName();
                        msg = NLS.bind((String)SaveParticipantMessages.SaveParticipantRegistry_needsChangedRegionCausedException, (Object)participantName, (Object)ex.toString());
                        errorStatus.add((IStatus)new Status(4, "org.eclipse.dltk.ui", 10007, msg, null));
                    }
                });
                if (result[0]) {
                    return true;
                }
                ++i;
            }
        }
        finally {
            if (!errorStatus.isOK()) {
                throw new CoreException((IStatus)errorStatus);
            }
        }
        return false;
    }
}

