/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.refactoring.reorg;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.ScriptModelUtil;
import org.eclipse.dltk.internal.core.ExternalScriptFolder;
import org.eclipse.dltk.internal.corext.refactoring.reorg.IReorgEnablementPolicy;
import org.eclipse.dltk.internal.corext.refactoring.reorg.ModelElementTransfer;
import org.eclipse.dltk.internal.corext.refactoring.reorg.ParentChecker;
import org.eclipse.dltk.internal.corext.refactoring.reorg.ReorgUtils;
import org.eclipse.dltk.internal.corext.refactoring.util.ModelElementUtil;
import org.eclipse.dltk.internal.ui.refactoring.reorg.ReorgMessages;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.ModelElementLabelProvider;
import org.eclipse.dltk.ui.actions.SelectionDispatchAction;
import org.eclipse.dltk.ui.util.ExceptionHandler;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.part.ResourceTransfer;

public class CopyToClipboardAction
extends SelectionDispatchAction {
    private final Clipboard fClipboard;
    private SelectionDispatchAction fPasteAction;
    private boolean fAutoRepeatOnFailure = false;

    public CopyToClipboardAction(IWorkbenchSite site, Clipboard clipboard, SelectionDispatchAction pasteAction) {
        super(site);
        this.setText(ReorgMessages.CopyToClipboardAction_0);
        this.setDescription(ReorgMessages.CopyToClipboardAction_1);
        Assert.isNotNull((Object)clipboard);
        this.fClipboard = clipboard;
        this.fPasteAction = pasteAction;
        ISharedImages workbenchImages = CopyToClipboardAction.getWorkbenchSharedImages();
        this.setDisabledImageDescriptor(workbenchImages.getImageDescriptor("IMG_TOOL_COPY_DISABLED"));
        this.setImageDescriptor(workbenchImages.getImageDescriptor("IMG_TOOL_COPY"));
        this.setHoverImageDescriptor(workbenchImages.getImageDescriptor("IMG_TOOL_COPY"));
        this.update(this.getSelection());
        if (DLTKCore.DEBUG) {
            System.err.println("Add help support here...");
        }
    }

    public void setAutoRepeatOnFailure(boolean autorepeatOnFailure) {
        this.fAutoRepeatOnFailure = autorepeatOnFailure;
    }

    private static ISharedImages getWorkbenchSharedImages() {
        return DLTKUIPlugin.getDefault().getWorkbench().getSharedImages();
    }

    @Override
    public void selectionChanged(IStructuredSelection selection) {
        try {
            List elements = selection.toList();
            IResource[] resources = ReorgUtils.getResources(elements);
            IModelElement[] modelElements = ReorgUtils.getModelElements(elements);
            if (elements.size() != resources.length + modelElements.length) {
                this.setEnabled(false);
            } else {
                this.setEnabled(this.canEnable(resources, modelElements));
            }
        }
        catch (ModelException e) {
            if (ScriptModelUtil.isExceptionToBeLogged((CoreException)((Object)e))) {
                DLTKUIPlugin.log(e);
            }
            this.setEnabled(false);
        }
    }

    @Override
    public void run(IStructuredSelection selection) {
        try {
            List elements = selection.toList();
            IResource[] resources = ReorgUtils.getResources(elements);
            IModelElement[] modelElements = ReorgUtils.getModelElements(elements);
            if (elements.size() == resources.length + modelElements.length && this.canEnable(resources, modelElements)) {
                this.doRun(resources, modelElements);
            }
        }
        catch (CoreException e) {
            ExceptionHandler.handle(e, this.getShell(), ReorgMessages.CopyToClipboardAction_2, ReorgMessages.CopyToClipboardAction_3);
        }
    }

    private void doRun(IResource[] resources, IModelElement[] modelElements) throws CoreException {
        new ClipboardCopier(resources, modelElements, this.fClipboard, this.getShell(), this.fAutoRepeatOnFailure).copyToClipboard();
        if (this.fPasteAction != null && this.fPasteAction.getSelection() != null) {
            this.fPasteAction.update(this.fPasteAction.getSelection());
        }
    }

    private boolean canEnable(IResource[] resources, IModelElement[] modelElements) throws ModelException {
        return new CopyToClipboardEnablementPolicy(resources, modelElements).canEnable();
    }

    private static class ClipboardCopier {
        private final boolean fAutoRepeatOnFailure;
        private final IResource[] fResources;
        private final IModelElement[] fScriptElements;
        private final Clipboard fClipboard;
        private final Shell fShell;
        private final ILabelProvider fLabelProvider;

        private ClipboardCopier(IResource[] resources, IModelElement[] modelElements, Clipboard clipboard, Shell shell, boolean autoRepeatOnFailure) {
            Assert.isNotNull((Object)resources);
            Assert.isNotNull((Object)modelElements);
            Assert.isNotNull((Object)clipboard);
            Assert.isNotNull((Object)shell);
            this.fResources = resources;
            this.fScriptElements = modelElements;
            this.fClipboard = clipboard;
            this.fShell = shell;
            this.fLabelProvider = ClipboardCopier.createLabelProvider();
            this.fAutoRepeatOnFailure = autoRepeatOnFailure;
        }

        public void copyToClipboard() throws CoreException {
            HashSet fileNames = new HashSet(this.fResources.length + this.fScriptElements.length);
            StringBuffer namesBuf = new StringBuffer();
            this.processResources(fileNames, namesBuf);
            this.processScriptElements(fileNames, namesBuf);
            List typesList = ReorgUtils.getElementsOfType(this.fScriptElements, 7);
            IType[] types = typesList.toArray(new IType[typesList.size()]);
            ISourceModule[] cusOfMainTypes = ReorgUtils.getSourceModules((IModelElement[])types);
            IResource[] resourcesOfMainTypes = ReorgUtils.getResources((IModelElement[])cusOfMainTypes);
            ClipboardCopier.addFileNames(fileNames, resourcesOfMainTypes);
            IResource[] cuResources = ReorgUtils.getResources(ClipboardCopier.getSourceModules(this.fScriptElements));
            ClipboardCopier.addFileNames(fileNames, cuResources);
            IResource[] resourcesForClipboard = ReorgUtils.union(this.fResources, ReorgUtils.union(cuResources, resourcesOfMainTypes));
            IModelElement[] modelElementsForClipboard = ReorgUtils.union(this.fScriptElements, (IModelElement[])cusOfMainTypes);
            String[] fileNameArray = fileNames.toArray(new String[fileNames.size()]);
            this.copyToClipboard(resourcesForClipboard, fileNameArray, namesBuf.toString(), modelElementsForClipboard, 0);
        }

        private static IModelElement[] getSourceModules(IModelElement[] modelElements) {
            List cus = ReorgUtils.getElementsOfType(modelElements, 5);
            return cus.toArray(new ISourceModule[cus.size()]);
        }

        private void processResources(Set fileNames, StringBuffer namesBuf) {
            int i = 0;
            while (i < this.fResources.length) {
                IResource resource = this.fResources[i];
                ClipboardCopier.addFileName(fileNames, resource);
                if (i > 0) {
                    namesBuf.append('\n');
                }
                namesBuf.append(this.getName(resource));
                ++i;
            }
        }

        private void processScriptElements(Set fileNames, StringBuffer namesBuf) {
            int i = 0;
            while (i < this.fScriptElements.length) {
                IModelElement element = this.fScriptElements[i];
                switch (element.getElementType()) {
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        ClipboardCopier.addFileName(fileNames, ReorgUtils.getResource(element));
                        break;
                    }
                }
                if (this.fResources.length > 0 || i > 0) {
                    namesBuf.append('\n');
                }
                namesBuf.append(this.getName(element));
                ++i;
            }
        }

        private static void addFileNames(Set fileName, IResource[] resources) {
            int i = 0;
            while (i < resources.length) {
                ClipboardCopier.addFileName(fileName, resources[i]);
                ++i;
            }
        }

        private static void addFileName(Set fileName, IResource resource) {
            if (resource == null) {
                return;
            }
            IPath location = resource.getLocation();
            if (location != null) {
                fileName.add(location.toOSString());
            }
        }

        private void copyToClipboard(IResource[] resources, String[] fileNames, String names, IModelElement[] modelElements, int repeat) {
            block6: {
                int repeat_max_count = 10;
                try {
                    this.fClipboard.setContents(ClipboardCopier.createDataArray(resources, modelElements, fileNames, names), ClipboardCopier.createDataTypeArray(resources, modelElements, fileNames));
                }
                catch (SWTError e) {
                    if (e.code != 2002 || repeat >= 10) {
                        throw e;
                    }
                    if (this.fAutoRepeatOnFailure) {
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    if (!this.fAutoRepeatOnFailure && !MessageDialog.openQuestion((Shell)this.fShell, (String)ReorgMessages.CopyToClipboardAction_4, (String)ReorgMessages.CopyToClipboardAction_5)) break block6;
                    this.copyToClipboard(resources, fileNames, names, modelElements, repeat + 1);
                }
            }
        }

        private static Transfer[] createDataTypeArray(IResource[] resources, IModelElement[] modelElements, String[] fileNames) {
            ArrayList<Object> result = new ArrayList<Object>(4);
            if (resources.length != 0) {
                result.add(ResourceTransfer.getInstance());
            }
            if (modelElements.length != 0) {
                result.add((Object)ModelElementTransfer.getInstance());
            }
            if (fileNames.length != 0) {
                result.add(FileTransfer.getInstance());
            }
            result.add(TextTransfer.getInstance());
            return result.toArray(new Transfer[result.size()]);
        }

        private static Object[] createDataArray(IResource[] resources, IModelElement[] modelElements, String[] fileNames, String names) {
            ArrayList<Object> result = new ArrayList<Object>(4);
            if (resources.length != 0) {
                result.add(resources);
            }
            if (modelElements.length != 0) {
                result.add(modelElements);
            }
            if (fileNames.length != 0) {
                result.add(fileNames);
            }
            result.add(names);
            return result.toArray();
        }

        private static ILabelProvider createLabelProvider() {
            return new ModelElementLabelProvider(547);
        }

        private String getName(IResource resource) {
            return this.fLabelProvider.getText((Object)resource);
        }

        private String getName(IModelElement modelElement) {
            return this.fLabelProvider.getText((Object)modelElement);
        }
    }

    private static class CopyToClipboardEnablementPolicy
    implements IReorgEnablementPolicy {
        private final IResource[] fResources;
        private final IModelElement[] fScriptElements;

        public CopyToClipboardEnablementPolicy(IResource[] resources, IModelElement[] modelElements) {
            Assert.isNotNull((Object)resources);
            Assert.isNotNull((Object)modelElements);
            this.fResources = resources;
            this.fScriptElements = modelElements;
        }

        @Override
        public boolean canEnable() throws ModelException {
            if (this.fResources.length + this.fScriptElements.length == 0) {
                return false;
            }
            if (this.hasProjects() && this.hasNonProjects()) {
                return false;
            }
            if (!this.canCopyAllToClipboard()) {
                return false;
            }
            return new ParentChecker(this.fResources, this.fScriptElements).haveCommonParent();
        }

        private boolean canCopyAllToClipboard() throws ModelException {
            int i = 0;
            while (i < this.fResources.length) {
                if (!CopyToClipboardEnablementPolicy.canCopyToClipboard(this.fResources[i])) {
                    return false;
                }
                ++i;
            }
            i = 0;
            while (i < this.fScriptElements.length) {
                if (!CopyToClipboardEnablementPolicy.canCopyToClipboard(this.fScriptElements[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        private static boolean canCopyToClipboard(IModelElement element) throws ModelException {
            if (element == null || !element.exists()) {
                return false;
            }
            if (ModelElementUtil.isDefaultPackage(element)) {
                return false;
            }
            if (DLTKCore.DEBUG) {
                System.err.println("TODO: Add inner element copy action..");
            }
            if (element instanceof ExternalScriptFolder) {
                return false;
            }
            return element.getElementType() <= 6;
        }

        private static boolean canCopyToClipboard(IResource resource) {
            return resource != null && resource.exists() && !resource.isPhantom() && resource.getType() != 8;
        }

        private boolean hasProjects() {
            int i = 0;
            while (i < this.fResources.length) {
                if (ReorgUtils.isProject(this.fResources[i])) {
                    return true;
                }
                ++i;
            }
            i = 0;
            while (i < this.fScriptElements.length) {
                if (ReorgUtils.isProject(this.fScriptElements[i])) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        private boolean hasNonProjects() {
            int i = 0;
            while (i < this.fResources.length) {
                if (!ReorgUtils.isProject(this.fResources[i])) {
                    return true;
                }
                ++i;
            }
            i = 0;
            while (i < this.fScriptElements.length) {
                if (!ReorgUtils.isProject(this.fScriptElements[i])) {
                    return true;
                }
                ++i;
            }
            return false;
        }
    }
}

