/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.model.elements;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.internal.ui.DelegatingModelPresentation;
import org.eclipse.debug.internal.ui.model.elements.ElementLabelProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ILabelUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.debug.internal.ui.views.DebugModelPresentationContext;
import org.eclipse.debug.internal.ui.views.launch.DebugElementHelper;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.IDebugModelPresentationExtension;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;

public class DebugElementLabelProvider
extends ElementLabelProvider {
    @Override
    protected String getLabel(TreePath elementPath, IPresentationContext presentationContext, String columnId) throws CoreException {
        Object element = elementPath.getLastSegment();
        if (presentationContext instanceof DebugModelPresentationContext) {
            DebugModelPresentationContext debugContext = (DebugModelPresentationContext)presentationContext;
            return debugContext.getModelPresentation().getText(element);
        }
        return DebugElementHelper.getLabel(element);
    }

    @Override
    protected RGB getBackground(TreePath elementPath, IPresentationContext presentationContext, String columnId) throws CoreException {
        Object element = elementPath.getLastSegment();
        if (presentationContext instanceof DebugModelPresentationContext) {
            DebugModelPresentationContext debugContext = (DebugModelPresentationContext)presentationContext;
            return DebugElementHelper.getBackground(element, debugContext.getModelPresentation());
        }
        return DebugElementHelper.getBackground(element);
    }

    @Override
    protected FontData getFontData(TreePath elementPath, IPresentationContext presentationContext, String columnId) throws CoreException {
        Object element = elementPath.getLastSegment();
        if (presentationContext instanceof DebugModelPresentationContext) {
            DebugModelPresentationContext debugContext = (DebugModelPresentationContext)presentationContext;
            return DebugElementHelper.getFont(element, debugContext.getModelPresentation());
        }
        return DebugElementHelper.getFont(element);
    }

    @Override
    protected RGB getForeground(TreePath elementPath, IPresentationContext presentationContext, String columnId) throws CoreException {
        Object element = elementPath.getLastSegment();
        if (presentationContext instanceof DebugModelPresentationContext) {
            DebugModelPresentationContext debugContext = (DebugModelPresentationContext)presentationContext;
            return DebugElementHelper.getForeground(element, debugContext.getModelPresentation());
        }
        return DebugElementHelper.getForeground(element);
    }

    @Override
    protected ImageDescriptor getImageDescriptor(TreePath elementPath, IPresentationContext presentationContext, String columnId) throws CoreException {
        Object element = elementPath.getLastSegment();
        if (presentationContext instanceof DebugModelPresentationContext) {
            DebugModelPresentationContext debugContext = (DebugModelPresentationContext)presentationContext;
            return DebugElementHelper.getImageDescriptor(element, debugContext.getModelPresentation());
        }
        return DebugElementHelper.getImageDescriptor(element);
    }

    protected IDebugModelPresentation getModelPresentation(IPresentationContext context, String modelId) {
        DebugModelPresentationContext debugContext;
        IDebugModelPresentation presentation;
        if (context instanceof DebugModelPresentationContext && (presentation = (debugContext = (DebugModelPresentationContext)context).getModelPresentation()) instanceof DelegatingModelPresentation) {
            return ((DelegatingModelPresentation)presentation).getPresentation(modelId);
        }
        return null;
    }

    @Override
    protected boolean requiresUIJob(ILabelUpdate[] updates) {
        DebugModelPresentationContext debugContext;
        IDebugModelPresentation presentation;
        ILabelUpdate update;
        IPresentationContext context;
        if (updates.length > 0 && (context = (update = updates[0]).getPresentationContext()) instanceof DebugModelPresentationContext && (presentation = (debugContext = (DebugModelPresentationContext)context).getModelPresentation()) instanceof IDebugModelPresentationExtension) {
            IDebugModelPresentationExtension extension = (IDebugModelPresentationExtension)presentation;
            int i = 0;
            while (i < updates.length) {
                if (extension.requiresUIThread(updates[i].getElement())) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }
}

