/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.ase.util;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.enablement.ase.catalog.SybaseASECatalogTrigger;
import org.eclipse.datatools.enablement.sybase.ase.models.sybaseasesqlmodel.SybaseASECatalog;
import org.eclipse.datatools.enablement.sybase.ase.models.sybaseasesqlmodel.SybaseASEDefault;
import org.eclipse.datatools.enablement.sybase.ase.models.sybaseasesqlmodel.SybaseASERule;
import org.eclipse.datatools.enablement.sybase.ase.models.sybaseasesqlmodel.SybaseASESchema;
import org.eclipse.datatools.enablement.sybase.ase.models.sybaseasesqlmodel.SybaseASESegment;
import org.eclipse.datatools.enablement.sybase.ase.models.sybaseasesqlmodel.SybaseASEUser;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.datatools.sqltools.core.ProcIdentifier;
import org.eclipse.datatools.sqltools.sql.util.ModelUtil;
import org.eclipse.datatools.sqltools.sql.util.SQLUtil;
import org.eclipse.emf.common.util.EList;

public class ASECatalogUtil {
    public static final String LOGSEGMENT = "logsegment";

    public static synchronized String retrieveProceduralObjectCode(Connection connection, ProcIdentifier proc) {
        StringBuffer buffer;
        block33: {
            String dbname = proc.getDatabaseName();
            boolean defaultDatabase = dbname == null || dbname.length() == 0;
            String syscomments = defaultDatabase ? "syscomments" : String.valueOf(dbname) + "..syscomments";
            String sysobjects = defaultDatabase ? "sysobjects" : String.valueOf(dbname) + "..sysobjects";
            String query1 = "select id from " + sysobjects + " where " + sysobjects + ".name=? and user_name(uid)=? ";
            ResultSet rs1 = null;
            ResultSet rs = null;
            buffer = new StringBuffer();
            try {
                try {
                    int number;
                    PreparedStatement getSourceStmt1 = null;
                    String procName = proc.getProcName();
                    int id = 0;
                    if (procName.charAt(0) == ' ' || procName.charAt(procName.length() - 1) == ' ') {
                        String procLike = SQLUtil.quote((String)("%" + procName.trim() + "%"), (char)'\'');
                        query1 = "select id, name from " + sysobjects + " where " + sysobjects + ".name like " + procLike + " and user_name(uid)=? ";
                        getSourceStmt1 = connection.prepareStatement(query1);
                        getSourceStmt1.setString(1, procLike);
                        getSourceStmt1.setString(1, proc.getOwnerName());
                        rs1 = getSourceStmt1.executeQuery();
                        String name = "";
                        while (rs1.next()) {
                            id = rs1.getInt(1);
                            name = rs1.getString(2);
                            if (!name.equals(procName)) {
                                continue;
                            }
                            break;
                        }
                    } else {
                        getSourceStmt1 = connection.prepareStatement(query1);
                        getSourceStmt1.setString(1, procName);
                        getSourceStmt1.setString(2, proc.getOwnerName());
                        rs1 = getSourceStmt1.executeQuery();
                        while (rs1.next()) {
                            id = rs1.getInt(1);
                        }
                    }
                    String query = "select text from " + syscomments + " where " + syscomments + ".id=? and " + syscomments + ".number=?";
                    PreparedStatement getSourceStmt2 = connection.prepareStatement(query);
                    getSourceStmt2.setInt(1, id);
                    if (proc.getType() == 0) {
                        number = proc.getNumber();
                        if (number <= 0) {
                            number = 1;
                        }
                    } else {
                        number = 0;
                    }
                    getSourceStmt2.setInt(2, number);
                    rs = getSourceStmt2.executeQuery();
                    while (rs.next()) {
                        buffer.append(rs.getString(1));
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    try {
                        if (rs1 != null) {
                            rs1.close();
                        }
                    }
                    catch (Exception exception) {}
                    try {
                        if (rs != null) {
                            rs.close();
                        }
                        break block33;
                    }
                    catch (Exception exception) {}
                    break block33;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (rs1 != null) {
                        rs1.close();
                    }
                }
                catch (Exception exception) {}
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception exception) {}
                throw throwable;
            }
            try {
                if (rs1 != null) {
                    rs1.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
        }
        return buffer.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized void getAllTriggers(Connection connection, Table subjectTable, List list) {
        int id;
        PreparedStatement stmt1;
        Statement stmt;
        ResultSet rs1;
        ResultSet rs;
        block51: {
            rs = null;
            rs1 = null;
            stmt = null;
            stmt1 = null;
            String query1 = "select id from sysobjects where name=?";
            stmt1 = connection.prepareStatement(query1);
            stmt1.setString(1, subjectTable.getName());
            rs1 = stmt1.executeQuery();
            id = 0;
            if (rs1.next()) {
                id = rs1.getInt(1);
                break block51;
            }
            System.out.println(String.valueOf(subjectTable.getName()) + " does not exist!");
            try {
                if (rs1 != null) {
                    rs1.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (stmt1 != null) {
                    stmt1.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (stmt == null) return;
                stmt.close();
                return;
            }
            catch (Exception exception) {}
            return;
        }
        try {
            try {
                String query = "select O.name, user_name(O.uid) from sysobjects O where O.type='TR' and (O.deltrig=? or O.instrig=? or O.updtrig=?)";
                stmt = connection.prepareStatement(query);
                stmt.setInt(1, id);
                stmt.setInt(2, id);
                stmt.setInt(3, id);
                rs = stmt.executeQuery();
                while (rs.next()) {
                    String name = rs.getString(1);
                    String owner = rs.getString(2);
                    name = name != null ? name.trim() : "";
                    owner = owner != null ? owner.trim() : "";
                    SybaseASECatalogTrigger trigger = new SybaseASECatalogTrigger();
                    trigger.setName(name);
                    list.add(trigger);
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                try {
                    if (rs1 != null) {
                        rs1.close();
                    }
                }
                catch (Exception exception) {}
                try {
                    if (stmt1 != null) {
                        stmt1.close();
                    }
                }
                catch (Exception exception) {}
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception exception) {}
                try {
                    if (stmt == null) return;
                    stmt.close();
                    return;
                }
                catch (Exception exception) {}
                return;
            }
        }
        catch (Throwable throwable) {
            try {
                if (rs1 != null) {
                    rs1.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (stmt1 != null) {
                    stmt1.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (stmt == null) throw throwable;
                stmt.close();
                throw throwable;
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            if (rs1 != null) {
                rs1.close();
            }
        }
        catch (Exception exception) {}
        try {
            if (stmt1 != null) {
                stmt1.close();
            }
        }
        catch (Exception exception) {}
        try {
            if (rs != null) {
                rs.close();
            }
        }
        catch (Exception exception) {}
        try {
            if (stmt == null) return;
            stmt.close();
            return;
        }
        catch (Exception exception) {}
    }

    public static boolean isLogSegement(SybaseASESegment segment) {
        return segment != null && LOGSEGMENT.equals(segment.getName());
    }

    public static List getSchemaWithoutRole(SybaseASECatalog catalog) {
        EList authors = catalog.getAuthorizationIds();
        ArrayList<Object> owners = new ArrayList<Object>();
        int i = 0;
        while (i < authors.size()) {
            if (authors.get(i) instanceof SybaseASEUser) {
                owners.add(authors.get(i));
            }
            ++i;
        }
        ArrayList schemas = new ArrayList();
        int j = 0;
        while (j < owners.size()) {
            schemas.addAll(((SybaseASEUser)owners.get(j)).getOwnedSchema());
            ++j;
        }
        return schemas;
    }

    public static SybaseASERule findRule(Database database, String databaseName, String ownerName, String ruleName, boolean refresh, boolean caseSensitive) {
        if (database == null || ruleName == null) {
            return null;
        }
        Schema schema = ModelUtil.findSchema((Database)database, (String)databaseName, (String)ownerName);
        if (schema instanceof SybaseASESchema) {
            if (schema instanceof ICatalogObject && refresh) {
                ((ICatalogObject)schema).refresh();
            }
            int j = 0;
            while (j < ((SybaseASESchema)schema).getRules().size()) {
                if (((SybaseASESchema)schema).getRules().get(j) instanceof SybaseASERule && ModelUtil.equals((String)((SybaseASERule)((SybaseASESchema)schema).getRules().get(j)).getName(), (String)ruleName, (boolean)caseSensitive)) {
                    return (SybaseASERule)((SybaseASESchema)schema).getRules().get(j);
                }
                ++j;
            }
        }
        return null;
    }

    public static SybaseASEDefault findDefault(Database database, String databaseName, String ownerName, String defaultName, boolean refresh, boolean caseSensitive) {
        if (database == null || defaultName == null) {
            return null;
        }
        Schema schema = ModelUtil.findSchema((Database)database, (String)databaseName, (String)ownerName);
        if (schema instanceof SybaseASESchema) {
            if (schema instanceof ICatalogObject && refresh) {
                ((ICatalogObject)schema).refresh();
            }
            int j = 0;
            while (j < ((SybaseASESchema)schema).getDefaults().size()) {
                if (((SybaseASESchema)schema).getDefaults().get(j) instanceof SybaseASEDefault && ModelUtil.equals((String)((SybaseASEDefault)((SybaseASESchema)schema).getDefaults().get(j)).getName(), (String)defaultName, (boolean)caseSensitive)) {
                    return (SybaseASEDefault)((SybaseASESchema)schema).getDefaults().get(j);
                }
                ++j;
            }
        }
        return null;
    }
}

