/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.mysql.catalog.loaders;

import com.ibm.icu.text.MessageFormat;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.core.rte.jdbc.JDBCColumn;
import org.eclipse.datatools.connectivity.sqm.loader.JDBCTableConstraintLoader;
import org.eclipse.datatools.connectivity.sqm.loader.Messages;
import org.eclipse.datatools.enablement.mysql.catalog.MySqlCatalogForeignKey;
import org.eclipse.datatools.enablement.mysql.catalog.MySqlCatalogPrimaryKey;
import org.eclipse.datatools.enablement.mysql.catalog.MySqlCatalogTable;
import org.eclipse.datatools.modelbase.sql.constraints.ForeignKey;
import org.eclipse.datatools.modelbase.sql.constraints.Index;
import org.eclipse.datatools.modelbase.sql.constraints.PrimaryKey;
import org.eclipse.datatools.modelbase.sql.constraints.UniqueConstraint;
import org.eclipse.datatools.modelbase.sql.schema.ReferentialActionType;
import org.eclipse.datatools.modelbase.sql.tables.BaseTable;
import org.eclipse.datatools.modelbase.sql.tables.Column;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.emf.common.util.EList;

public class MySqlTableConstraintLoader
extends JDBCTableConstraintLoader {
    public MySqlTableConstraintLoader() {
        super(null, null);
    }

    protected ForeignKey createForeignKey() {
        return new MySqlCatalogForeignKey();
    }

    protected PrimaryKey createPrimaryKey() {
        return new MySqlCatalogPrimaryKey();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PrimaryKey loadPrimaryKey(PrimaryKey existingPK) throws SQLException {
        block14: {
            rs = null;
            try {
                columns = new HashMap<Integer, Column>();
                pk = null;
                rs = this.createPrimaryKeyResultSet();
                if (true) ** GOTO lbl33
            }
            catch (Throwable var8_10) {
                if (rs != null) {
                    this.closeResultSet(rs);
                }
                throw var8_10;
            }
lbl11:
            // 1 sources

            while (true) {
                this.closeResultSet(rs);
                return null;
            }
            {
                do {
                    columnName = rs.getString(4);
                    seq = rs.getInt(5);
                    if (existingPK != null && pkName.equals(existingPK.getName())) {
                        pk = existingPK;
                        pk.getMembers().clear();
                        if (existingPK instanceof ICatalogObject) {
                            ((ICatalogObject)pk).refresh();
                        }
                    } else {
                        pk = this.createPrimaryKey();
                        pk.setName(pkName);
                    }
                    do {
                        block15: {
                            if (seq > -1) {
                                columns.put(new Integer(seq), this.findColumn(columnName));
                            } else {
                                columns.put(new Integer(rs.getShort("KEY_SEQ")), this.findColumn(rs.getString("COLUMN_NAME")));
                            }
lbl33:
                            // 3 sources

                            if (rs.next()) break block15;
                            it = columns.values().iterator();
                            if (true) ** GOTO lbl46
                        }
                        seq = -1;
                        columnName = null;
                    } while (pk != null);
                } while ((pkName = rs.getString(6)) != null);
                if (rs == null) ** continue;
                ** continue;
                do {
                    pk.getMembers().add(it.next());
lbl46:
                    // 2 sources

                } while (it.hasNext());
                var9_9 = pk;
                if (rs == null) break block14;
            }
            this.closeResultSet(rs);
        }
        return var9_9;
    }

    protected ResultSet createForeignKeyResultSet() throws SQLException {
        return this.getCatalogObject().getConnection().getMetaData().getImportedKeys(null, null, this.getTable().getName());
    }

    protected ResultSet createPrimaryKeyResultSet() throws SQLException {
        return this.getCatalogObject().getConnection().getMetaData().getPrimaryKeys(null, null, this.getTable().getName());
    }

    protected ResultSet createUniqueConstraintResultSet() throws SQLException {
        try {
            return this.getCatalogObject().getConnection().getMetaData().getExportedKeys(null, null, this.getTable().getName());
        }
        catch (RuntimeException e) {
            SQLException error = new SQLException(MessageFormat.format((String)Messages.Error_Unsupported_DatabaseMetaData_Method, (Object[])new Object[]{"java.sql.DatabaseMetaData.getExportedKeys()"}));
            error.initCause(e);
            throw error;
        }
    }

    public void loadUniqueConstraints(PrimaryKey pk, List containmentList, Collection existingUCs) throws SQLException {
        ResultSet rs = null;
        if (pk != null) {
            existingUCs.remove(pk);
        }
        try {
            HashMap<String, UniqueConstraint> constraints = new HashMap<String, UniqueConstraint>();
            HashMap constraintColumns = new HashMap();
            rs = this.createUniqueConstraintResultSet();
            while (rs.next()) {
                String ucName = rs.getString("PKCOLUMN_NAME");
                if (ucName.equals(pk == null ? null : pk.getName()) || pk.getMembers() != null && pk.getMembers().get(0) instanceof JDBCColumn && ((JDBCColumn)pk.getMembers().get(0)).getName().equals(ucName)) continue;
                if (!constraints.containsKey(ucName)) {
                    UniqueConstraint uc = (UniqueConstraint)this.getAndRemoveSQLObject(existingUCs, ucName);
                    if (uc == null) {
                        uc = this.createUniqueConstraint();
                        uc.setName(ucName);
                    } else {
                        uc.getMembers().clear();
                        if (uc instanceof ICatalogObject) {
                            ((ICatalogObject)uc).refresh();
                        }
                    }
                    containmentList.add(uc);
                    constraints.put(ucName, uc);
                    constraintColumns.put(ucName, new TreeMap());
                }
                ((Map)constraintColumns.get(ucName)).put(new Integer(rs.getShort("KEY_SEQ")), this.findColumn(rs.getString("PKCOLUMN_NAME")));
            }
            for (Map.Entry entry : constraints.entrySet()) {
                UniqueConstraint uc = (UniqueConstraint)entry.getValue();
                Iterator colIt = ((Map)constraintColumns.get(uc.getName())).values().iterator();
                while (colIt.hasNext()) {
                    uc.getMembers().add(colIt.next());
                }
            }
        }
        catch (Throwable throwable) {
            if (rs != null) {
                this.closeResultSet(rs);
            }
            throw throwable;
        }
        if (rs != null) {
            this.closeResultSet(rs);
        }
    }

    private Table findFKTable(String fkTable_Name) {
        EList tables = this.getTable().getSchema().getTables();
        ListIterator iterator = tables.listIterator();
        while (iterator.hasNext()) {
            Table table = (Table)iterator.next();
            if (!table.getName().equals(fkTable_Name)) continue;
            return table;
        }
        return null;
    }

    public void loadForeignKeys(List containmentList, Collection existingFKs) throws SQLException {
        ResultSet rs = null;
        try {
            HashMap<String, ForeignKey> constraints = new HashMap<String, ForeignKey>();
            HashMap constraintColumns = new HashMap();
            rs = this.createForeignKeyResultSet();
            while (rs.next()) {
                String fkTable_Name = rs.getString("PKTABLE_NAME");
                String fkName = rs.getString("FK_NAME");
                MySqlCatalogTable fkTable = (MySqlCatalogTable)this.findFKTable(fkTable_Name);
                if (fkTable == null || fkName == null) continue;
                if (!constraints.containsKey(fkName)) {
                    ForeignKey fk = (ForeignKey)this.getAndRemoveSQLObject(existingFKs, fkName);
                    if (fk == null) {
                        fk = this.createForeignKey();
                        fk.setName(fkName);
                    } else {
                        fk.getMembers().clear();
                        if (fk instanceof ICatalogObject) {
                            ((ICatalogObject)fk).refresh();
                        }
                    }
                    if (fkTable.getPrimaryKey() != null) {
                        fk.setUniqueConstraint((UniqueConstraint)fkTable.getPrimaryKey());
                    } else {
                        Index index = fkTable.findIndexWithColumnName(rs.getString("PKCOLUMN_NAME"));
                        if (index != null) {
                            fk.setUniqueIndex(index);
                        }
                    }
                    short updateRule = rs.getShort("UPDATE_RULE");
                    switch (updateRule) {
                        case 0: {
                            fk.setOnUpdate(ReferentialActionType.CASCADE_LITERAL);
                            break;
                        }
                        case 1: {
                            fk.setOnUpdate(ReferentialActionType.RESTRICT_LITERAL);
                            break;
                        }
                        case 4: {
                            fk.setOnUpdate(ReferentialActionType.SET_DEFAULT_LITERAL);
                            break;
                        }
                        case 2: {
                            fk.setOnUpdate(ReferentialActionType.SET_NULL_LITERAL);
                            break;
                        }
                        case 3: {
                            fk.setOnUpdate(ReferentialActionType.NO_ACTION_LITERAL);
                            break;
                        }
                        default: {
                            fk.setOnUpdate(ReferentialActionType.CASCADE_LITERAL);
                        }
                    }
                    short deleteRule = rs.getShort("DELETE_RULE");
                    switch (deleteRule) {
                        case 0: {
                            fk.setOnDelete(ReferentialActionType.CASCADE_LITERAL);
                            break;
                        }
                        case 1: {
                            fk.setOnDelete(ReferentialActionType.RESTRICT_LITERAL);
                            break;
                        }
                        case 4: {
                            fk.setOnDelete(ReferentialActionType.SET_DEFAULT_LITERAL);
                            break;
                        }
                        case 2: {
                            fk.setOnDelete(ReferentialActionType.SET_NULL_LITERAL);
                            break;
                        }
                        case 3: {
                            fk.setOnDelete(ReferentialActionType.NO_ACTION_LITERAL);
                            break;
                        }
                        default: {
                            fk.setOnDelete(ReferentialActionType.CASCADE_LITERAL);
                        }
                    }
                    short deferrability = rs.getShort("DEFERRABILITY");
                    switch (deferrability) {
                        case 5: {
                            fk.setDeferrable(true);
                            fk.setInitiallyDeferred(true);
                            break;
                        }
                        case 6: {
                            fk.setDeferrable(true);
                            fk.setInitiallyDeferred(false);
                            break;
                        }
                        default: {
                            fk.setDeferrable(false);
                        }
                    }
                    String columnName = rs.getString("FKCOLUMN_NAME");
                    Column column = this.findColumn(columnName);
                    fk.getMembers().add((Object)column);
                    UniqueConstraint uk = this.findUniqueConstraint(rs.getString("PKTABLE_CAT"), rs.getString("PKTABLE_SCHEM"), rs.getString("PKTABLE_NAME"), rs.getString("PK_NAME"));
                    if (uk == null) continue;
                    fk.setUniqueConstraint(uk);
                    containmentList.add(fk);
                    constraints.put(fkName, fk);
                    constraintColumns.put(fkName, new TreeMap());
                }
                ((Map)constraintColumns.get(fkName)).put(new Integer(rs.getShort("KEY_SEQ")), this.findColumn(rs.getString("FKCOLUMN_NAME")));
            }
            for (Map.Entry entry : constraints.entrySet()) {
                ForeignKey fk = (ForeignKey)entry.getValue();
                Iterator colIt = ((Map)constraintColumns.get(fk.getName())).values().iterator();
                while (colIt.hasNext()) {
                    fk.getMembers().add(colIt.next());
                }
                this.initReferenceAnnotation(fk);
            }
        }
        catch (Throwable throwable) {
            if (rs != null) {
                this.closeResultSet(rs);
            }
            throw throwable;
        }
        if (rs != null) {
            this.closeResultSet(rs);
        }
    }

    protected UniqueConstraint findUniqueConstraint(String catalogName, String schemaName, String tableName, String keyName) {
        Table table = this.findTable(catalogName, schemaName, tableName);
        if (table == null || !(table instanceof BaseTable)) {
            return null;
        }
        keyName = ((MySqlCatalogTable)table).getPrimaryKey().getName();
        for (UniqueConstraint uc : ((BaseTable)table).getUniqueConstraints()) {
            if (!keyName.equals(uc.getName())) continue;
            return uc;
        }
        return null;
    }

    protected Table findTable(String catalogName, String schemaName, String tableName) {
        if (tableName == null) {
            return null;
        }
        if (catalogName == null) {
            catalogName = this.getTable().getSchema().getCatalog().getName();
            try {
                if (this.getCatalogObject().getConnection().getMetaData().supportsCatalogsInTableDefinitions()) {
                    catalogName = new String();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        if (schemaName == null) {
            schemaName = this.getTable().getSchema().getName();
            try {
                if (this.getCatalogObject().getConnection().getMetaData().supportsSchemasInTableDefinitions()) {
                    schemaName = new String();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        for (Table table : this.getTable().getSchema().getTables()) {
            if (!tableName.equals(table.getName())) continue;
            return table;
        }
        return null;
    }
}

