/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.ibm.db2.luw.catalog;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.core.rte.RefreshManager;
import org.eclipse.datatools.connectivity.sqm.internal.core.RDBCorePlugin;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.LUWCatalogDatabase;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.LUWCatalogPrivilege;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.LUWOverwriteStatus;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.util.LUWUtil;
import org.eclipse.datatools.enablement.ibm.util.ModelHelper;
import org.eclipse.datatools.modelbase.dbdefinition.PredefinedDataTypeDefinition;
import org.eclipse.datatools.modelbase.sql.accesscontrol.AuthorizationIdentifier;
import org.eclipse.datatools.modelbase.sql.accesscontrol.Privilege;
import org.eclipse.datatools.modelbase.sql.datatypes.DataType;
import org.eclipse.datatools.modelbase.sql.datatypes.PredefinedDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.SQLDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.UserDefinedType;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.datatools.modelbase.sql.schema.Sequence;
import org.eclipse.datatools.modelbase.sql.schema.impl.SequenceImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;

public class LUWCatalogSequence
extends SequenceImpl
implements ICatalogObject {
    private int dataTypeId;
    private int precision;
    private boolean dataTypeLoaded = false;
    private boolean privilegeLoaded = false;

    public void refresh() {
        this.dataTypeLoaded = false;
        this.privilegeLoaded = false;
        RefreshManager.getInstance().referesh((ICatalogObject)this);
    }

    public boolean isSystemObject() {
        return false;
    }

    public Connection getConnection() {
        Database database = this.getCatalogDatabase();
        return ((LUWCatalogDatabase)database).getConnection();
    }

    public Database getCatalogDatabase() {
        return this.getSchema().getDatabase();
    }

    public UserDefinedType getReferencedType() {
        if (LUWOverwriteStatus.IS_OVERWRITE) {
            return super.getReferencedType();
        }
        if (!this.dataTypeLoaded) {
            this.loadDataType();
        }
        return super.getReferencedType();
    }

    public SQLDataType getContainedType() {
        if (LUWOverwriteStatus.IS_OVERWRITE) {
            return super.getContainedType();
        }
        if (!this.dataTypeLoaded) {
            this.loadDataType();
        }
        return super.getContainedType();
    }

    public DataType getDataType() {
        if (LUWOverwriteStatus.IS_OVERWRITE) {
            return super.getDataType();
        }
        if (!this.dataTypeLoaded) {
            this.loadDataType();
        }
        return super.getDataType();
    }

    public EList getPrivileges() {
        if (LUWOverwriteStatus.IS_OVERWRITE) {
            return super.getPrivileges();
        }
        if (!this.privilegeLoaded) {
            this.loadPrivileges();
        }
        return this.privileges;
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        int id = this.eDerivedStructuralFeatureID(eFeature);
        if (id == 8) {
            this.getContainedType();
        } else if (id == 9) {
            this.getReferencedType();
        } else if (id == 7) {
            this.getPrivileges();
        }
        return super.eIsSet(eFeature);
    }

    public void setDataTypeId(int id) {
        this.dataTypeId = id;
    }

    public void setPrecision(int p) {
        this.precision = p;
    }

    private synchronized void loadDataType() {
        if (this.dataTypeLoaded) {
            return;
        }
        this.dataTypeLoaded = true;
        try {
            Connection connection = this.getConnection();
            Statement s = connection.createStatement();
            ResultSet r = s.executeQuery("SELECT TYPENAME FROM SYSCAT.DATATYPES WHERE TYPEID=" + Integer.toString(this.dataTypeId));
            while (r.next()) {
                String typeName = r.getString(1);
                DatabaseDefinition databaseDefinition = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(this.getCatalogDatabase());
                PredefinedDataTypeDefinition typeDefinition = databaseDefinition.getPredefinedDataTypeDefinition(typeName);
                if (typeDefinition == null) continue;
                PredefinedDataType type = databaseDefinition.getPredefinedDataType(typeDefinition);
                if (typeDefinition.isPrecisionSupported()) {
                    EStructuralFeature feature = type.eClass().getEStructuralFeature("precision");
                    type.eSet(feature, (Object)new Integer(this.precision));
                }
                this.setContainedType((SQLDataType)type);
            }
            r.close();
            s.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private synchronized void loadPrivileges() {
        if (this.privilegeLoaded) {
            return;
        }
        this.privilegeLoaded = true;
        EList privileges = super.getPrivileges();
        for (Privilege privilege : privileges) {
            privilege.setGrantor(null);
            privilege.setGrantee(null);
        }
        privileges.clear();
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        try {
            LUWCatalogSequence.loadPrivileges(this.getConnection(), privileges, (Sequence)this, "");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.eSetDeliver(deliver);
    }

    public static void loadPrivileges(Connection connection, EList privilegeList, Sequence sequence, String granteeFilter) throws SQLException {
        Schema schema = sequence.getSchema();
        Database database = ModelHelper.getDatabase((Schema)schema);
        int options = ((LUWCatalogDatabase)database).getLoadOptions();
        if ((options & 0x800) == 2048) {
            return;
        }
        Statement s = connection.createStatement();
        String query = "SELECT GRANTOR,GRANTEE,GRANTEETYPE,USAGEAUTH,ALTERAUTH FROM SYSCAT.SEQUENCEAUTH WHERE SEQSCHEMA='" + LUWUtil.getIdentifier(schema.getName()) + "'" + " AND SEQNAME='" + LUWUtil.getIdentifier(sequence.getName()) + "'";
        if (granteeFilter != null && !"".equals(granteeFilter)) {
            query = String.valueOf(query) + " AND " + granteeFilter;
        }
        ResultSet r = s.executeQuery(query);
        try {
            String userName = connection.getMetaData().getUserName();
            while (r.next()) {
                String deleteAuth;
                String grantorId = r.getString("GRANTOR").trim();
                AuthorizationIdentifier grantor = LUWCatalogDatabase.getAuthorizationId(database, grantorId, null);
                String granteeId = r.getString("GRANTEE").trim();
                AuthorizationIdentifier grantee = null;
                String granteeType = r.getString("GRANTEETYPE");
                grantee = "G".equals(granteeType) ? LUWCatalogDatabase.getAuthorizationId(database, granteeId, "G") : ("R".equals(granteeType) ? LUWCatalogDatabase.getAuthorizationId(database, granteeId, "R") : LUWCatalogDatabase.getAuthorizationId(database, granteeId, "U"));
                boolean isSystemGranted = granteeId.equalsIgnoreCase(userName);
                LUWCatalogPrivilege privilege = null;
                String alterAuth = r.getString("USAGEAUTH");
                if (!alterAuth.equals("N")) {
                    privilege = new LUWCatalogPrivilege();
                    privilege.setAction("USAGE");
                    if (alterAuth.equals("G")) {
                        privilege.setGrantable(true);
                    }
                    privilegeList.add((Object)privilege);
                    privilege.setGrantor(grantor);
                    privilege.setGrantee(grantee);
                    LUWCatalogPrivilege.setAsSystemGranted((Privilege)privilege, isSystemGranted);
                }
                if ((deleteAuth = r.getString("ALTERAUTH")).equals("N")) continue;
                privilege = new LUWCatalogPrivilege();
                privilege.setAction("ALTER");
                if (deleteAuth.equals("G")) {
                    privilege.setGrantable(true);
                }
                privilegeList.add((Object)privilege);
                privilege.setGrantor(grantor);
                privilege.setGrantee(grantee);
                LUWCatalogPrivilege.setAsSystemGranted((Privilege)privilege, isSystemGranted);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        r.close();
        s.close();
    }

    protected void getPrivilegesWithFilter(String granteeFilter) throws SQLException {
        if (this.privilegeLoaded) {
            return;
        }
        EList privileges = super.getPrivileges();
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        try {
            LUWCatalogSequence.loadPrivileges(this.getConnection(), privileges, (Sequence)this, granteeFilter);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.eSetDeliver(deliver);
    }
}

